/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnailNumberRegistry
extends SavedData {
    private static final String DATA_NAME = "transponder_snails_registry";
    private static final int MIN_SNAIL_NUMBER = 1000;
    private static final int MAX_SNAIL_NUMBER = 9999;
    private static final int TOTAL_POSSIBLE_NUMBERS = 9000;
    private final Map<UUID, Integer> snailToNumber = new HashMap<UUID, Integer>();
    private final Map<Integer, UUID> numberToSnail = new HashMap<Integer, UUID>();
    private final Set<Integer> assignedNumbers = new HashSet<Integer>();
    private static SnailNumberRegistry instance = null;

    private SnailNumberRegistry() {
    }

    @Nullable
    public static SnailNumberRegistry getInstance() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        if (instance == null) {
            ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129783_();
            instance = (SnailNumberRegistry)overworld.m_8895_().m_164861_(SnailNumberRegistry::load, SnailNumberRegistry::new, DATA_NAME);
        }
        return instance;
    }

    public synchronized int assignNumberToSnail(@NotNull UUID snailUUID) {
        if (this.snailToNumber.containsKey(snailUUID)) {
            return this.snailToNumber.get(snailUUID);
        }
        if (this.assignedNumbers.size() >= 9000) {
            System.err.println("SnailNumberRegistry: All snail numbers have been assigned! Cannot assign to UUID: " + snailUUID);
            return -1;
        }
        int newNumber = this.generateUniqueNumber();
        if (newNumber == -1) {
            System.err.println("SnailNumberRegistry: Failed to generate unique number for UUID: " + snailUUID);
            return -1;
        }
        this.snailToNumber.put(snailUUID, newNumber);
        this.numberToSnail.put(newNumber, snailUUID);
        this.assignedNumbers.add(newNumber);
        this.m_77762_();
        System.out.println("SnailNumberRegistry: Assigned number " + newNumber + " to snail " + snailUUID);
        return newNumber;
    }

    public int getSnailNumber(@NotNull UUID snailUUID) {
        return this.snailToNumber.getOrDefault(snailUUID, -1);
    }

    @Nullable
    public UUID getSnailByNumber(int snailNumber) {
        return this.numberToSnail.get(snailNumber);
    }

    public boolean isNumberAssigned(int snailNumber) {
        return this.assignedNumbers.contains(snailNumber);
    }

    public int getAssignedCount() {
        return this.assignedNumbers.size();
    }

    public int getAvailableCount() {
        return 9000 - this.assignedNumbers.size();
    }

    public synchronized boolean removeSnailAssignment(@NotNull UUID snailUUID) {
        Integer number = this.snailToNumber.remove(snailUUID);
        if (number != null) {
            this.numberToSnail.remove(number);
            this.assignedNumbers.remove(number);
            this.m_77762_();
            System.out.println("SnailNumberRegistry: Removed assignment of number " + number + " from snail " + snailUUID);
            return true;
        }
        return false;
    }

    private int generateUniqueNumber() {
        int number;
        if ((double)this.assignedNumbers.size() > 7200.0) {
            for (int number2 = 1000; number2 <= 9999; ++number2) {
                if (this.assignedNumbers.contains(number2)) continue;
                return number2;
            }
            return -1;
        }
        int maxAttempts = 1000;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            number = ThreadLocalRandom.current().nextInt(1000, 10000);
            if (this.assignedNumbers.contains(number)) continue;
            return number;
        }
        for (number = 1000; number <= 9999; ++number) {
            if (this.assignedNumbers.contains(number)) continue;
            return number;
        }
        return -1;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        ListTag assignmentsList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.snailToNumber.entrySet()) {
            CompoundTag assignmentTag = new CompoundTag();
            assignmentTag.m_128359_("uuid", entry.getKey().toString());
            assignmentTag.m_128405_("number", entry.getValue().intValue());
            assignmentsList.add((Object)assignmentTag);
        }
        compound.m_128365_("assignments", (Tag)assignmentsList);
        compound.m_128405_("total_assigned", this.assignedNumbers.size());
        compound.m_128405_("registry_version", 1);
        System.out.println("SnailNumberRegistry: Saved " + this.assignedNumbers.size() + " snail number assignments");
        return compound;
    }

    public static SnailNumberRegistry load(CompoundTag compound) {
        SnailNumberRegistry registry = new SnailNumberRegistry();
        if (compound.m_128425_("assignments", 9)) {
            ListTag assignmentsList = compound.m_128437_("assignments", 10);
            for (int i = 0; i < assignmentsList.size(); ++i) {
                CompoundTag assignmentTag = assignmentsList.m_128728_(i);
                try {
                    UUID snailUUID = UUID.fromString(assignmentTag.m_128461_("uuid"));
                    int number = assignmentTag.m_128451_("number");
                    if (number >= 1000 && number <= 9999) {
                        registry.snailToNumber.put(snailUUID, number);
                        registry.numberToSnail.put(number, snailUUID);
                        registry.assignedNumbers.add(number);
                        continue;
                    }
                    System.err.println("SnailNumberRegistry: Loaded invalid snail number " + number + " for UUID " + snailUUID + ", skipping");
                    continue;
                }
                catch (IllegalArgumentException e) {
                    System.err.println("SnailNumberRegistry: Failed to load assignment entry at index " + i + ": " + e.getMessage());
                }
            }
        }
        System.out.println("SnailNumberRegistry: Loaded " + registry.assignedNumbers.size() + " snail number assignments");
        return registry;
    }

    public void debugPrintState() {
        System.out.println("=== SnailNumberRegistry Debug Info ===");
        System.out.println("Assigned numbers: " + this.assignedNumbers.size() + "/9000");
        System.out.println("Available numbers: " + this.getAvailableCount());
        if (this.assignedNumbers.size() <= 20) {
            System.out.println("Current assignments:");
            for (Map.Entry<UUID, Integer> entry : this.snailToNumber.entrySet()) {
                System.out.println("  " + entry.getKey() + " -> #" + entry.getValue());
            }
        }
        System.out.println("=====================================");
    }

    public synchronized int clearAllAssignments() {
        int clearedCount = this.assignedNumbers.size();
        this.snailToNumber.clear();
        this.numberToSnail.clear();
        this.assignedNumbers.clear();
        this.m_77762_();
        System.out.println("SnailNumberRegistry: CLEARED ALL ASSIGNMENTS - " + clearedCount + " numbers freed");
        return clearedCount;
    }

    public synchronized int restoreSnailAssignment(@NotNull UUID snailUUID, int preferredNumber) {
        int newNumber;
        System.out.println("SnailNumberRegistry: Attempting to restore assignment for UUID " + snailUUID + " with preferred number #" + preferredNumber);
        if (this.snailToNumber.containsKey(snailUUID)) {
            int existingNumber = this.snailToNumber.get(snailUUID);
            System.out.println("SnailNumberRegistry: UUID already has assignment #" + existingNumber);
            return existingNumber;
        }
        if (preferredNumber >= 1000 && preferredNumber <= 9999) {
            if (!this.assignedNumbers.contains(preferredNumber)) {
                this.snailToNumber.put(snailUUID, preferredNumber);
                this.numberToSnail.put(preferredNumber, snailUUID);
                this.assignedNumbers.add(preferredNumber);
                this.m_77762_();
                System.out.println("SnailNumberRegistry: Restored preferred assignment #" + preferredNumber + " to UUID " + snailUUID);
                return preferredNumber;
            }
            System.out.println("SnailNumberRegistry: Preferred number #" + preferredNumber + " is no longer available");
        }
        if ((newNumber = this.generateUniqueNumber()) != -1) {
            this.snailToNumber.put(snailUUID, newNumber);
            this.numberToSnail.put(newNumber, snailUUID);
            this.assignedNumbers.add(newNumber);
            this.m_77762_();
            System.out.println("SnailNumberRegistry: Restored with new assignment #" + newNumber + " to UUID " + snailUUID);
            return newNumber;
        }
        System.err.println("SnailNumberRegistry: Failed to restore assignment for UUID " + snailUUID + " - no numbers available");
        return -1;
    }

    public void forceSave() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            System.err.println("SnailNumberRegistry: Cannot force save - server not available");
            return;
        }
        try {
            ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129783_();
            overworld.m_8895_().m_78151_();
            System.out.println("SnailNumberRegistry: Forced save completed with " + this.assignedNumbers.size() + " assignments");
        }
        catch (Exception e) {
            System.err.println("SnailNumberRegistry: Error during force save: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void debugPrintStateWithSave() {
        this.debugPrintState();
        try {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129783_();
                System.out.println("SnailNumberRegistry: DataStorage location: " + overworld.m_8895_().toString());
                this.m_77762_();
                overworld.m_8895_().m_78151_();
                System.out.println("SnailNumberRegistry: Force save completed");
            }
        }
        catch (Exception e) {
            System.err.println("SnailNumberRegistry: Error during save validation: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void resetInstance() {
        instance = null;
    }
}

