/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.event;

import net.eclipce.transpondersnails.block.ModBlocks;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.entity.client.DenDenMushiModel;
import net.eclipce.transpondersnails.entity.client.ModModelLayers;
import net.eclipce.transpondersnails.entity.client.TransponderSnailItemProperties;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.eclipce.transpondersnails.item.ModItems;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="transpondersnails", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModEventBusClientEvents {
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.DEN_DEN_MUSHI_LAYER, DenDenMushiModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerItemModelPredicates(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.DEN_DEN_MUSHI.get()), (ResourceLocation)new ResourceLocation("transpondersnails", "shell_color"), (stack, world, entity, seed) -> {
                int shellColor = DenDenMushiItem.getShellColor(stack);
                float predicateValue = (float)shellColor / 100.0f;
                return predicateValue;
            });
            ItemProperties.register((Item)((Item)ModItems.DEN_DEN_MUSHI.get()), (ResourceLocation)new ResourceLocation("transpondersnails", "captured"), (stack, world, entity, seed) -> DenDenMushiItem.isCaptured(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Block)ModBlocks.TRANSPONDER_SNAIL.get()).m_5456_(), (ResourceLocation)new ResourceLocation("transpondersnails", "shell_color"), (stack, world, entity, seed) -> {
                CompoundTag nbt = stack.m_41783_();
                if (nbt != null) {
                    CompoundTag beTag;
                    if (nbt.m_128441_("shell_color")) {
                        return (float)nbt.m_128451_("shell_color") / 100.0f;
                    }
                    if (nbt.m_128441_("BlockEntityTag") && (beTag = nbt.m_128469_("BlockEntityTag")).m_128441_("ShellColor")) {
                        return (float)beTag.m_128451_("ShellColor") / 100.0f;
                    }
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Block)ModBlocks.TRANSPONDER_SNAIL.get()).m_5456_(), (ResourceLocation)new ResourceLocation("transpondersnails", "call_state"), TransponderSnailItemProperties::calculateCallState);
            System.out.println("TransponderSnails: Registered item properties for dynamic models");
        });
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        String[] states = new String[]{"transponder_snail", "transponder_snail_sound", "transponder_snail_call", "transponder_snail_active"};
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (String state : states) {
            for (String color : colors) {
                event.register(new ResourceLocation("transpondersnails", "block/" + state + "_shell_" + color));
            }
        }
        System.out.println("Registered 64 transponder snail model variants for BER");
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            if (!(stack.m_41720_() instanceof DenDenMushiItem)) {
                return -1;
            }
            if (tintIndex == 0 && DenDenMushiItem.isCaptured(stack)) {
                return DenDenMushiItem.getBodyColor(stack);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModItems.DEN_DEN_MUSHI.get()});
        event.register((stack, tintIndex) -> {
            CompoundTag nbt;
            if (tintIndex == 0 && (nbt = stack.m_41783_()) != null) {
                CompoundTag beTag;
                if (nbt.m_128441_("body_color")) {
                    return nbt.m_128451_("body_color");
                }
                if (nbt.m_128441_("BlockEntityTag") && (beTag = nbt.m_128469_("BlockEntityTag")).m_128441_("BodyColor")) {
                    return beTag.m_128451_("BodyColor");
                }
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModBlocks.TRANSPONDER_SNAIL.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0 && level != null && pos != null) {
                BlockEntity be = level.m_7702_(pos);
                if (be instanceof TransponderSnailBlockEntity) {
                    TransponderSnailBlockEntity snailBE = (TransponderSnailBlockEntity)be;
                    int color = snailBE.getBodyColor();
                    System.out.println("BlockColors handler - Position: " + pos + ", Body color: #" + Integer.toHexString(color) + ", Initialized: " + snailBE.isColorsInitialized());
                    return color;
                }
                System.out.println("BlockColors handler - Position: " + pos + ", BE is null or wrong type");
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.TRANSPONDER_SNAIL.get()});
    }
}

