/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.eclipce.transpondersnails.item.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="transpondersnails")
public class StonecutterEventHandler {
    private static final Map<UUID, ItemStack> lastInputs = new HashMap<UUID, ItemStack>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().f_46443_) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = event.player.f_36096_;
        if (abstractContainerMenu instanceof StonecutterMenu) {
            ItemStack storedInput;
            ItemStack result;
            StonecutterMenu menu = (StonecutterMenu)abstractContainerMenu;
            UUID playerId = event.player.m_20148_();
            ItemStack input = menu.m_38853_(0).m_7993_();
            if (!input.m_41619_() && input.m_41720_() == ModItems.TRANSPONDER_SNAIL.get()) {
                lastInputs.put(playerId, input.m_41777_());
            }
            if (!(result = menu.m_38853_(1).m_7993_()).m_41619_() && result.m_41720_() == ModItems.DEN_DEN_MUSHI.get() && (storedInput = lastInputs.get(playerId)) != null && !storedInput.m_41619_()) {
                StonecutterEventHandler.transferColors(storedInput, result);
            }
        } else {
            lastInputs.remove(event.player.m_20148_());
        }
    }

    private static void transferColors(ItemStack transponderSnail, ItemStack denDenMushi) {
        CompoundTag nbt = transponderSnail.m_41783_();
        if (nbt == null) {
            return;
        }
        int bodyColor = -1;
        int shellColor = -1;
        if (nbt.m_128441_("body_color")) {
            bodyColor = nbt.m_128451_("body_color");
        }
        if (nbt.m_128441_("shell_color")) {
            shellColor = nbt.m_128451_("shell_color");
        }
        if (nbt.m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = nbt.m_128469_("BlockEntityTag");
            if (bodyColor == -1 && blockEntityTag.m_128441_("BodyColor")) {
                bodyColor = blockEntityTag.m_128451_("BodyColor");
            }
            if (shellColor == -1 && blockEntityTag.m_128441_("ShellColor")) {
                shellColor = blockEntityTag.m_128451_("ShellColor");
            }
        }
        if (bodyColor != -1 && shellColor != -1) {
            DenDenMushiItem.setColors(denDenMushi, bodyColor, shellColor);
            DenDenMushiItem.setCaptured(denDenMushi, true);
            System.out.println("StonecutterEventHandler: Transferred colors - Body: #" + Integer.toHexString(bodyColor) + ", Shell: " + shellColor);
        }
    }
}

