/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.item;

import java.util.List;
import net.eclipce.transpondersnails.entity.ModEntities;
import net.eclipce.transpondersnails.entity.custom.DenDenMushiEntity;
import net.eclipce.transpondersnails.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DenDenMushiItem
extends Item {
    private static final String BODY_COLOR_TAG = "BodyColor";
    private static final String SHELL_COLOR_TAG = "ShellColor";
    private static final String ENTITY_DATA_TAG = "EntityData";

    public DenDenMushiItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack createWithColors(int bodyColor, int shellColor) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DEN_DEN_MUSHI.get());
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(BODY_COLOR_TAG, bodyColor);
        nbt.m_128405_(SHELL_COLOR_TAG, shellColor);
        return stack;
    }

    public static ItemStack createFromEntity(DenDenMushiEntity entity) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DEN_DEN_MUSHI.get());
        CompoundTag nbt = stack.m_41784_();
        int entityShellColor = entity.getShellColor();
        int entityBodyColor = entity.getBodyColor();
        nbt.m_128405_(BODY_COLOR_TAG, entityBodyColor);
        nbt.m_128405_(SHELL_COLOR_TAG, entityShellColor);
        CompoundTag entityData = new CompoundTag();
        entity.m_7380_(entityData);
        nbt.m_128365_(ENTITY_DATA_TAG, (Tag)entityData);
        System.out.println("===================================");
        return stack;
    }

    public static void applyToEntity(ItemStack stack, DenDenMushiEntity entity) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        if (nbt.m_128441_(BODY_COLOR_TAG)) {
            entity.setBodyColor(nbt.m_128451_(BODY_COLOR_TAG));
        }
        if (nbt.m_128441_(SHELL_COLOR_TAG)) {
            entity.setShellColor(nbt.m_128451_(SHELL_COLOR_TAG));
        }
        if (nbt.m_128441_(ENTITY_DATA_TAG)) {
            CompoundTag entityData = nbt.m_128469_(ENTITY_DATA_TAG);
            entity.m_7378_(entityData);
        }
    }

    public static int getBodyColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(BODY_COLOR_TAG)) {
            return nbt.m_128451_(BODY_COLOR_TAG);
        }
        return 16115363;
    }

    public static int getShellColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(SHELL_COLOR_TAG)) {
            int color = nbt.m_128451_(SHELL_COLOR_TAG);
            return color;
        }
        return 0;
    }

    public static void setColors(ItemStack stack, int bodyColor, int shellColor) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof DenDenMushiItem)) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(BODY_COLOR_TAG, bodyColor);
        nbt.m_128405_(SHELL_COLOR_TAG, shellColor);
    }

    public static void setCaptured(ItemStack stack, boolean captured) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof DenDenMushiItem)) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128379_("IsCaptured", captured);
    }

    public static boolean isCaptured(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(BODY_COLOR_TAG);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        DenDenMushiEntity entity;
        Direction face;
        BlockPos pos;
        BlockPos spawnPos;
        Level level = context.m_43725_();
        if (!level.f_46443_ && level.m_8055_(spawnPos = (pos = context.m_8083_()).m_121945_(face = context.m_43719_())).m_60795_() && level.m_8055_(spawnPos.m_7495_()).m_280296_() && (entity = (DenDenMushiEntity)((EntityType)ModEntities.DEN_DEN_MUSHI.get()).m_20615_(level)) != null) {
            entity.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            DenDenMushiItem.applyToEntity(context.m_43722_(), entity);
            level.m_7967_((Entity)entity);
            level.m_6263_(null, (double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_(), SoundEvents.f_12470_, SoundSource.BLOCKS, 0.5f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            if (!context.m_43723_().m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (DenDenMushiItem.isCaptured(stack)) {
            tooltip.add((Component)Component.m_237113_((String)"Captured Den Den Mushi").m_130940_(ChatFormatting.GRAY));
            if (flag.m_7050_()) {
                int bodyColor = DenDenMushiItem.getBodyColor(stack);
                tooltip.add((Component)Component.m_237113_((String)("Body: #" + String.format("%06X", bodyColor).toUpperCase())).m_130940_(ChatFormatting.DARK_GRAY));
                int shellColorId = DenDenMushiItem.getShellColor(stack);
                DyeColor shellColor = DyeColor.m_41053_((int)shellColorId);
                tooltip.add((Component)Component.m_237113_((String)("Shell: " + shellColor.m_41065_().substring(0, 1).toUpperCase() + shellColor.m_41065_().substring(1))).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)"Wild Den Den Mushi").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)Component.m_237113_((String)"Right-click to place").m_130940_(ChatFormatting.GRAY));
        }
    }

    public String getShellVariant(ItemStack stack) {
        int shellColorId = DenDenMushiItem.getShellColor(stack);
        DyeColor shellColor = DyeColor.m_41053_((int)shellColorId);
        return "den_den_mushi_shell_" + shellColor.m_41065_();
    }
}

