/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network;

import net.eclipce.transpondersnails.network.packets.CallInitiationPacket;
import net.eclipce.transpondersnails.network.packets.CallResponsePacket;
import net.eclipce.transpondersnails.network.packets.CallStateSyncPacket;
import net.eclipce.transpondersnails.network.packets.DialDigitPacket;
import net.eclipce.transpondersnails.network.packets.DialedNumberSyncPacket;
import net.eclipce.transpondersnails.network.packets.SnailNumberRequestPacket;
import net.eclipce.transpondersnails.network.packets.SnailNumberSyncPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModPackets {
    private static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel CHANNEL;
    private static int nextId;

    public static void init() {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("transpondersnails", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        nextId = 0;
        CHANNEL.messageBuilder(CallInitiationPacket.class, nextId++, NetworkDirection.PLAY_TO_SERVER).decoder(CallInitiationPacket::new).encoder(CallInitiationPacket::encode).consumerMainThread(CallInitiationPacket::handle).add();
        CHANNEL.messageBuilder(SnailNumberSyncPacket.class, nextId++, NetworkDirection.PLAY_TO_CLIENT).decoder(SnailNumberSyncPacket::new).encoder(SnailNumberSyncPacket::encode).consumerMainThread(SnailNumberSyncPacket::handle).add();
        CHANNEL.messageBuilder(SnailNumberRequestPacket.class, nextId++, NetworkDirection.PLAY_TO_SERVER).decoder(SnailNumberRequestPacket::new).encoder(SnailNumberRequestPacket::encode).consumerMainThread(SnailNumberRequestPacket::handle).add();
        CHANNEL.messageBuilder(DialDigitPacket.class, nextId++, NetworkDirection.PLAY_TO_SERVER).decoder(DialDigitPacket::new).encoder(DialDigitPacket::encode).consumerMainThread(DialDigitPacket::handle).add();
        CHANNEL.messageBuilder(DialedNumberSyncPacket.class, nextId++, NetworkDirection.PLAY_TO_CLIENT).decoder(DialedNumberSyncPacket::new).encoder(DialedNumberSyncPacket::encode).consumerMainThread(DialedNumberSyncPacket::handle).add();
        CHANNEL.messageBuilder(CallStateSyncPacket.class, nextId++, NetworkDirection.PLAY_TO_CLIENT).decoder(CallStateSyncPacket::new).encoder(CallStateSyncPacket::encode).consumerMainThread(CallStateSyncPacket::handle).add();
        CHANNEL.messageBuilder(CallResponsePacket.class, nextId++, NetworkDirection.PLAY_TO_SERVER).decoder(CallResponsePacket::new).encoder(CallResponsePacket::encode).consumerMainThread(CallResponsePacket::handle).add();
        System.out.println("ModPackets: Registered " + nextId + " packet types");
    }

    public static <MSG> void sendToServer(MSG msg) {
        if (CHANNEL != null) {
            CHANNEL.sendToServer(msg);
        }
    }

    public static <MSG> void sendToPlayer(MSG msg, ServerPlayer player) {
        if (CHANNEL != null) {
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
        }
    }

    public static <MSG> void sendToAllPlayers(MSG msg) {
        if (CHANNEL != null) {
            CHANNEL.send(PacketDistributor.ALL.noArg(), msg);
        }
    }

    public static <MSG> void sendToPlayersNear(MSG msg, ServerPlayer player, double range) {
        if (CHANNEL != null) {
            CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), range, player.m_9236_().m_46472_())), msg);
        }
    }

    public static <MSG> void sendToPlayers(MSG msg, Iterable<ServerPlayer> players) {
        if (CHANNEL != null) {
            for (ServerPlayer player : players) {
                ModPackets.sendToPlayer(msg, player);
            }
        }
    }

    static {
        nextId = 0;
    }
}

