/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CallResponsePacket {
    private final Response response;
    private final UUID callId;

    public CallResponsePacket(Response response, UUID callId) {
        this.response = response;
        this.callId = callId;
    }

    public CallResponsePacket(FriendlyByteBuf buf) {
        this.response = (Response)buf.m_130066_(Response.class);
        this.callId = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.response);
        buf.m_130077_(this.callId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (callManager == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Voice chat system not available!").m_130940_(ChatFormatting.RED));
                return;
            }
            try {
                switch (this.response) {
                    case ACCEPT: {
                        this.handleAcceptCall(callManager, player, this.callId);
                        break;
                    }
                    case REJECT: {
                        this.handleRejectCall(callManager, player, this.callId);
                        break;
                    }
                    case HANG_UP: {
                        this.handleHangUp(callManager, player, this.callId);
                        break;
                    }
                    default: {
                        System.err.println("CallResponsePacket: Unknown response type: " + this.response);
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("CallResponsePacket: Error handling call response: " + e.getMessage());
                e.printStackTrace();
                player.m_213846_((Component)Component.m_237113_((String)("Error processing call response: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleAcceptCall(TransponderCallManager callManager, ServerPlayer player, UUID callId) {
        System.out.println("CallResponsePacket: Player " + player.m_7755_().getString() + " accepting call " + callId.toString().substring(0, 8));
        boolean success = callManager.acceptCall(player, callId);
        if (success) {
            System.out.println("CallResponsePacket: Successfully accepted call");
        } else {
            System.err.println("CallResponsePacket: Failed to accept call");
        }
    }

    private void handleRejectCall(TransponderCallManager callManager, ServerPlayer player, UUID callId) {
        System.out.println("CallResponsePacket: Player " + player.m_7755_().getString() + " rejecting call " + callId.toString().substring(0, 8));
        boolean success = callManager.rejectCall(player, callId);
        if (success) {
            System.out.println("CallResponsePacket: Successfully rejected call");
        } else {
            System.err.println("CallResponsePacket: Failed to reject call");
        }
    }

    private void handleHangUp(TransponderCallManager callManager, ServerPlayer player, UUID callId) {
        System.out.println("CallResponsePacket: Player " + player.m_7755_().getString() + " hanging up call " + callId.toString().substring(0, 8));
        callManager.endCall(player);
        System.out.println("CallResponsePacket: Call ended");
    }

    public Response getResponse() {
        return this.response;
    }

    public UUID getCallId() {
        return this.callId;
    }

    public static enum Response {
        ACCEPT,
        REJECT,
        HANG_UP;

    }
}

