/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class CallStateSyncPacket {
    private final CallState callState;
    private final UUID callId;
    private final int otherSnailNumber;
    private final String statusMessage;

    public CallStateSyncPacket(CallState callState, @Nullable UUID callId, int otherSnailNumber, String statusMessage) {
        this.callState = callState;
        this.callId = callId;
        this.otherSnailNumber = otherSnailNumber;
        this.statusMessage = statusMessage != null ? statusMessage : "";
    }

    public CallStateSyncPacket(FriendlyByteBuf buf) {
        this.callState = (CallState)buf.m_130066_(CallState.class);
        boolean hasCallId = buf.readBoolean();
        this.callId = hasCallId ? buf.m_130259_() : null;
        this.otherSnailNumber = buf.readInt();
        this.statusMessage = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.callState);
        buf.writeBoolean(this.callId != null);
        if (this.callId != null) {
            buf.m_130077_(this.callId);
        }
        buf.writeInt(this.otherSnailNumber);
        buf.m_130070_(this.statusMessage);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                this.handleClientSide();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleClientSide() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                System.err.println("CallStateSyncPacket: Player is null on client side");
                return;
            }
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof DialingMenu) {
                DialingMenu dialingMenu = (DialingMenu)abstractContainerMenu;
                dialingMenu.updateCallState(this.callState, this.callId, this.otherSnailNumber, this.statusMessage);
                System.out.println("CallStateSyncPacket: Updated client call state to " + this.callState + (String)(this.callId != null ? " (call " + this.callId.toString().substring(0, 8) + ")" : "") + (String)(this.otherSnailNumber != -1 ? " with snail #" + this.otherSnailNumber : "") + (String)(!this.statusMessage.isEmpty() ? " - " + this.statusMessage : ""));
            } else {
                System.out.println("CallStateSyncPacket: Received call state " + this.callState + " but no dialing menu is open");
            }
        }
        catch (Exception e) {
            System.err.println("CallStateSyncPacket: Error handling call state sync: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public CallState getCallState() {
        return this.callState;
    }

    @Nullable
    public UUID getCallId() {
        return this.callId;
    }

    public int getOtherSnailNumber() {
        return this.otherSnailNumber;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public static enum CallState {
        IDLE,
        DIALING,
        RINGING_OUT,
        RINGING_IN,
        CONNECTED,
        BUSY,
        DISCONNECTED;

    }
}

