/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.network.ModPackets;
import net.eclipce.transpondersnails.network.packets.DialedNumberSyncPacket;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class DialDigitPacket {
    private final int digit;
    private final String action;

    public DialDigitPacket(int digit, String action) {
        this.digit = digit;
        this.action = action;
    }

    public DialDigitPacket(FriendlyByteBuf buf) {
        this.digit = buf.readInt();
        this.action = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.digit);
        buf.m_130070_(this.action);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            block17: {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                try {
                    AbstractContainerMenu patt1288$temp = player.f_36096_;
                    if (patt1288$temp instanceof DialingMenu) {
                        DialingMenu dialingMenu = (DialingMenu)patt1288$temp;
                        switch (this.action.toLowerCase()) {
                            case "dial": {
                                if (this.digit >= 0 && this.digit <= 9) {
                                    dialingMenu.dialDigit(this.digit);
                                    String currentNumber = dialingMenu.getDialedNumber();
                                    ModPackets.sendToPlayer(new DialedNumberSyncPacket(currentNumber), player);
                                    System.out.println("DialDigitPacket: Player " + player.m_7755_().getString() + " dialed digit " + this.digit + ", current number: " + currentNumber);
                                    break;
                                }
                                break block17;
                            }
                            case "clear": {
                                dialingMenu.clearDialedNumber();
                                ModPackets.sendToPlayer(new DialedNumberSyncPacket(""), player);
                                System.out.println("DialDigitPacket: Player " + player.m_7755_().getString() + " cleared dialed number");
                                break;
                            }
                            case "backspace": {
                                String currentNumber = dialingMenu.getDialedNumber();
                                if (!currentNumber.isEmpty()) {
                                    String newNumber = currentNumber.substring(0, currentNumber.length() - 1);
                                    dialingMenu.clearDialedNumber();
                                    for (char c : newNumber.toCharArray()) {
                                        if (!Character.isDigit(c)) continue;
                                        dialingMenu.dialDigit(Character.getNumericValue(c));
                                    }
                                    ModPackets.sendToPlayer(new DialedNumberSyncPacket(newNumber), player);
                                    System.out.println("DialDigitPacket: Player " + player.m_7755_().getString() + " backspaced, new number: " + newNumber);
                                    break;
                                }
                                break block17;
                            }
                            default: {
                                System.err.println("DialDigitPacket: Unknown action: " + this.action);
                                break;
                            }
                        }
                        break block17;
                    }
                    System.err.println("DialDigitPacket: Player " + player.m_7755_().getString() + " sent dial packet but has no dialing menu open");
                }
                catch (Exception e) {
                    System.err.println("DialDigitPacket: Error handling dial input: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public int getDigit() {
        return this.digit;
    }

    public String getAction() {
        return this.action;
    }
}

