/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class DialedNumberSyncPacket {
    private final String dialedNumber;

    public DialedNumberSyncPacket(String dialedNumber) {
        this.dialedNumber = dialedNumber != null ? dialedNumber : "";
    }

    public DialedNumberSyncPacket(FriendlyByteBuf buf) {
        this.dialedNumber = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dialedNumber);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                this.handleClientSide();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void handleClientSide() {
        try {
            AbstractContainerMenu abstractContainerMenu;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null && (abstractContainerMenu = minecraft.f_91074_.f_36096_) instanceof DialingMenu) {
                DialingMenu dialingMenu = (DialingMenu)abstractContainerMenu;
                dialingMenu.getDialedNumber();
                System.out.println("DialedNumberSyncPacket: Synchronized dialed number: '" + this.dialedNumber + "'");
            } else {
                System.err.println("DialedNumberSyncPacket: Received sync but player has no dialing menu open");
            }
        }
        catch (Exception e) {
            System.err.println("DialedNumberSyncPacket: Error handling dialed number sync: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getDialedNumber() {
        return this.dialedNumber;
    }
}

