/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class SnailNumberSyncPacket {
    private final int snailNumber;

    public SnailNumberSyncPacket(int snailNumber) {
        this.snailNumber = snailNumber;
    }

    public SnailNumberSyncPacket(FriendlyByteBuf buf) {
        this.snailNumber = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.snailNumber);
    }

    public int getSnailNumber() {
        return this.snailNumber;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                System.out.println("SnailNumberSyncPacket: Player is null, cannot sync snail number");
                return;
            }
            AbstractContainerMenu menu = player.f_36096_;
            if (menu instanceof DialingMenu) {
                DialingMenu dialingMenu = (DialingMenu)menu;
                System.out.println("SnailNumberSyncPacket: Setting client snail number to #" + this.snailNumber);
                dialingMenu.setOwnSnailNumber(this.snailNumber);
                System.out.println("SnailNumberSyncPacket: Successfully synced snail number #" + this.snailNumber + " to client");
            } else {
                System.out.println("SnailNumberSyncPacket: Player menu is not DialingMenu (current menu: " + (menu != null ? menu.getClass().getSimpleName() : "null") + "), cannot sync snail number #" + this.snailNumber);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

