/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.recipe;

import com.google.gson.JsonObject;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.eclipce.transpondersnails.item.ModItems;
import net.eclipce.transpondersnails.recipe.ModRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class TransponderSnailCraftingRecipe
extends ShapedRecipe {
    public TransponderSnailCraftingRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, group, category, width, height, ingredients, result);
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer container, @NotNull RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(container, registryAccess);
        ItemStack denDenMushi = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41720_() != ModItems.DEN_DEN_MUSHI.get()) continue;
            denDenMushi = stack;
            break;
        }
        if (!denDenMushi.m_41619_() && DenDenMushiItem.isCaptured(denDenMushi)) {
            int bodyColor = DenDenMushiItem.getBodyColor(denDenMushi);
            int shellColor = DenDenMushiItem.getShellColor(denDenMushi);
            CompoundTag nbt = result.m_41784_();
            nbt.m_128405_("body_color", bodyColor);
            nbt.m_128405_("shell_color", shellColor);
            CompoundTag blockEntityTag = nbt.m_128469_("BlockEntityTag");
            blockEntityTag.m_128405_("BodyColor", bodyColor);
            blockEntityTag.m_128405_("ShellColor", shellColor);
            blockEntityTag.m_128379_("ColorsInitialized", true);
            nbt.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            System.out.println("TransponderSnailCraftingRecipe: Transferred colors - Body: #" + Integer.toHexString(bodyColor) + ", Shell: " + shellColor);
        }
        return result;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.TRANSPONDER_SNAIL_CRAFTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<TransponderSnailCraftingRecipe> {
        @NotNull
        public TransponderSnailCraftingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ShapedRecipe baseRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
            return new TransponderSnailCraftingRecipe(recipeId, baseRecipe.m_6076_(), baseRecipe.m_245232_(), baseRecipe.m_44220_(), baseRecipe.m_44221_(), (NonNullList<Ingredient>)baseRecipe.m_7527_(), baseRecipe.m_8043_(null));
        }

        @NotNull
        public TransponderSnailCraftingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            ShapedRecipe baseRecipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            if (baseRecipe == null) {
                throw new IllegalStateException("Failed to read Transponder Snail recipe from network");
            }
            return new TransponderSnailCraftingRecipe(recipeId, baseRecipe.m_6076_(), baseRecipe.m_245232_(), baseRecipe.m_44220_(), baseRecipe.m_44221_(), (NonNullList<Ingredient>)baseRecipe.m_7527_(), baseRecipe.m_8043_(null));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull TransponderSnailCraftingRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
        }
    }
}

