/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.eclipce.transpondersnails.config.ModConfig;
import net.eclipce.transpondersnails.screen.CallButton;
import net.eclipce.transpondersnails.screen.ClearButton;
import net.eclipce.transpondersnails.screen.DialButton;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.eclipce.transpondersnails.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DialingScreen
extends AbstractContainerScreen<DialingMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("transpondersnails", "textures/gui/dial-clear.png");
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 256;
    private EditBox numberDisplay;

    public DialingScreen(DialingMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 256;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        int textBoxWidth = 32;
        int textBoxHeight = 20;
        int textBoxX = this.f_97735_ + (this.f_97726_ - textBoxWidth) / 2;
        int textBoxY = this.f_97736_ + 117;
        this.numberDisplay = new EditBox(this.f_96547_, textBoxX, textBoxY, textBoxWidth, textBoxHeight, (Component)Component.m_237113_((String)""));
        this.numberDisplay.m_94199_(4);
        this.numberDisplay.m_94182_(true);
        this.numberDisplay.m_94194_(true);
        this.numberDisplay.m_94186_(false);
        this.numberDisplay.m_94144_("");
        this.numberDisplay.m_94190_(false);
        this.numberDisplay.m_93692_(false);
        this.numberDisplay.m_94202_(0xFFFFFF);
        this.numberDisplay.m_94205_(0xFFFFFF);
        this.m_142416_((GuiEventListener)this.numberDisplay);
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 161, this.f_97736_ + 65, 32, 32, 1, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 130, this.f_97736_ + 48, 32, 32, 2, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 94, this.f_97736_ + 48, 32, 32, 3, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 63, this.f_97736_ + 65, 32, 32, 4, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 48, this.f_97736_ + 95, 32, 32, 5, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 48, this.f_97736_ + 128, 32, 32, 6, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 63, this.f_97736_ + 159, 32, 32, 7, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 94, this.f_97736_ + 176, 32, 32, 8, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 129, this.f_97736_ + 176, 32, 32, 9, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new DialButton(this.f_97735_ + 161, this.f_97736_ + 159, 32, 32, 0, this::onDialButtonPressed));
        this.m_142416_((GuiEventListener)new CallButton(this.f_97735_ + 179, this.f_97736_ + 93, 32, 32, 10, this::onCallButtonPressed));
        this.m_142416_((GuiEventListener)new ClearButton(this.f_97735_ + 169, this.f_97736_ + 106, 64, 64, -1, this::onClearButtonPressed));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.numberDisplay.m_5953_(mouseX, mouseY)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode >= 49 && keyCode <= 57) {
            this.onDialButtonPressed(keyCode - 48);
            return true;
        }
        if (keyCode == 48) {
            this.onDialButtonPressed(0);
            return true;
        }
        if (ModConfig.isNumpadEnabled()) {
            if (keyCode >= 321 && keyCode <= 329) {
                this.onDialButtonPressed(keyCode - 320);
                return true;
            }
            if (keyCode == 320) {
                this.onDialButtonPressed(0);
                return true;
            }
        }
        switch (keyCode) {
            case 259: 
            case 261: {
                this.onClearButtonPressed(-1);
                return true;
            }
            case 257: 
            case 335: {
                this.onCallButtonPressed(10);
                return true;
            }
            case 256: {
                this.m_7379_();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSnailInfo(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void renderSnailInfo(GuiGraphics guiGraphics) {
        int ownNumber = ((DialingMenu)this.f_97732_).getOwnSnailNumber();
        if (ownNumber != -1) {
            String numberText = "Your Number: #" + ownNumber;
            int textWidth = this.f_96547_.m_92895_(numberText);
            int centerX = this.f_97735_ + (this.f_97726_ - textWidth) / 2;
            int topY = this.f_97736_ + 10;
            guiGraphics.m_280509_(centerX - 2, topY - 1, centerX + textWidth + 2, topY + 9, -2013265920);
            guiGraphics.m_280488_(this.f_96547_, numberText, centerX, topY, ChatFormatting.GREEN.m_126665_().intValue());
        } else {
            String loadingText = "Initializing...";
            int textWidth = this.f_96547_.m_92895_(loadingText);
            int centerX = this.f_97735_ + (this.f_97726_ - textWidth) / 2;
            int topY = this.f_97736_ + 10;
            guiGraphics.m_280509_(centerX - 2, topY - 1, centerX + textWidth + 2, topY + 9, -2013265920);
            guiGraphics.m_280488_(this.f_96547_, loadingText, centerX, topY, ChatFormatting.YELLOW.m_126665_().intValue());
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_7379_() {
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void onDialButtonPressed(int digit) {
        System.out.println("Dialed " + digit);
        ((DialingMenu)this.f_97732_).dialDigit(digit);
        this.updateNumberDisplay();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ModSounds.DIAL_BUTTON.get()), (float)1.0f));
    }

    private void onCallButtonPressed(int digit) {
        if (!((DialingMenu)this.f_97732_).isDialedNumberValid()) {
            return;
        }
        System.out.println("Call Button Pressed");
        ((DialingMenu)this.f_97732_).initiateCall();
        ((DialingMenu)this.f_97732_).onCallInitiated();
        this.updateNumberDisplay();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ModSounds.DIAL_BUTTON.get()), (float)1.0f));
        super.m_7379_();
    }

    private void onClearButtonPressed(int digit) {
        System.out.println("Number cleared!");
        ((DialingMenu)this.f_97732_).clearNumber();
        ((DialingMenu)this.f_97732_).onNumberCleared();
        this.updateNumberDisplay();
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ModSounds.CLEAR_BUTTON.get()), (float)1.0f));
    }

    private void updateNumberDisplay() {
        String dialedNumber = ((DialingMenu)this.f_97732_).getDialedNumber();
        if (dialedNumber == null) {
            dialedNumber = "";
        }
        this.numberDisplay.m_94144_(dialedNumber);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateNumberDisplay();
    }

    private void dialDigit(int digit) {
        this.onDialButtonPressed(digit);
    }
}

