/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.voice.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.eclipce.transpondersnails.sound.ModSounds;
import net.eclipce.transpondersnails.voice.VoiceChatConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CallSoundManager {
    public static final ResourceLocation SNAIL_RINGING_SOUND = ModSounds.SNAIL_RINGING.getId();
    public static final ResourceLocation SNAIL_CALL_CONNECTION_SOUND = ModSounds.SNAIL_CONNECTED.getId();
    public static final ResourceLocation SNAIL_CALL_DISCONNECTED_SOUND = ModSounds.SNAIL_DISCONNECTED.getId();
    public static final ResourceLocation SNAIL_CALL_BUSY_SOUND = ModSounds.SNAIL_BUSY.getId();
    public static final ResourceLocation HANDSET_CALL_PICK_UP_SOUND = ModSounds.SNAIL_PICK_UP.getId();
    public static final ResourceLocation HANDSET_CALL_HANG_UP_SOUND = ModSounds.SNAIL_HANG_UP.getId();
    private final Map<UUID, SoundInstance> activeSounds = new ConcurrentHashMap<UUID, SoundInstance>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Map<BlockPos, Set<SoundCategory>> activeAmbientSounds = new ConcurrentHashMap<BlockPos, Set<SoundCategory>>();
    private final Set<BlockstateUpdateCallback> blockstateCallbacks = ConcurrentHashMap.newKeySet();

    public void registerBlockstateCallback(BlockstateUpdateCallback callback) {
        this.blockstateCallbacks.add(callback);
        System.out.println("CallSoundManager: Registered blockstate callback");
    }

    public void unregisterBlockstateCallback(BlockstateUpdateCallback callback) {
        boolean removed = this.blockstateCallbacks.remove(callback);
        if (removed) {
            System.out.println("CallSoundManager: Unregistered blockstate callback");
        }
    }

    public void playLocationalRingTone(ServerPlayer player, BlockPos snailLocation) {
        UUID soundId = UUID.randomUUID();
        this.playSnailPositionRepeatingSound(player.m_9236_(), snailLocation, SNAIL_RINGING_SOUND, soundId, SoundType.RING_TONE, SoundCategory.AMBIENT_SNAIL_SOUNDS, 2000);
        System.out.println("CallSoundManager: Started ambient ringtone at snail position " + snailLocation);
    }

    public void playLocationalRingToneAtPosition(Level level, BlockPos snailLocation) {
        UUID soundId = UUID.randomUUID();
        this.playSnailPositionRepeatingSound(level, snailLocation, SNAIL_RINGING_SOUND, soundId, SoundType.RING_TONE, SoundCategory.AMBIENT_SNAIL_SOUNDS, 2000);
        System.out.println("CallSoundManager: Started ambient ringtone at snail position " + snailLocation + " (no player required)");
    }

    public void playRingToneForPlayer(ServerPlayer player) {
        UUID soundId = UUID.randomUUID();
        this.playPlayerFollowingRepeatingSound(player, SNAIL_RINGING_SOUND, soundId, SoundType.RING_TONE, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Started ringtone for player " + player.m_7755_().getString());
    }

    public void playCallConnectedSoundAtSnail(ServerPlayer player, BlockPos snailPos) {
        this.playSnailPositionSound(player.m_9236_(), snailPos, SNAIL_CALL_CONNECTION_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played ambient connection sound at snail position " + snailPos);
    }

    public void playConnectedSoundForPlayer(ServerPlayer player) {
        this.playPlayerSound(player, SNAIL_CALL_CONNECTION_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played connected sound for player " + player.m_7755_().getString());
    }

    public void playCallDisconnectedSoundAtSnail(ServerPlayer player, BlockPos snailPos) {
        this.playSnailPositionSound(player.m_9236_(), snailPos, SNAIL_CALL_DISCONNECTED_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played ambient disconnection sound at snail position " + snailPos);
    }

    public void playDisconnectedSoundForPlayer(ServerPlayer player) {
        this.playPlayerSound(player, SNAIL_CALL_DISCONNECTED_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played disconnected sound for player " + player.m_7755_().getString());
    }

    public void playPickUpSoundAtSnail(ServerPlayer player, BlockPos snailPos) {
        this.playSnailPositionSound(player.m_9236_(), snailPos, HANDSET_CALL_PICK_UP_SOUND, SoundCategory.INTERACTION_SOUNDS);
        System.out.println("CallSoundManager: Played interaction pick up sound at snail position " + snailPos);
    }

    public void playPickUpSoundForPlayer(ServerPlayer player) {
        this.playPlayerSound(player, HANDSET_CALL_PICK_UP_SOUND, SoundCategory.INTERACTION_SOUNDS);
        System.out.println("CallSoundManager: Played pick up sound for player " + player.m_7755_().getString());
    }

    public void playHangUpSoundAtSnail(ServerPlayer player, BlockPos snailPos) {
        this.playSnailPositionSound(player.m_9236_(), snailPos, HANDSET_CALL_HANG_UP_SOUND, SoundCategory.INTERACTION_SOUNDS);
        System.out.println("CallSoundManager: Played interaction hang up sound at snail position " + snailPos);
    }

    public void playHangUpSoundForPlayer(ServerPlayer player) {
        this.playPlayerSound(player, HANDSET_CALL_HANG_UP_SOUND, SoundCategory.INTERACTION_SOUNDS);
        System.out.println("CallSoundManager: Played hang up sound for player " + player.m_7755_().getString());
    }

    public void playBusySoundAtSnail(ServerPlayer player, BlockPos snailPos) {
        this.playSnailPositionSound(player.m_9236_(), snailPos, SNAIL_CALL_BUSY_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played ambient busy sound at snail position " + snailPos);
    }

    public void playBusySoundForPlayer(ServerPlayer player) {
        this.playPlayerSound(player, SNAIL_CALL_BUSY_SOUND, SoundCategory.AMBIENT_SNAIL_SOUNDS);
        System.out.println("CallSoundManager: Played busy sound for player " + player.m_7755_().getString());
    }

    private void playSnailPositionSound(Level level, BlockPos snailPos, ResourceLocation soundLocation, SoundCategory category) {
        try {
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundLocation);
            float volume = 1.0f;
            float pitch = 1.0f;
            level.m_6263_(null, (double)snailPos.m_123341_() + 0.5, (double)snailPos.m_123342_() + 0.5, (double)snailPos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, volume, pitch);
            if (category == SoundCategory.AMBIENT_SNAIL_SOUNDS) {
                this.activeAmbientSounds.computeIfAbsent(snailPos, k -> ConcurrentHashMap.newKeySet()).add(category);
                this.notifyBlockstateUpdate(snailPos, true);
                this.scheduler.schedule(() -> {
                    Set<SoundCategory> sounds = this.activeAmbientSounds.get(snailPos);
                    if (sounds != null) {
                        sounds.remove((Object)category);
                        if (sounds.isEmpty()) {
                            this.activeAmbientSounds.remove(snailPos);
                            this.notifyBlockstateUpdate(snailPos, false);
                        }
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
            System.out.println("CallSoundManager: Played spatial sound " + soundLocation + " (" + category + ") at " + snailPos);
        }
        catch (Exception e) {
            System.err.println("CallSoundManager: Failed to play snail position sound " + soundLocation + " at " + snailPos);
            e.printStackTrace();
        }
    }

    private void playSnailPositionRepeatingSound(Level level, BlockPos snailPos, ResourceLocation soundLocation, UUID soundId, SoundType type, SoundCategory category, int intervalMs) {
        this.stopSnailPositionSounds(snailPos, type);
        SoundInstance instance = new SoundInstance(snailPos, level, soundLocation, type, category);
        this.activeSounds.put(soundId, instance);
        if (category == SoundCategory.AMBIENT_SNAIL_SOUNDS) {
            this.activeAmbientSounds.computeIfAbsent(snailPos, k -> ConcurrentHashMap.newKeySet()).add(category);
            this.notifyBlockstateUpdate(snailPos, true);
        }
        this.playSnailPositionSoundDirect(level, snailPos, soundLocation);
        instance.stopTask = this.scheduler.scheduleAtFixedRate(() -> {
            if (this.activeSounds.containsKey(soundId)) {
                this.playSnailPositionSoundDirect(level, snailPos, soundLocation);
            } else {
                System.out.println("CallSoundManager: Repeating sound " + soundLocation + " at " + snailPos + " was stopped, cleaning up");
            }
        }, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
        System.out.println("CallSoundManager: Started repeating sound " + soundLocation + " (" + category + ") at " + snailPos + " with " + intervalMs + "ms interval");
    }

    private void playPlayerSound(ServerPlayer player, ResourceLocation soundLocation, SoundCategory category) {
        try {
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundLocation);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_6330_(soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        catch (Exception e) {
            System.err.println("CallSoundManager: Failed to play sound " + soundLocation + " for player " + player.m_7755_().getString());
            e.printStackTrace();
        }
    }

    private void playPlayerFollowingRepeatingSound(ServerPlayer player, ResourceLocation soundLocation, UUID soundId, SoundType type, SoundCategory category) {
        this.stopPlayerSounds(player.m_20148_(), type);
        PlayerSoundInstance instance = new PlayerSoundInstance(player.m_20148_(), player.m_9236_(), soundLocation, type, category);
        this.activeSounds.put(soundId, instance);
        this.playPlayerSound(player, soundLocation, category);
        instance.stopTask = this.scheduler.scheduleAtFixedRate(() -> {
            ServerPlayer currentPlayer = this.getPlayerById(player.m_20148_());
            if (currentPlayer != null && this.activeSounds.containsKey(soundId)) {
                this.playPlayerSound(currentPlayer, soundLocation, category);
            } else {
                this.activeSounds.remove(soundId);
            }
        }, 2000L, 2000L, TimeUnit.MILLISECONDS);
        System.out.println("CallSoundManager: Started repeating sound " + soundLocation + " for player " + player.m_7755_().getString());
    }

    private void playSnailPositionRepeatingSound(Level level, BlockPos snailPos, ResourceLocation soundLocation, UUID soundId, SoundType type, SoundCategory category) {
        this.playSnailPositionRepeatingSound(level, snailPos, soundLocation, soundId, type, category, 1500);
    }

    private void playSnailPositionSoundDirect(Level level, BlockPos snailPos, ResourceLocation soundLocation) {
        try {
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)soundLocation);
            level.m_6263_(null, (double)snailPos.m_123341_() + 0.5, (double)snailPos.m_123342_() + 0.5, (double)snailPos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        catch (Exception e) {
            System.err.println("CallSoundManager: Failed to play direct sound " + soundLocation + " at " + snailPos);
            e.printStackTrace();
        }
    }

    public void stopSnailPositionSounds(BlockPos snailPos, SoundType type) {
        Iterator<Map.Entry<UUID, SoundInstance>> iterator = this.activeSounds.entrySet().iterator();
        int stoppedCount = 0;
        boolean hadAmbientSounds = false;
        while (iterator.hasNext()) {
            Map.Entry<UUID, SoundInstance> entry = iterator.next();
            SoundInstance instance = entry.getValue();
            if (!instance.snailPosition.equals((Object)snailPos) || instance.type != type) continue;
            if (instance.stopTask != null) {
                instance.stopTask.cancel(false);
            }
            if (instance.category == SoundCategory.AMBIENT_SNAIL_SOUNDS) {
                hadAmbientSounds = true;
            }
            iterator.remove();
            ++stoppedCount;
        }
        if (hadAmbientSounds) {
            this.updateAmbientSoundTracking(snailPos);
        }
        if (stoppedCount > 0) {
            System.out.println("CallSoundManager: Stopped " + stoppedCount + " " + type + " sound(s) at snail position " + snailPos);
        }
    }

    public void stopAllSnailPositionSounds(BlockPos snailPos) {
        Iterator<Map.Entry<UUID, SoundInstance>> iterator = this.activeSounds.entrySet().iterator();
        int stoppedCount = 0;
        boolean hadAmbientSounds = false;
        while (iterator.hasNext()) {
            Map.Entry<UUID, SoundInstance> entry = iterator.next();
            SoundInstance instance = entry.getValue();
            if (!instance.snailPosition.equals((Object)snailPos)) continue;
            if (instance.stopTask != null) {
                instance.stopTask.cancel(false);
            }
            if (instance.category == SoundCategory.AMBIENT_SNAIL_SOUNDS) {
                hadAmbientSounds = true;
            }
            iterator.remove();
            ++stoppedCount;
        }
        if (hadAmbientSounds) {
            this.activeAmbientSounds.remove(snailPos);
            this.notifyBlockstateUpdate(snailPos, false);
        }
        if (stoppedCount > 0) {
            System.out.println("CallSoundManager: Stopped all " + stoppedCount + " sound(s) at snail position " + snailPos);
        }
    }

    private void stopPlayerSounds(UUID playerId, SoundType type) {
        Iterator<Map.Entry<UUID, SoundInstance>> iterator = this.activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, SoundInstance> entry = iterator.next();
            if (!(entry.getValue() instanceof PlayerSoundInstance)) continue;
            PlayerSoundInstance instance = (PlayerSoundInstance)entry.getValue();
            if (!instance.playerId.equals(playerId) || instance.type != type) continue;
            if (instance.stopTask != null) {
                instance.stopTask.cancel(false);
            }
            iterator.remove();
        }
    }

    private void updateAmbientSoundTracking(BlockPos snailPos) {
        boolean hasAmbientSounds = this.activeSounds.values().stream().anyMatch(instance -> instance.snailPosition.equals((Object)snailPos) && instance.category == SoundCategory.AMBIENT_SNAIL_SOUNDS);
        if (!hasAmbientSounds) {
            this.activeAmbientSounds.remove(snailPos);
            this.notifyBlockstateUpdate(snailPos, false);
        }
    }

    private void notifyBlockstateUpdate(BlockPos pos, boolean hasAmbientSound) {
        for (BlockstateUpdateCallback callback : this.blockstateCallbacks) {
            try {
                callback.onSoundStateChanged(pos, hasAmbientSound);
            }
            catch (Exception e) {
                System.err.println("CallSoundManager: Error in blockstate callback: " + e.getMessage());
            }
        }
    }

    public boolean hasAmbientSoundsAtPosition(BlockPos pos) {
        return this.activeAmbientSounds.containsKey(pos) && !this.activeAmbientSounds.get(pos).isEmpty();
    }

    public Set<BlockPos> getPositionsWithAmbientSounds() {
        return new HashSet<BlockPos>(this.activeAmbientSounds.keySet());
    }

    public void stopRingTone(ServerPlayer player) {
        Iterator<Map.Entry<UUID, SoundInstance>> iterator = this.activeSounds.entrySet().iterator();
        int stoppedCount = 0;
        while (iterator.hasNext()) {
            double distance;
            Map.Entry<UUID, SoundInstance> entry = iterator.next();
            SoundInstance instance = entry.getValue();
            if (instance.type != SoundType.RING_TONE) continue;
            boolean shouldStop = false;
            if (instance instanceof PlayerSoundInstance) {
                PlayerSoundInstance playerInstance = (PlayerSoundInstance)instance;
                if (playerInstance.playerId.equals(player.m_20148_())) {
                    shouldStop = true;
                }
            } else if (instance.snailPosition != null && (distance = Math.sqrt(Math.pow((double)instance.snailPosition.m_123341_() + 0.5 - player.m_20185_(), 2.0) + Math.pow((double)instance.snailPosition.m_123342_() + 0.5 - player.m_20186_(), 2.0) + Math.pow((double)instance.snailPosition.m_123343_() + 0.5 - player.m_20189_(), 2.0))) <= VoiceChatConstants.getSnailInteractionRange()) {
                shouldStop = true;
            }
            if (!shouldStop) continue;
            if (instance.stopTask != null) {
                instance.stopTask.cancel(false);
            }
            iterator.remove();
            ++stoppedCount;
        }
        if (stoppedCount > 0) {
            System.out.println("CallSoundManager: Stopped " + stoppedCount + " ringtone(s) for player " + player.m_7755_().getString());
        }
    }

    public void cleanup() {
        System.out.println("CallSoundManager: Cleaning up " + this.activeSounds.size() + " active sounds");
        for (SoundInstance instance : this.activeSounds.values()) {
            if (instance.stopTask == null) continue;
            instance.stopTask.cancel(false);
        }
        this.activeSounds.clear();
        this.activeAmbientSounds.clear();
        this.blockstateCallbacks.clear();
        this.scheduler.shutdown();
        System.out.println("CallSoundManager: Cleanup complete");
    }

    private ServerPlayer getPlayerById(UUID playerId) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
    }

    public Map<UUID, String> getActiveSoundsInfo() {
        HashMap<UUID, String> info = new HashMap<UUID, String>();
        for (Map.Entry<UUID, SoundInstance> entry : this.activeSounds.entrySet()) {
            SoundInstance instance = entry.getValue();
            long duration = System.currentTimeMillis() - instance.startTime;
            info.put(entry.getKey(), instance.soundLocation + " (" + instance.type + "/" + instance.category + ") at " + instance.snailPosition + " - " + duration + "ms");
        }
        return info;
    }

    public int getActiveSoundCount(SoundType type) {
        return (int)this.activeSounds.values().stream().filter(instance -> instance.type == type).count();
    }

    public Set<BlockPos> getActiveSoundPositions() {
        return this.activeSounds.values().stream().map(instance -> instance.snailPosition).collect(Collectors.toSet());
    }

    public boolean hasSoundsAtPosition(BlockPos pos) {
        return this.activeSounds.values().stream().anyMatch(instance -> instance.snailPosition.equals((Object)pos));
    }

    public boolean hasRingtonesAtPosition(BlockPos pos) {
        return this.activeSounds.values().stream().anyMatch(instance -> instance.snailPosition.equals((Object)pos) && instance.type == SoundType.RING_TONE);
    }

    public static enum SoundType {
        RING_TONE,
        ONE_SHOT,
        AMBIENT;

    }

    public static enum SoundCategory {
        AMBIENT_SNAIL_SOUNDS,
        INTERACTION_SOUNDS;

    }

    private static class SoundInstance {
        final BlockPos snailPosition;
        final Level level;
        final ResourceLocation soundLocation;
        final SoundType type;
        final SoundCategory category;
        final long startTime;
        ScheduledFuture<?> stopTask;

        SoundInstance(BlockPos snailPosition, Level level, ResourceLocation soundLocation, SoundType type, SoundCategory category) {
            this.snailPosition = snailPosition;
            this.level = level;
            this.soundLocation = soundLocation;
            this.type = type;
            this.category = category;
            this.startTime = System.currentTimeMillis();
        }
    }

    private static class PlayerSoundInstance
    extends SoundInstance {
        final UUID playerId;

        PlayerSoundInstance(UUID playerId, Level level, ResourceLocation soundLocation, SoundType type, SoundCategory category) {
            super(null, level, soundLocation, type, category);
            this.playerId = playerId;
        }
    }

    public static interface BlockstateUpdateCallback {
        public void onSoundStateChanged(BlockPos var1, boolean var2);
    }
}

