/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.voice.server;

import de.maxhenkel.voicechat.api.ServerPlayer;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.network.packets.CallStateSyncPacket;
import net.eclipce.transpondersnails.voice.VoiceChatConstants;
import net.eclipce.transpondersnails.voice.server.CallSession;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.core.BlockPos;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SnailAudioRelay {
    private final VoicechatServerApi voiceChatApi;
    private final TransponderCallManager callManager;
    private final Map<UUID, CallSessionCache> playerSessionCache = new ConcurrentHashMap<UUID, CallSessionCache>();
    private static final long CACHE_TIMEOUT_MS = 2000L;
    private final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "SnailAudioRelay-Cleanup"));
    private final Map<BlockPos, BlockstateActivity> blockstateActivity = new ConcurrentHashMap<BlockPos, BlockstateActivity>();
    private static final long AUDIO_TIMEOUT_MS = 500L;

    public SnailAudioRelay(VoicechatServerApi voiceChatApi, TransponderCallManager callManager) {
        this.voiceChatApi = voiceChatApi;
        this.callManager = callManager;
        this.cleanupExecutor.scheduleAtFixedRate(this::cleanupExpiredActivity, 200L, 200L, TimeUnit.MILLISECONDS);
        System.out.println("SnailAudioRelay: Initialized TIER 2 + Handheld support system");
    }

    public void onMicrophonePacket(MicrophonePacketEvent event) {
        try {
            byte[] opusData;
            CallSession callSession;
            ServerPlayer vcSpeaker = Objects.requireNonNull(event.getSenderConnection()).getPlayer();
            if (vcSpeaker == null) {
                return;
            }
            net.minecraft.server.level.ServerPlayer speaker = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(vcSpeaker.getUuid());
            if (speaker == null) {
                return;
            }
            CallSessionCache sessionCache = this.playerSessionCache.get(speaker.m_20148_());
            if (sessionCache == null || !sessionCache.isValid()) {
                if (!this.callManager.isInCall(speaker.m_20148_())) {
                    return;
                }
                UUID callId = this.callManager.getPlayerCallId(speaker.m_20148_());
                if (callId == null) {
                    return;
                }
                callSession = this.getCallSessionById(callId);
                if (callSession == null || callSession.getState() != CallSession.CallState.CONNECTED) {
                    return;
                }
                TransponderSnailBlockEntity nearbySnail = this.findNearestSnailInCall(speaker, callSession);
                sessionCache = new CallSessionCache(callSession, nearbySnail);
                this.playerSessionCache.put(speaker.m_20148_(), sessionCache);
            }
            if ((opusData = ((MicrophonePacket)event.getPacket()).getOpusEncodedData()) == null || opusData.length == 0) {
                return;
            }
            callSession = sessionCache.callSession;
            BlockPos transmittingPos = sessionCache.transmittingSnail != null ? sessionCache.transmittingSnail.m_58899_() : null;
            Set<BlockPos> targetPositions = callSession.getInvolvedBlockPositions();
            for (BlockPos targetPos : targetPositions) {
                if (transmittingPos != null && targetPos.equals((Object)transmittingPos)) continue;
                this.forwardOpusToSnail(targetPos, opusData, callSession);
                this.updateAudioActivity(targetPos);
            }
            Set<UUID> handheldParticipants = callSession.getHandheldParticipantIds();
            for (UUID handheldPlayerId : handheldParticipants) {
                if (handheldPlayerId.equals(speaker.m_20148_())) continue;
                this.forwardOpusToHandheld(handheldPlayerId, opusData, callSession);
            }
        }
        catch (Exception e) {
            System.err.println("SnailAudioRelay: Error processing microphone packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void forwardOpusToSnail(BlockPos targetPos, byte[] opusData, CallSession callSession) {
        try {
            LocationalAudioChannel channel = (LocationalAudioChannel)callSession.getProximityChannel(targetPos);
            if (channel != null) {
                channel.send(opusData);
            }
        }
        catch (Exception e) {
            System.err.println("SnailAudioRelay: Failed to forward opus to " + targetPos + ": " + e.getMessage());
        }
    }

    private void forwardOpusToHandheld(UUID playerId, byte[] opusData, CallSession callSession) {
        try {
            AudioChannel channel = callSession.getHandheldChannel(playerId);
            if (channel != null) {
                channel.send(opusData);
            } else {
                System.err.println("SnailAudioRelay: No handheld channel found for player " + playerId.toString().substring(0, 8));
            }
        }
        catch (Exception e) {
            System.err.println("SnailAudioRelay: Failed to forward opus to handheld " + playerId.toString().substring(0, 8) + ": " + e.getMessage());
        }
    }

    private void updateAudioActivity(BlockPos pos) {
        long now = System.currentTimeMillis();
        BlockstateActivity activity = this.blockstateActivity.get(pos);
        if (activity == null) {
            activity = new BlockstateActivity(pos);
            this.blockstateActivity.put(pos, activity);
            this.updateSnailBlockstate(pos, true);
        } else {
            activity.lastActivityTime = now;
        }
    }

    private void updateSnailBlockstate(BlockPos pos, boolean active) {
        try {
            TransponderSnailBlockEntity snail = this.callManager.getRegisteredSnailBlock(this.findSnailNumberAtPosition(pos));
            if (snail != null && snail.getCurrentCallState() == CallStateSyncPacket.CallState.CONNECTED) {
                snail.onSoundStateChanged(pos, active);
            }
        }
        catch (Exception e) {
            System.err.println("SnailAudioRelay: Error updating blockstate for " + pos + ": " + e.getMessage());
        }
    }

    private void cleanupExpiredActivity() {
        try {
            long now = System.currentTimeMillis();
            ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
            for (BlockstateActivity activity : this.blockstateActivity.values()) {
                if (now - activity.lastActivityTime <= 500L) continue;
                toRemove.add(activity.position);
            }
            if (!toRemove.isEmpty()) {
                for (BlockPos pos : toRemove) {
                    this.blockstateActivity.remove(pos);
                    this.updateSnailBlockstate(pos, false);
                }
            }
        }
        catch (Exception e) {
            System.err.println("SnailAudioRelay: Error in cleanup: " + e.getMessage());
        }
    }

    @Nullable
    private TransponderSnailBlockEntity findNearestSnailInCall(net.minecraft.server.level.ServerPlayer player, CallSession callSession) {
        CallSession.CallParticipant participant;
        TransponderSnailBlockEntity closestSnail = null;
        double closestDistance = Double.MAX_VALUE;
        double maxRangeSq = VoiceChatConstants.getSnailInteractionRange() * VoiceChatConstants.getSnailInteractionRange();
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            double distance;
            TransponderSnailBlockEntity snail = this.callManager.getRegisteredSnailBlock(snailNumber);
            if (snail == null || !((distance = player.m_20275_((double)snail.m_58899_().m_123341_() + 0.5, (double)snail.m_58899_().m_123342_() + 0.5, (double)snail.m_58899_().m_123343_() + 0.5)) <= maxRangeSq) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestSnail = snail;
        }
        if (closestSnail == null && (participant = callSession.getParticipantByPlayer(player.m_20148_())) != null && participant.isHandheld()) {
            System.out.println("SnailAudioRelay: Player " + player.m_7755_().getString() + " is using handheld snail #" + participant.getSnailNumber());
        }
        return closestSnail;
    }

    private int findSnailNumberAtPosition(BlockPos pos) {
        Map<Integer, TransponderSnailBlockEntity> snails = this.callManager.getRegisteredSnailBlocks();
        for (Map.Entry<Integer, TransponderSnailBlockEntity> entry : snails.entrySet()) {
            if (!entry.getValue().m_58899_().equals((Object)pos)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Nullable
    private CallSession getCallSessionById(UUID callId) {
        return this.callManager.getActiveCalls().stream().filter(call -> call.getCallId().equals(callId)).findFirst().orElse(null);
    }

    public void onPlayerLeftCall(UUID playerId) {
        this.playerSessionCache.remove(playerId);
        System.out.println("SnailAudioRelay: Cleaned up player " + playerId.toString().substring(0, 8));
    }

    public void onCallEnded(UUID callId) {
        CallSession callSession = this.getCallSessionById(callId);
        if (callSession != null) {
            for (UUID playerId : callSession.getActivePlayerParticipants()) {
                this.playerSessionCache.remove(playerId);
            }
            Set<BlockPos> involvedPositions = callSession.getInvolvedBlockPositions();
            for (BlockPos pos : involvedPositions) {
                this.blockstateActivity.remove(pos);
                this.updateSnailBlockstate(pos, false);
            }
        }
        System.out.println("SnailAudioRelay: Cleaned up call " + callId.toString().substring(0, 8));
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
        try {
            if (!this.cleanupExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.playerSessionCache.clear();
        this.blockstateActivity.clear();
        System.out.println("SnailAudioRelay: Shutdown complete");
    }

    private static class CallSessionCache {
        final CallSession callSession;
        final TransponderSnailBlockEntity transmittingSnail;
        final long timestamp;

        CallSessionCache(CallSession callSession, @Nullable TransponderSnailBlockEntity transmittingSnail) {
            this.callSession = callSession;
            this.transmittingSnail = transmittingSnail;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 2000L && this.callSession.getState() == CallSession.CallState.CONNECTED;
        }
    }

    private static class BlockstateActivity {
        final BlockPos position;
        volatile long lastActivityTime;

        BlockstateActivity(BlockPos position) {
            this.position = position;
            this.lastActivityTime = System.currentTimeMillis();
        }
    }
}

