/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.eclipce.transpondersnails.block.ModBlocks;
import net.eclipce.transpondersnails.block.entity.ModBlockEntities;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.commands.CallCommand;
import net.eclipce.transpondersnails.commands.SnailNumberCommand;
import net.eclipce.transpondersnails.commands.SpawnTestCommand;
import net.eclipce.transpondersnails.commands.TransponderSnailItemCommand;
import net.eclipce.transpondersnails.config.ModConfig;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.eclipce.transpondersnails.entity.ModEntities;
import net.eclipce.transpondersnails.item.ModCreativeModeTabs;
import net.eclipce.transpondersnails.item.ModItems;
import net.eclipce.transpondersnails.network.ModPackets;
import net.eclipce.transpondersnails.recipe.ModRecipeSerializers;
import net.eclipce.transpondersnails.screen.ModMenuTypes;
import net.eclipce.transpondersnails.sound.ModSounds;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="transpondersnails")
@Mod.EventBusSubscriber
public class TransponderSnails {
    public static final String MOD_ID = "transpondersnails";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static TransponderCallManager callManager;
    private static Thread emergencyShutdownHook;
    public static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public TransponderSnails(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModRecipeSerializers.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.CLIENT_SPEC, "transpondersnails-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfig.SERVER_SPEC, "transpondersnails-server.toml");
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::setup);
        this.registerEmergencyShutdownHook();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        event.enqueueWork(() -> {
            ModPackets.init();
            LOGGER.info("ModPackets Initialized");
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    private void registerEmergencyShutdownHook() {
        emergencyShutdownHook = new Thread(() -> {
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            System.out.println("\u26a0\ufe0f  EMERGENCY SHUTDOWN DETECTED! \u26a0\ufe0f");
            System.out.println("TransponderSnails: Attempting emergency save...");
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            try {
                SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
                if (registry != null) {
                    System.out.println("TransponderSnails: Emergency saving registry...");
                    registry.forceSave();
                    System.out.println("\u2705 TransponderSnails: Emergency save successful!");
                } else {
                    System.out.println("TransponderSnails: No registry to save (server may not have started)");
                }
            }
            catch (Exception e) {
                System.err.println("\u274c TransponderSnails: Emergency save failed: " + e.getMessage());
                e.printStackTrace();
            }
            System.out.println("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        }, "TransponderSnails-EmergencyShutdown");
        Runtime.getRuntime().addShutdownHook(emergencyShutdownHook);
        System.out.println("TransponderSnails: Emergency shutdown hook registered");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        TransponderSnailBlockEntity.setServerStartingUp();
        System.out.println("TransponderSnails: Server starting - reset block entity state");
        System.out.println("TransponderSnails: SnailNumberRegistry will load on first access");
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551 TransponderSnails: GRACEFUL SHUTDOWN INITIATED             \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        TransponderSnailBlockEntity.setServerShuttingDown();
        System.out.println("TransponderSnails: Prevented block entity loops");
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry != null) {
            System.out.println("TransponderSnails: Graceful shutdown - saving registry...");
            registry.forceSave();
            System.out.println("TransponderSnails: \u2705 Registry saved successfully");
        } else {
            System.out.println("TransponderSnails: No registry instance to save");
        }
        SnailNumberRegistry.resetInstance();
        System.out.println("TransponderSnails: Instance cache reset");
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        System.out.println("\u2551 TransponderSnails: GRACEFUL SHUTDOWN COMPLETE              \u2551");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CallCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SnailNumberCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TransponderSnailItemCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SpawnTestCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    public static void setCallManager(TransponderCallManager manager) {
        callManager = manager;
        LOGGER.info("Call manager initialized successfully!");
    }

    public static TransponderCallManager getCallManager() {
        if (callManager == null) {
            LOGGER.warn("Call manager not initialized! Make sure Simple Voice Chat is installed and the server has started.");
            return null;
        }
        return callManager;
    }

    static {
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    @Mod.EventBusSubscriber(modid="transpondersnails", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            event.enqueueWork(() -> {
                try {
                    Minecraft mc = Minecraft.m_91087_();
                    LOGGER.info("MINECRAFT NAME >> {}", (Object)mc.m_91094_().m_92546_());
                }
                catch (Exception e) {
                    LOGGER.warn("Could not get Minecraft username: " + e.getMessage());
                }
            });
        }
    }
}

