/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.block.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.eclipce.transpondersnails.block.entity.ModBlockEntities;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TransponderSnailBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_SOUND = BooleanProperty.m_61465_((String)"has_sound");
    public static final BooleanProperty IN_CALL = BooleanProperty.m_61465_((String)"in_call");
    public static final IntegerProperty SHELL_COLOR = IntegerProperty.m_61631_((String)"shell_color", (int)0, (int)15);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)10.5, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)10.5, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)14.0, (double)10.5, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)15.0, (double)10.5, (double)12.0);
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public TransponderSnailBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_SOUND, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IN_CALL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHELL_COLOR, (Comparable)Integer.valueOf(0)));
    }

    private static VoxelShape getShapeForDirection(Direction direction) {
        return SHAPES.getOrDefault(direction, SHAPE_NORTH);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return TransponderSnailBlock.getShapeForDirection(facing);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        return TransponderSnailBlock.getShapeForDirection(facing);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HAS_SOUND, IN_CALL, SHELL_COLOR});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        System.out.println("TransponderSnailBlock.use() called - Hand: " + hand + ", ClientSide: " + level.f_46443_ + ", HeldItem: " + player.m_21120_(hand).m_41720_());
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            System.out.println("Returning PASS - not main hand");
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TransponderSnailBlockEntity) {
            TransponderSnailBlockEntity snailEntity = (TransponderSnailBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Item item = itemStack.m_41720_();
                if (item instanceof DyeItem) {
                    int currentShellColor;
                    DyeItem dyeItem = (DyeItem)item;
                    DyeColor dyeColor = dyeItem.m_41089_();
                    int newShellColor = dyeColor.m_41060_();
                    if (newShellColor != (currentShellColor = ((Integer)state.m_61143_((Property)SHELL_COLOR)).intValue())) {
                        if (!snailEntity.isColorsInitialized()) {
                            snailEntity.ensureColorsInitialized();
                        }
                        BlockState newState = (BlockState)state.m_61124_((Property)SHELL_COLOR, (Comparable)Integer.valueOf(newShellColor));
                        level.m_7731_(pos, newState, 3);
                        snailEntity.setShellColor(newShellColor);
                        serverPlayer.m_213846_((Component)Component.m_237113_((String)("Transponder Snail shell dyed " + dyeColor.m_41065_().replace("_", " ") + "!")).m_130940_(ChatFormatting.GREEN));
                        if (!player.m_7500_()) {
                            itemStack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)("Transponder Snail is already " + dyeColor.m_41065_().replace("_", " ") + "!")).m_130940_(ChatFormatting.YELLOW));
                    return InteractionResult.FAIL;
                }
                boolean isSneaking = player.m_6144_();
                return snailEntity.onPlayerInteraction(serverPlayer, isSneaking);
            }
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TransponderSnailBlockEntity(pPos, pState);
    }

    private BlockEntityType<TransponderSnailBlockEntity> getBlockEntityType() {
        BlockEntityType type = (BlockEntityType)ModBlockEntities.TRANSPONDER_SNAIL_BE.get();
        if (type == null) {
            throw new RuntimeException("BlockEntityType not implemented - register in your mod initialization");
        }
        return type;
    }

    public boolean hasBlockEntityType() {
        return ModBlockEntities.TRANSPONDER_SNAIL_BE.get() != null;
    }

    public void someMethod() {
        BlockEntityType<TransponderSnailBlockEntity> type = this.getBlockEntityType();
        if (type != null) {
            // empty if block
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return null;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        TransponderSnailBlockEntity snailBlockEntity;
        UUID activeCall;
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) || !((blockEntity = pLevel.m_7702_(pPos)) instanceof TransponderSnailBlockEntity) || (activeCall = (snailBlockEntity = (TransponderSnailBlockEntity)blockEntity).getActiveCallId()) != null) {
            // empty if block
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        System.out.println("=== setPlacedBy START ===");
        System.out.println("Item NBT: " + (stack.m_41782_() ? stack.m_41783_() : "NONE"));
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TransponderSnailBlockEntity) {
            TransponderSnailBlockEntity snailBE = (TransponderSnailBlockEntity)blockEntity;
            System.out.println("BEFORE loadFromItem - UUID: " + snailBE.snailUUID + ", Number: " + snailBE.assignedSnailNumber);
            snailBE.loadFromItem(stack);
            System.out.println("AFTER loadFromItem - UUID: " + snailBE.snailUUID + ", Number: " + snailBE.assignedSnailNumber);
            CompoundTag nbt = stack.m_41783_();
            int shellColor = 0;
            if (nbt != null && nbt.m_128441_("body_color")) {
                snailBE.bodyColor = nbt.m_128451_("body_color");
                shellColor = nbt.m_128451_("shell_color");
                snailBE.colorsInitialized = true;
            } else {
                snailBE.ensureColorsInitialized();
            }
            BlockState newState = (BlockState)level.m_8055_(pos).m_61124_((Property)SHELL_COLOR, (Comparable)Integer.valueOf(shellColor));
            level.m_7731_(pos, newState, 3);
            snailBE.m_6596_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7726_().m_8450_(pos);
            }
            level.m_7260_(pos, state, newState, 11);
            System.out.println("FINAL - UUID: " + snailBE.snailUUID + ", Number: " + snailBE.assignedSnailNumber + ", Initialized: " + snailBE.initialized);
        }
        System.out.println("=== setPlacedBy END ===");
    }

    public static String getShellVariantModel(int shellColor) {
        DyeColor dyeColor = DyeColor.m_41053_((int)shellColor);
        return "transponder_snail_shell_" + dyeColor.m_41065_();
    }

    public static void updateVisualState(Level level, BlockPos pos, boolean hasSound, boolean inCall) {
        if (level.m_5776_()) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        if (!(currentState.m_60734_() instanceof TransponderSnailBlock)) {
            return;
        }
        boolean currentHasSound = (Boolean)currentState.m_61143_((Property)HAS_SOUND);
        boolean currentInCall = (Boolean)currentState.m_61143_((Property)IN_CALL);
        if (currentHasSound != hasSound || currentInCall != inCall) {
            BlockState newState = (BlockState)((BlockState)currentState.m_61124_((Property)HAS_SOUND, (Comparable)Boolean.valueOf(hasSound))).m_61124_((Property)IN_CALL, (Comparable)Boolean.valueOf(inCall));
            level.m_7731_(pos, newState, 3);
            System.out.println("TransponderSnailBlock: Updated visual state at " + pos + " - Sound: " + hasSound + ", Call: " + inCall);
        }
    }

    public static void updateSoundState(Level level, BlockPos pos, boolean hasSound) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof TransponderSnailBlock) {
            boolean currentInCall = (Boolean)currentState.m_61143_((Property)IN_CALL);
            TransponderSnailBlock.updateVisualState(level, pos, hasSound, currentInCall);
        }
    }

    public static void updateCallState(Level level, BlockPos pos, boolean inCall) {
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60734_() instanceof TransponderSnailBlock) {
            boolean currentHasSound = (Boolean)currentState.m_61143_((Property)HAS_SOUND);
            TransponderSnailBlock.updateVisualState(level, pos, currentHasSound, inCall);
        }
    }

    public static String getVisualStateString(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof TransponderSnailBlock)) {
            return "Not a Transponder Snail block";
        }
        boolean hasSound = (Boolean)state.m_61143_((Property)HAS_SOUND);
        boolean inCall = (Boolean)state.m_61143_((Property)IN_CALL);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return String.format("Sound: %s, Call: %s, Facing: %s", hasSound, inCall, facing);
    }

    public static boolean hasVisualSoundState(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof TransponderSnailBlock) {
            return (Boolean)state.m_61143_((Property)HAS_SOUND);
        }
        return false;
    }

    public static boolean hasVisualCallState(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof TransponderSnailBlock) {
            return (Boolean)state.m_61143_((Property)IN_CALL);
        }
        return false;
    }

    public static void updateShellColor(Level level, BlockPos pos, int shellColor) {
        if (level.m_5776_()) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        if (!(currentState.m_60734_() instanceof TransponderSnailBlock)) {
            return;
        }
    }

    public static void debugPrintHitboxes() {
        System.out.println("=== TransponderSnail Hitbox Debug ===");
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            VoxelShape shape = TransponderSnailBlock.getShapeForDirection(dir);
            System.out.println(dir + ": " + shape.m_83215_());
        }
        System.out.println("=====================================");
    }

    static {
        SHAPES.put(Direction.NORTH, SHAPE_NORTH);
        SHAPES.put(Direction.SOUTH, SHAPE_SOUTH);
        SHAPES.put(Direction.EAST, SHAPE_EAST);
        SHAPES.put(Direction.WEST, SHAPE_WEST);
    }
}

