/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.block.custom.TransponderSnailBlock;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CallCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"call").then(Commands.m_82127_((String)"dial").then(Commands.m_82129_((String)"number", (ArgumentType)StringArgumentType.string()).executes(CallCommand::dialNumber)))).then(Commands.m_82127_((String)"accept").executes(CallCommand::acceptCall))).then(Commands.m_82127_((String)"end").executes(CallCommand::endCall))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"info").executes(CallCommand::showDebugInfo))).then(Commands.m_82127_((String)"calls").executes(CallCommand::showActiveCalls))).then(Commands.m_82127_((String)"registry").executes(CallCommand::showSnailRegistry))).then(Commands.m_82127_((String)"nearby").executes(CallCommand::showNearbySnails)))).then(Commands.m_82127_((String)"status").executes(CallCommand::showPlayerCallStatus))).then(Commands.m_82127_((String)"test").then(Commands.m_82127_((String)"ring").executes(CallCommand::testRing))));
    }

    private static int dialNumber(CommandContext<CommandSourceStack> context) {
        try {
            boolean success;
            int targetNumber;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String targetNumberStr = StringArgumentType.getString(context, (String)"number");
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            try {
                targetNumber = Integer.parseInt(targetNumberStr);
            }
            catch (NumberFormatException e) {
                player.m_213846_((Component)Component.m_237113_((String)("Invalid number format: " + targetNumberStr)));
                return 0;
            }
            TransponderSnailBlockEntity snailEntity = CallCommand.findNearbySnailBlockEntity(player);
            if (snailEntity == null) {
                player.m_213846_((Component)Component.m_237113_((String)"No Transponder Snail nearby! Stand within 3 blocks of one."));
                return 0;
            }
            if (!snailEntity.hasAssignedNumber()) {
                snailEntity.ensureSnailNumberAssigned((Player)player);
                if (!snailEntity.hasAssignedNumber()) {
                    player.m_213846_((Component)Component.m_237113_((String)"Failed to assign number to this snail!"));
                    return 0;
                }
            }
            if (success = callManager.initiateCallBySnailNumber(player, snailEntity.getSnailNumber(), targetNumber)) {
                player.m_213846_((Component)Component.m_237113_((String)("Dialing " + targetNumber + " from snail #" + snailEntity.getSnailNumber() + "...")));
                return 1;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Failed to initiate call"));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to dial: " + e.getMessage())));
            return 0;
        }
    }

    private static int acceptCall(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            TransponderSnailBlockEntity snailEntity = CallCommand.findNearbySnailBlockEntity(player);
            if (snailEntity == null) {
                player.m_213846_((Component)Component.m_237113_((String)"No Transponder Snail nearby!"));
                return 0;
            }
            if (!snailEntity.isRinging()) {
                player.m_213846_((Component)Component.m_237113_((String)"This snail is not ringing!"));
                return 0;
            }
            UUID callId = snailEntity.getActiveCallId();
            if (callId == null) {
                player.m_213846_((Component)Component.m_237113_((String)"No active call found!"));
                return 0;
            }
            if (callManager.acceptCall(player, callId)) {
                player.m_213846_((Component)Component.m_237113_((String)"Call accepted!"));
                return 1;
            }
            player.m_213846_((Component)Component.m_237113_((String)"Failed to accept call"));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to accept call: " + e.getMessage())));
            return 0;
        }
    }

    private static int endCall(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            if (callManager.isInCall(player.m_20148_())) {
                callManager.endCall(player);
                player.m_213846_((Component)Component.m_237113_((String)"Call ended"));
                return 1;
            }
            player.m_213846_((Component)Component.m_237113_((String)"You are not in a call"));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to end call: " + e.getMessage())));
            return 0;
        }
    }

    private static int showDebugInfo(CommandContext<CommandSourceStack> context) {
        try {
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Call System Debug Info ==="), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Call Manager: Available"), false);
            int activeCalls = callManager.getActiveCalls().size();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Active calls: " + activeCalls)), false);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to show debug info: " + e.getMessage())));
            return 0;
        }
    }

    private static int showActiveCalls(CommandContext<CommandSourceStack> context) {
        try {
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Active Calls ==="), false);
            int activeCallCount = callManager.getActiveCalls().size();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Number of active calls: " + activeCallCount)), false);
            if (activeCallCount == 0) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No active calls"), false);
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to show active calls: " + e.getMessage())));
            return 0;
        }
    }

    private static int showSnailRegistry(CommandContext<CommandSourceStack> context) {
        try {
            SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
            if (registry == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Snail registry not available!"));
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Snail Registry Info ==="), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Assigned snails: " + registry.getAssignedCount())), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Available numbers: " + registry.getAvailableCount())), false);
            registry.debugPrintState();
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to show registry info: " + e.getMessage())));
            return 0;
        }
    }

    private static int showNearbySnails(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Nearby Transponder Snails ==="), false);
            List<TransponderSnailBlockEntity> nearbySnails = CallCommand.findAllNearbySnails(player, 10);
            if (nearbySnails.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No Transponder Snails found within 10 blocks"), false);
            } else {
                for (TransponderSnailBlockEntity snail : nearbySnails) {
                    BlockPos pos = snail.m_58899_();
                    Object status = "Unknown";
                    if (snail.hasAssignedNumber()) {
                        status = "Snail #" + snail.getSnailNumber();
                        status = snail.isRinging() ? (String)status + " (Ringing)" : (snail.getActiveCallId() != null ? (String)status + " (In Call)" : (String)status + " (Idle)");
                    } else {
                        status = "Unregistered";
                    }
                    String finalStatus = status;
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  " + pos + ": " + finalStatus)), false);
                }
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to show nearby snails: " + e.getMessage())));
            return 0;
        }
    }

    private static int showPlayerCallStatus(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            TransponderCallManager callManager = CallCommand.getCallManager();
            if (callManager == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Voice chat system not available!"));
                return 0;
            }
            boolean inCall = callManager.isInCall(player.m_20148_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"=== Your Call Status ==="), false);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("In call: " + (inCall ? "Yes" : "No"))), false);
            if (inCall) {
                TransponderSnailBlockEntity nearbySnail;
                UUID callId = callManager.getPlayerCallId(player.m_20148_());
                if (callId != null) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Call ID: " + callId.toString().substring(0, 8))), false);
                }
                if ((nearbySnail = CallCommand.findNearbySnailBlockEntity(player)) != null && nearbySnail.hasAssignedNumber()) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Using snail #" + nearbySnail.getSnailNumber())), false);
                    String snailStatus = "Idle";
                    if (nearbySnail.isRinging()) {
                        snailStatus = "Ringing";
                    } else if (nearbySnail.getActiveCallId() != null) {
                        snailStatus = "Connected";
                    }
                    String finalSnailStatus = snailStatus;
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Snail status: " + finalSnailStatus)), false);
                }
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to show player status: " + e.getMessage())));
            return 0;
        }
    }

    private static int testRing(CommandContext<CommandSourceStack> context) {
        try {
            final ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            final TransponderSnailBlockEntity snailEntity = CallCommand.findNearbySnailBlockEntity(player);
            if (snailEntity == null) {
                player.m_213846_((Component)Component.m_237113_((String)"No Transponder Snail nearby!"));
                return 0;
            }
            snailEntity.setRinging(true);
            snailEntity.setActiveCall(UUID.randomUUID());
            final String snailNumberText = snailEntity.hasAssignedNumber() ? "#" + snailEntity.getSnailNumber() : "unregistered";
            player.m_213846_((Component)Component.m_237113_((String)("Test: Set snail " + snailNumberText + " to ringing")));
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    snailEntity.setRinging(false);
                    snailEntity.setActiveCall(null);
                    player.m_213846_((Component)Component.m_237113_((String)("Test: Stopped ringing for snail " + snailNumberText)));
                }
            }, 5000L);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to test ring: " + e.getMessage())));
            return 0;
        }
    }

    private static TransponderCallManager getCallManager() {
        return TransponderSnails.getCallManager();
    }

    private static TransponderSnailBlockEntity findNearbySnailBlockEntity(ServerPlayer player) {
        BlockPos playerPos = player.m_20183_();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockEntity blockEntity;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    if (!(player.m_9236_().m_8055_(checkPos).m_60734_() instanceof TransponderSnailBlock) || !((blockEntity = player.m_9236_().m_7702_(checkPos)) instanceof TransponderSnailBlockEntity)) continue;
                    TransponderSnailBlockEntity snailEntity = (TransponderSnailBlockEntity)blockEntity;
                    return snailEntity;
                }
            }
        }
        return null;
    }

    private static List<TransponderSnailBlockEntity> findAllNearbySnails(ServerPlayer player, int range) {
        ArrayList<TransponderSnailBlockEntity> snails = new ArrayList<TransponderSnailBlockEntity>();
        BlockPos playerPos = player.m_20183_();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockEntity blockEntity;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    if (!(player.m_9236_().m_8055_(checkPos).m_60734_() instanceof TransponderSnailBlock) || !((blockEntity = player.m_9236_().m_7702_(checkPos)) instanceof TransponderSnailBlockEntity)) continue;
                    TransponderSnailBlockEntity snailEntity = (TransponderSnailBlockEntity)blockEntity;
                    snails.add(snailEntity);
                }
            }
        }
        return snails;
    }

    private static BlockPos findNearbyTransponderSnail(ServerPlayer player) {
        TransponderSnailBlockEntity snailEntity = CallCommand.findNearbySnailBlockEntity(player);
        return snailEntity != null ? snailEntity.m_58899_() : null;
    }
}

