/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SnailNumberCommand {
    private static final Map<UUID, Long> pendingClearConfirmations = new ConcurrentHashMap<UUID, Long>();
    private static final long CONFIRMATION_TIMEOUT_MS = 30000L;

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        SnailNumberCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"snailnumber").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(SnailNumberCommand::listAssignedNumbers)).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SnailNumberCommand::listAssignedNumbersPaged)))).then(Commands.m_82127_((String)"stats").executes(SnailNumberCommand::showStats))).then(Commands.m_82127_((String)"lookup").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1000, (int)9999)).executes(SnailNumberCommand::lookupNumber)))).then(Commands.m_82127_((String)"find").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SnailNumberCommand::findPlayerSnails)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(source -> source.m_6761_(3))).then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)1000, (int)9999)).executes(SnailNumberCommand::removeNumber)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(source -> source.m_6761_(4))).executes(SnailNumberCommand::requestClearConfirmation)).then(Commands.m_82127_((String)"Y").executes(SnailNumberCommand::confirmClearAllNumbers))).then(Commands.m_82127_((String)"N").executes(SnailNumberCommand::cancelClearAllNumbers)))).then(Commands.m_82127_((String)"help").executes(SnailNumberCommand::showHelp)));
    }

    private static int listAssignedNumbers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SnailNumberCommand.listAssignedNumbersPaged(context, 1);
    }

    private static int listAssignedNumbersPaged(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return SnailNumberCommand.listAssignedNumbersPaged(context, page);
    }

    private static int listAssignedNumbersPaged(CommandContext<CommandSourceStack> context, int page) throws CommandSyntaxException {
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        ArrayList<Map.Entry<Integer, UUID>> assignments = new ArrayList<Map.Entry<Integer, UUID>>();
        for (int i = 1000; i <= 9999; ++i) {
            UUID snailUUID = registry.getSnailByNumber(i);
            if (snailUUID == null) continue;
            assignments.add(Map.entry(i, snailUUID));
        }
        if (assignments.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No snail numbers are currently assigned."), false);
            return 1;
        }
        int itemsPerPage = 10;
        int totalPages = (int)Math.ceil((double)assignments.size() / (double)itemsPerPage);
        page = Math.max(1, Math.min(page, totalPages));
        int startIndex = (page - 1) * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, assignments.size());
        MutableComponent header = Component.m_237113_((String)("=== Assigned Snail Numbers (Page " + page + "/" + totalPages + ") ===")).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$listAssignedNumbersPaged$4((Component)header), false);
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry assignment = (Map.Entry)assignments.get(i);
            int number = (Integer)assignment.getKey();
            UUID uuid = (UUID)assignment.getValue();
            MutableComponent numberComponent = Component.m_237113_((String)("#" + number)).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
            MutableComponent uuidComponent = Component.m_237113_((String)(uuid.toString().substring(0, 8) + "...")).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Full UUID: " + uuid.toString())))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid.toString())));
            MutableComponent line = Component.m_237113_((String)"  ").m_7220_((Component)numberComponent).m_7220_((Component)Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)uuidComponent);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$listAssignedNumbersPaged$6((Component)line), false);
        }
        if (totalPages > 1) {
            MutableComponent nav = Component.m_237113_((String)"Use ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)"/snailnumber list <page>").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" to navigate pages").m_130940_(ChatFormatting.GRAY));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$listAssignedNumbersPaged$7((Component)nav), false);
        }
        return 1;
    }

    private static int showStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        int assigned = registry.getAssignedCount();
        int available = registry.getAvailableCount();
        int total = assigned + available;
        double percentUsed = (double)assigned / (double)total * 100.0;
        MutableComponent header = Component.m_237113_((String)"=== Snail Number Registry Statistics ===").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
        MutableComponent assignedLine = Component.m_237113_((String)"Assigned: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(assigned)).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        MutableComponent availableLine = Component.m_237113_((String)"Available: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(available)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        MutableComponent totalLine = Component.m_237113_((String)"Total Capacity: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(total)).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        MutableComponent percentLine = Component.m_237113_((String)"Usage: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.1f%%", percentUsed)).m_130944_(new ChatFormatting[]{percentUsed > 80.0 ? ChatFormatting.RED : (percentUsed > 50.0 ? ChatFormatting.YELLOW : ChatFormatting.GREEN), ChatFormatting.BOLD}));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$8((Component)header), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$9((Component)assignedLine), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$10((Component)availableLine), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$11((Component)totalLine), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$12((Component)percentLine), false);
        if (percentUsed > 90.0) {
            MutableComponent warning = Component.m_237113_((String)"\u26a0 Warning: Registry is nearly full!").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showStats$13((Component)warning), false);
        }
        return 1;
    }

    private static int lookupNumber(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int number = IntegerArgumentType.getInteger(context, (String)"number");
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        UUID snailUUID = registry.getSnailByNumber(number);
        if (snailUUID == null) {
            MutableComponent message = Component.m_237113_((String)("Snail number #" + number + " is not assigned to any snail.")).m_130940_(ChatFormatting.YELLOW);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$lookupNumber$14((Component)message), false);
            return 1;
        }
        MutableComponent numberComponent = Component.m_237113_((String)("#" + number)).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
        MutableComponent uuidComponent = Component.m_237113_((String)snailUUID.toString()).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy UUID"))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, snailUUID.toString())));
        MutableComponent message = Component.m_237113_((String)"Snail number ").m_7220_((Component)numberComponent).m_7220_((Component)Component.m_237113_((String)" is assigned to: ")).m_7220_((Component)uuidComponent);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$lookupNumber$16((Component)message), false);
        return 1;
    }

    private static int findPlayerSnails(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        MutableComponent message = Component.m_237113_((String)"Player snail tracking is not yet implemented. ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)"Snail numbers are tied to individual items, not players.").m_130940_(ChatFormatting.GRAY));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$findPlayerSnails$17((Component)message), false);
        return 1;
    }

    private static int removeNumber(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int number = IntegerArgumentType.getInteger(context, (String)"number");
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        UUID snailUUID = registry.getSnailByNumber(number);
        if (snailUUID == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Number #" + number + " is not assigned!")));
            return 0;
        }
        boolean removed = registry.removeSnailAssignment(snailUUID);
        if (removed) {
            MutableComponent message = Component.m_237113_((String)("Successfully removed assignment for snail number #" + number)).m_130940_(ChatFormatting.GREEN);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$removeNumber$18((Component)message), false);
            MutableComponent warning = Component.m_237113_((String)"\u26a0 Warning: This may break existing calls using that number!").m_130940_(ChatFormatting.RED);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$removeNumber$19((Component)warning), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to remove assignment!"));
        return 0;
    }

    private static int requestClearConfirmation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerId = player.m_20148_();
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        int assignedCount = registry.getAssignedCount();
        if (assignedCount == 0) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No snail numbers are assigned - nothing to clear.").m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }
        pendingClearConfirmations.put(playerId, System.currentTimeMillis());
        MutableComponent header = Component.m_237113_((String)"\u26a0 DANGER \u26a0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
        MutableComponent warning1 = Component.m_237113_((String)("This will permanently delete ALL " + assignedCount + " ACTIVE SNAIL NUMBERS!")).m_130940_(ChatFormatting.RED);
        MutableComponent warning2 = Component.m_237113_((String)"\u2022 All Transponder Snail numbers will be removed").m_130940_(ChatFormatting.YELLOW);
        MutableComponent warning3 = Component.m_237113_((String)"\u2022 All active calls will be terminated").m_130940_(ChatFormatting.YELLOW);
        MutableComponent prompt = Component.m_237113_((String)"Are you absolutely sure? This action cannot be undone!").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
        MutableComponent yesButton = Component.m_237113_((String)"[YES - DELETE ALL]").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to permanently delete all snail numbers"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/snailnumber clear Y")));
        MutableComponent noButton = Component.m_237113_((String)"[NO]").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to cancel and keep all snail numbers"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/snailnumber clear N")));
        MutableComponent buttons = Component.m_237113_((String)"Click: ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)yesButton).m_7220_((Component)Component.m_237113_((String)"  ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)noButton);
        MutableComponent timeout = Component.m_237113_((String)"This confirmation will expire in 30 seconds.").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$23((Component)header), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$24((Component)warning1), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$25((Component)warning2), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$26((Component)warning3), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)""), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$28((Component)prompt), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$29((Component)buttons), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$requestClearConfirmation$30((Component)timeout), false);
        return 1;
    }

    private static int confirmClearAllNumbers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerId = player.m_20148_();
        Long confirmationTime = pendingClearConfirmations.get(playerId);
        if (confirmationTime == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No clear operation pending. Use /snailnumber clear first."));
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - confirmationTime > 30000L) {
            pendingClearConfirmations.remove(playerId);
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Confirmation expired. Use /snailnumber clear to try again."));
            return 0;
        }
        pendingClearConfirmations.remove(playerId);
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Registry not available!"));
            return 0;
        }
        int clearedCount = registry.clearAllAssignments();
        MutableComponent success = Component.m_237113_((String)"\u2713 Successfully cleared all snail number assignments!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD});
        MutableComponent details = Component.m_237113_((String)("Deleted " + clearedCount + " snail number assignments.")).m_130940_(ChatFormatting.YELLOW);
        MutableComponent note = Component.m_237113_((String)"All Transponder Snails will need to be reactivated to get new numbers.").m_130940_(ChatFormatting.GRAY);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$confirmClearAllNumbers$31((Component)success), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$confirmClearAllNumbers$32((Component)details), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$confirmClearAllNumbers$33((Component)note), false);
        String adminName = player.m_7755_().getString();
        System.out.println("ADMIN ACTION: " + adminName + " (" + playerId + ") cleared all snail number assignments (" + clearedCount + " numbers)");
        return 1;
    }

    private static int cancelClearAllNumbers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        UUID playerId = player.m_20148_();
        boolean hadPending = pendingClearConfirmations.remove(playerId) != null;
        MutableComponent message = hadPending ? Component.m_237113_((String)"Clear operation cancelled. All snail numbers are safe.").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"No clear operation was pending.").m_130940_(ChatFormatting.YELLOW);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$cancelClearAllNumbers$34((Component)message), false);
        return 1;
    }

    private static int showHelp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MutableComponent header = Component.m_237113_((String)"=== Snail Number Commands ===").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        Component[] helpLines = new Component[]{Component.m_237113_((String)"/snailnumber list [page]").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" - List all assigned numbers").m_130940_(ChatFormatting.GRAY)), Component.m_237113_((String)"/snailnumber stats").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" - Show registry statistics").m_130940_(ChatFormatting.GRAY)), Component.m_237113_((String)"/snailnumber lookup <number>").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" - Find which snail owns a number").m_130940_(ChatFormatting.GRAY)), Component.m_237113_((String)"/snailnumber find <player>").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)" - Find all snails owned by a player").m_130940_(ChatFormatting.GRAY)), Component.m_237113_((String)"/snailnumber remove <number>").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" - Remove a number assignment (OP 3)").m_130940_(ChatFormatting.GRAY)), Component.m_237113_((String)"/snailnumber clear").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)" - Clear all assignments (requires Y/N confirmation) (OP 4)").m_130940_(ChatFormatting.GRAY))};
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SnailNumberCommand.lambda$showHelp$35((Component)header), false);
        for (Component line : helpLines) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> line, false);
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$showHelp$35(Component header) {
        return header;
    }

    private static /* synthetic */ Component lambda$cancelClearAllNumbers$34(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$confirmClearAllNumbers$33(Component note) {
        return note;
    }

    private static /* synthetic */ Component lambda$confirmClearAllNumbers$32(Component details) {
        return details;
    }

    private static /* synthetic */ Component lambda$confirmClearAllNumbers$31(Component success) {
        return success;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$30(Component timeout) {
        return timeout;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$29(Component buttons) {
        return buttons;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$28(Component prompt) {
        return prompt;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$26(Component warning3) {
        return warning3;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$25(Component warning2) {
        return warning2;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$24(Component warning1) {
        return warning1;
    }

    private static /* synthetic */ Component lambda$requestClearConfirmation$23(Component header) {
        return header;
    }

    private static /* synthetic */ Component lambda$removeNumber$19(Component warning) {
        return warning;
    }

    private static /* synthetic */ Component lambda$removeNumber$18(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$findPlayerSnails$17(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$lookupNumber$16(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$lookupNumber$14(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$showStats$13(Component warning) {
        return warning;
    }

    private static /* synthetic */ Component lambda$showStats$12(Component percentLine) {
        return percentLine;
    }

    private static /* synthetic */ Component lambda$showStats$11(Component totalLine) {
        return totalLine;
    }

    private static /* synthetic */ Component lambda$showStats$10(Component availableLine) {
        return availableLine;
    }

    private static /* synthetic */ Component lambda$showStats$9(Component assignedLine) {
        return assignedLine;
    }

    private static /* synthetic */ Component lambda$showStats$8(Component header) {
        return header;
    }

    private static /* synthetic */ Component lambda$listAssignedNumbersPaged$7(Component nav) {
        return nav;
    }

    private static /* synthetic */ Component lambda$listAssignedNumbersPaged$6(Component line) {
        return line;
    }

    private static /* synthetic */ Component lambda$listAssignedNumbersPaged$4(Component header) {
        return header;
    }
}

