/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.eclipce.transpondersnails.data.SnailNBTHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class TransponderSnailItemCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"snailitem").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"setstate").then(Commands.m_82129_((String)"state", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            int stateValue = IntegerArgumentType.getInteger((CommandContext)context, (String)"state");
            ItemStack held = player.m_21205_();
            int snailNumber = SnailNBTHandler.getSnailNumber(held);
            if (snailNumber == -1) {
                player.m_213846_((Component)Component.m_237113_((String)"Hold a Transponder Snail!"));
                return 0;
            }
            CompoundTag nbt = held.m_41784_();
            String[] states = new String[]{"idle", "ringing", "connected", "connected"};
            nbt.m_128359_("call_state", states[stateValue]);
            if (stateValue == 3) {
                nbt.m_128379_("has_active_audio", true);
            } else {
                nbt.m_128473_("has_active_audio");
            }
            player.m_213846_((Component)Component.m_237113_((String)("Set state to: " + states[stateValue])));
            return 1;
        })))).then(Commands.m_82127_((String)"debug").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack held = player.m_21205_();
            CompoundTag nbt = held.m_41783_();
            if (nbt == null) {
                player.m_213846_((Component)Component.m_237113_((String)"No NBT data"));
                return 0;
            }
            player.m_213846_((Component)Component.m_237113_((String)"=== Snail Item Debug ==="));
            player.m_213846_((Component)Component.m_237113_((String)("Call State: " + nbt.m_128461_("call_state"))));
            player.m_213846_((Component)Component.m_237113_((String)("Shell Color: " + nbt.m_128451_("shell_color"))));
            player.m_213846_((Component)Component.m_237113_((String)("Body Color: " + Integer.toHexString(nbt.m_128451_("body_color")))));
            player.m_213846_((Component)Component.m_237113_((String)("Has Audio: " + nbt.m_128471_("has_active_audio"))));
            return 1;
        })));
    }
}

