/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.data;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.eclipce.transpondersnails.block.ModBlocks;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnailNBTHandler {
    private static final String SNAIL_UUID_TAG = "snail_uuid";
    private static final String CACHED_NUMBER_TAG = "cached_snail_number";
    private static final String ACTIVATION_TIMESTAMP_TAG = "activation_time";
    private static final String ACTIVATION_PLAYER_TAG = "activated_by";
    private static final String SNAIL_TYPE_TAG = "snail_type";

    @Nullable
    private static SnailType getSnailType(@NotNull ItemStack stack) {
        BlockItem blockItem;
        if (stack.m_41619_()) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() == ModBlocks.TRANSPONDER_SNAIL.get()) {
            return SnailType.BLOCK;
        }
        if (SnailNBTHandler.hasSnailNBT(stack)) {
            return SnailType.HANDHELD;
        }
        return null;
    }

    private static boolean hasSnailNBT(@NotNull ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && (nbt.m_128403_(SNAIL_UUID_TAG) || nbt.m_128441_(CACHED_NUMBER_TAG));
    }

    @Nullable
    public static UUID getOrCreateSnailUUID(@NotNull ItemStack stack, @Nullable UUID activatingPlayerUUID) {
        if (stack.m_41619_()) {
            return null;
        }
        SnailType snailType = SnailNBTHandler.getSnailType(stack);
        if (snailType == null) {
            System.err.println("SnailNBTHandler: Attempted to get UUID for non-snail item: " + stack.m_41720_());
            return null;
        }
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128403_(SNAIL_UUID_TAG)) {
            UUID existingUUID = nbt.m_128342_(SNAIL_UUID_TAG);
            if (!nbt.m_128441_(SNAIL_TYPE_TAG)) {
                nbt.m_128359_(SNAIL_TYPE_TAG, snailType.name());
            }
            return existingUUID;
        }
        UUID newUUID = UUID.randomUUID();
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry != null) {
            int snailNumber = registry.assignNumberToSnail(newUUID);
            if (snailNumber != -1) {
                nbt.m_128362_(SNAIL_UUID_TAG, newUUID);
                nbt.m_128405_(CACHED_NUMBER_TAG, snailNumber);
                nbt.m_128356_(ACTIVATION_TIMESTAMP_TAG, System.currentTimeMillis());
                nbt.m_128359_(SNAIL_TYPE_TAG, snailType.name());
                if (activatingPlayerUUID != null) {
                    nbt.m_128362_(ACTIVATION_PLAYER_TAG, activatingPlayerUUID);
                }
                System.out.println("SnailNBTHandler: Created new " + snailType.name().toLowerCase() + " snail with UUID " + newUUID + " and number #" + snailNumber);
                return newUUID;
            }
            System.err.println("SnailNBTHandler: Failed to assign number to new " + snailType.name().toLowerCase() + " snail UUID " + newUUID);
            return null;
        }
        System.err.println("SnailNBTHandler: Registry not available for UUID assignment");
        return null;
    }

    @Nullable
    public static UUID getSnailUUID(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        if (SnailNBTHandler.getSnailType(stack) == null && !SnailNBTHandler.hasSnailNBT(stack)) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            CompoundTag blockEntityTag;
            if (nbt.m_128403_(SNAIL_UUID_TAG)) {
                return nbt.m_128342_(SNAIL_UUID_TAG);
            }
            if (nbt.m_128441_("BlockEntityTag") && (blockEntityTag = nbt.m_128469_("BlockEntityTag")).m_128403_("SnailUUID")) {
                return blockEntityTag.m_128342_("SnailUUID");
            }
        }
        return null;
    }

    public static int getSnailNumber(@NotNull ItemStack stack) {
        int number;
        SnailNumberRegistry registry;
        CompoundTag blockEntityTag;
        if (stack.m_41619_()) {
            return -1;
        }
        if (SnailNBTHandler.getSnailType(stack) == null && !SnailNBTHandler.hasSnailNBT(stack)) {
            return -1;
        }
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_(CACHED_NUMBER_TAG)) {
            return nbt.m_128451_(CACHED_NUMBER_TAG);
        }
        if (nbt.m_128441_("BlockEntityTag") && (blockEntityTag = nbt.m_128469_("BlockEntityTag")).m_128441_("AssignedNumber")) {
            return blockEntityTag.m_128451_("AssignedNumber");
        }
        UUID snailUUID = SnailNBTHandler.getSnailUUID(stack);
        if (snailUUID != null && (registry = SnailNumberRegistry.getInstance()) != null && (number = registry.getSnailNumber(snailUUID)) != -1) {
            nbt.m_128405_(CACHED_NUMBER_TAG, number);
            return number;
        }
        return -1;
    }

    @Nullable
    public static SnailType getStoredSnailType(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(SNAIL_TYPE_TAG)) {
            try {
                return SnailType.valueOf(nbt.m_128461_(SNAIL_TYPE_TAG));
            }
            catch (IllegalArgumentException e) {
                System.err.println("SnailNBTHandler: Invalid snail type in NBT: " + nbt.m_128461_(SNAIL_TYPE_TAG));
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static SnailType getEffectiveSnailType(@NotNull ItemStack stack) {
        SnailType storedType = SnailNBTHandler.getStoredSnailType(stack);
        if (storedType != null) {
            return storedType;
        }
        return SnailNBTHandler.getSnailType(stack);
    }

    public static long getActivationTimestamp(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return 0L;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_(ACTIVATION_TIMESTAMP_TAG)) {
            return nbt.m_128454_(ACTIVATION_TIMESTAMP_TAG);
        }
        return 0L;
    }

    @Nullable
    public static UUID getActivatingPlayer(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128403_(ACTIVATION_PLAYER_TAG)) {
            return nbt.m_128342_(ACTIVATION_PLAYER_TAG);
        }
        return null;
    }

    public static boolean isSnailActivated(@NotNull ItemStack stack) {
        return SnailNBTHandler.getSnailUUID(stack) != null && SnailNBTHandler.getSnailNumber(stack) != -1;
    }

    public static void updateCachedNumber(@NotNull ItemStack stack, int newNumber) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        if (newNumber == -1) {
            nbt.m_128473_(CACHED_NUMBER_TAG);
        } else {
            nbt.m_128405_(CACHED_NUMBER_TAG, newNumber);
        }
    }

    public static void copySnailData(@NotNull ItemStack source, @NotNull ItemStack target) {
        if (source.m_41619_() || target.m_41619_()) {
            return;
        }
        CompoundTag sourceNbt = source.m_41783_();
        if (sourceNbt == null) {
            return;
        }
        CompoundTag targetNbt = target.m_41784_();
        if (sourceNbt.m_128403_(SNAIL_UUID_TAG)) {
            targetNbt.m_128362_(SNAIL_UUID_TAG, sourceNbt.m_128342_(SNAIL_UUID_TAG));
        }
        if (sourceNbt.m_128441_(CACHED_NUMBER_TAG)) {
            targetNbt.m_128405_(CACHED_NUMBER_TAG, sourceNbt.m_128451_(CACHED_NUMBER_TAG));
        }
        if (sourceNbt.m_128441_(ACTIVATION_TIMESTAMP_TAG)) {
            targetNbt.m_128356_(ACTIVATION_TIMESTAMP_TAG, sourceNbt.m_128454_(ACTIVATION_TIMESTAMP_TAG));
        }
        if (sourceNbt.m_128403_(ACTIVATION_PLAYER_TAG)) {
            targetNbt.m_128362_(ACTIVATION_PLAYER_TAG, sourceNbt.m_128342_(ACTIVATION_PLAYER_TAG));
        }
        if (sourceNbt.m_128441_(SNAIL_TYPE_TAG)) {
            targetNbt.m_128359_(SNAIL_TYPE_TAG, sourceNbt.m_128461_(SNAIL_TYPE_TAG));
        }
    }

    public static void prepareBlankSnail(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_(SNAIL_UUID_TAG);
            nbt.m_128473_(CACHED_NUMBER_TAG);
            nbt.m_128473_(ACTIVATION_TIMESTAMP_TAG);
            nbt.m_128473_(ACTIVATION_PLAYER_TAG);
            nbt.m_128473_(SNAIL_TYPE_TAG);
        }
    }

    public static boolean validateSnailData(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        UUID snailUUID = SnailNBTHandler.getSnailUUID(stack);
        if (snailUUID == null) {
            return true;
        }
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            return true;
        }
        int registryNumber = registry.getSnailNumber(snailUUID);
        int cachedNumber = SnailNBTHandler.getSnailNumber(stack);
        if (registryNumber == -1) {
            System.err.println("SnailNBTHandler: Validation failed - UUID " + snailUUID + " not found in registry");
            return false;
        }
        if (cachedNumber != -1 && cachedNumber != registryNumber) {
            System.err.println("SnailNBTHandler: Validation failed - cached number " + cachedNumber + " doesn't match registry number " + registryNumber + " for UUID " + snailUUID);
            return false;
        }
        return true;
    }

    public static boolean repairSnailData(@NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        UUID snailUUID = SnailNBTHandler.getSnailUUID(stack);
        if (snailUUID == null) {
            return false;
        }
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        if (registry == null) {
            return false;
        }
        int registryNumber = registry.getSnailNumber(snailUUID);
        if (registryNumber == -1) {
            System.err.println("SnailNBTHandler: Cannot repair snail with UUID " + snailUUID + " - not found in registry");
            return false;
        }
        SnailNBTHandler.updateCachedNumber(stack, registryNumber);
        System.out.println("SnailNBTHandler: Repaired snail data - updated cached number to " + registryNumber + " for UUID " + snailUUID);
        return true;
    }

    public static void addSnailTooltip(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (stack.m_41619_()) {
            return;
        }
        int snailNumber = SnailNBTHandler.getSnailNumber(stack);
        if (snailNumber != -1) {
            MutableComponent numberTooltip = Component.m_237113_((String)("#: " + snailNumber)).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
            tooltip.add((Component)numberTooltip);
            if (flag.m_7050_()) {
                long activationTime;
                SnailType snailType;
                UUID snailUUID = SnailNBTHandler.getSnailUUID(stack);
                if (snailUUID != null) {
                    MutableComponent uuidTooltip = Component.m_237113_((String)("UUID: " + snailUUID.toString().substring(0, 8) + "...")).m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((Component)uuidTooltip);
                }
                if ((snailType = SnailNBTHandler.getEffectiveSnailType(stack)) != null) {
                    MutableComponent typeTooltip = Component.m_237113_((String)("Type: " + snailType.name().toLowerCase())).m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((Component)typeTooltip);
                }
                if ((activationTime = SnailNBTHandler.getActivationTimestamp(stack)) > 0L) {
                    MutableComponent timeTooltip = Component.m_237113_((String)("Activated: " + new Date(activationTime))).m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((Component)timeTooltip);
                }
            }
        } else {
            MutableComponent inactiveTooltip = Component.m_237113_((String)"Right-click to register").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            tooltip.add((Component)inactiveTooltip);
        }
    }

    public static enum SnailType {
        BLOCK,
        HANDHELD;

    }
}

