/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.eclipce.transpondersnails.entity.client.DenDenMushiModel;
import net.eclipce.transpondersnails.entity.client.ModModelLayers;
import net.eclipce.transpondersnails.entity.custom.DenDenMushiEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;

public class DenDenMushiRenderer
extends MobRenderer<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>> {
    private static final ResourceLocation[] SHELL_TEXTURES = new ResourceLocation[16];
    private static final ResourceLocation BODY_BASE_TEXTURE = new ResourceLocation("transpondersnails", "textures/entity/den_den_mushi/snail/den_den_mushi_snail_body.png");
    private static final ResourceLocation BODY_DETAILS_TEXTURE = new ResourceLocation("transpondersnails", "textures/entity/den_den_mushi/snail/den_den_mushi_snail_eyes.png");

    public DenDenMushiRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new DenDenMushiModel(pContext.m_174023_(ModModelLayers.DEN_DEN_MUSHI_LAYER)), 0.5f);
        this.m_115326_(new TintedBodyLayer((RenderLayerParent<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>>)this));
        this.m_115326_(new DetailsLayer((RenderLayerParent<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>>)this));
    }

    public ResourceLocation getTextureLocation(DenDenMushiEntity entity) {
        int shellColor = entity.getShellColor();
        return SHELL_TEXTURES[shellColor];
    }

    public void render(DenDenMushiEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.m_6162_()) {
            pMatrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            DenDenMushiRenderer.SHELL_TEXTURES[color.m_41060_()] = new ResourceLocation("transpondersnails", "textures/entity/den_den_mushi/shell/den_den_mushi_shell_" + color.m_41065_() + ".png");
        }
    }

    private static class TintedBodyLayer
    extends RenderLayer<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>> {
        public TintedBodyLayer(RenderLayerParent<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DenDenMushiEntity entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            int bodyColor = entity.getBodyColor();
            float r = (float)(bodyColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(bodyColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(bodyColor & 0xFF) / 255.0f;
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)BODY_BASE_TEXTURE));
            DenDenMushiModel model = (DenDenMushiModel)this.m_117386_();
            model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }

    private static class DetailsLayer
    extends RenderLayer<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>> {
        public DetailsLayer(RenderLayerParent<DenDenMushiEntity, DenDenMushiModel<DenDenMushiEntity>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, DenDenMushiEntity entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)BODY_DETAILS_TEXTURE));
            DenDenMushiModel model = (DenDenMushiModel)this.m_117386_();
            model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

