/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.entity.client;

import java.util.UUID;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.data.SnailNBTHandler;
import net.eclipce.transpondersnails.voice.server.CallSession;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class TransponderSnailItemProperties {
    public static float calculateCallState(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        TransponderCallManager callManager;
        int snailNumber;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("call_state")) {
            String state;
            switch (state = nbt.m_128461_("call_state")) {
                case "ringing": {
                    return 0.25f;
                }
                case "connected": {
                    if (nbt.m_128471_("has_active_audio")) {
                        return 0.75f;
                    }
                    return 0.5f;
                }
                case "busy": {
                    return 0.25f;
                }
            }
        }
        if ((snailNumber = SnailNBTHandler.getSnailNumber(stack)) != -1 && (callManager = TransponderSnails.getCallManager()) != null) {
            if (callManager.isSnailRinging(snailNumber)) {
                return 0.25f;
            }
            if (callManager.isSnailInCall(snailNumber)) {
                UUID callId = null;
                for (CallSession session : callManager.getActiveCalls()) {
                    if (!session.isParticipant(snailNumber)) continue;
                    callId = session.getCallId();
                    if (session.getState() == CallSession.CallState.CONNECTED) {
                        if (callManager.hasActiveAudio(snailNumber)) {
                            return 0.75f;
                        }
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public static float calculateShellColor(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            CompoundTag beTag;
            if (nbt.m_128441_("shell_color")) {
                return (float)nbt.m_128451_("shell_color") / 100.0f;
            }
            if (nbt.m_128441_("BlockEntityTag") && (beTag = nbt.m_128469_("BlockEntityTag")).m_128441_("ShellColor")) {
                return (float)beTag.m_128451_("ShellColor") / 100.0f;
            }
        }
        return 0.0f;
    }
}

