/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.entity.custom;

import net.eclipce.transpondersnails.entity.ModEntities;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class DenDenMushiEntity
extends Animal {
    private static final EntityDataAccessor<Integer> BODY_COLOR = SynchedEntityData.m_135353_(DenDenMushiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELL_COLOR = SynchedEntityData.m_135353_(DenDenMushiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public DenDenMushiEntity(EntityType<? extends Animal> pAnimal, Level pLevel) {
        super(pAnimal, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreedGoal((Animal)this, 1.15));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_}), false));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new PanicGoal((PathfinderMob)this, 1.1));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnType) {
        return true;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ModEntities.DEN_DEN_MUSHI.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_41910_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_144063_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BODY_COLOR, (Object)16115363);
        this.f_19804_.m_135372_(SHELL_COLOR, (Object)0);
        System.out.println("defineSynchedData called on " + (this.m_9236_().m_5776_() ? "CLIENT" : "SERVER"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag nbt) {
        if (!level.m_5776_()) {
            int bodyColor = this.generateRandomPastelColor();
            int shellColor = this.generateRandomShellColor();
            this.setBodyColor(bodyColor);
            this.setShellColor(shellColor);
            System.out.println("SERVER: Finalized spawn with shell=" + shellColor + " (" + DyeColor.m_41053_((int)shellColor).m_41065_() + "), body=#" + Integer.toHexString(bodyColor));
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, nbt);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(SHELL_COLOR)) {
            System.out.println("SYNC: Shell color updated to " + this.getShellColor() + " (" + DyeColor.m_41053_((int)this.getShellColor()).m_41065_() + ") on " + (this.m_9236_().m_5776_() ? "CLIENT" : "SERVER"));
        }
    }

    private int generateRandomShellColor() {
        return this.f_19796_.m_188503_(16);
    }

    private int generateRandomPastelColor() {
        float hue = this.f_19796_.m_188501_();
        float saturation = 0.7f + this.f_19796_.m_188501_() * 0.1f;
        float lightness = 0.7f + this.f_19796_.m_188501_() * 0.2f;
        return this.hslToRgb(hue, saturation, lightness);
    }

    private int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = this.hueToRgb(p, q, h + 0.33333334f);
            g = this.hueToRgb(p, q, h);
            b = this.hueToRgb(p, q, h - 0.33333334f);
        }
        int red = Math.round(r * 255.0f);
        int green = Math.round(g * 255.0f);
        int blue = Math.round(b * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    private float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public int getBodyColor() {
        return (Integer)this.f_19804_.m_135370_(BODY_COLOR);
    }

    public void setBodyColor(int color) {
        this.f_19804_.m_135381_(BODY_COLOR, (Object)color);
    }

    public int getShellColor() {
        int color = (Integer)this.f_19804_.m_135370_(SHELL_COLOR);
        return Math.max(0, Math.min(15, color));
    }

    public void setShellColor(int color) {
        int clampedColor = Math.max(0, Math.min(15, color));
        this.f_19804_.m_135381_(SHELL_COLOR, (Object)clampedColor);
        System.out.println("Shell color set to: " + clampedColor + " (" + DyeColor.m_41053_((int)clampedColor).m_41065_() + ") on " + (this.m_9236_().m_5776_() ? "CLIENT" : "SERVER"));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        System.out.println("mobInteract called! Side: " + (this.m_9236_().m_5776_() ? "CLIENT" : "SERVER") + ", Hand: " + hand + ", Item: " + player.m_21120_(hand));
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41619_()) {
            System.out.println("Empty hand detected - attempting pickup");
            if (!this.m_9236_().f_46443_) {
                System.out.println("=== ENTITY PICKUP DEBUG ===");
                System.out.println("Entity Shell Color (getter): " + this.getShellColor() + " (" + DyeColor.m_41053_((int)this.getShellColor()).m_41065_() + ")");
                System.out.println("Entity Shell Color (raw data): " + this.f_19804_.m_135370_(SHELL_COLOR));
                System.out.println("Entity Body Color: #" + Integer.toHexString(this.getBodyColor()).toUpperCase());
                ItemStack denDenMushiItem = DenDenMushiItem.createFromEntity(this);
                System.out.println("Created item shell color: " + DenDenMushiItem.getShellColor(denDenMushiItem));
                System.out.println("Created item body color: #" + Integer.toHexString(DenDenMushiItem.getBodyColor(denDenMushiItem)).toUpperCase());
                if (!player.m_150109_().m_36054_(denDenMushiItem)) {
                    player.m_36176_(denDenMushiItem, false);
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                System.out.println("Entity removed from world");
                System.out.println("========================");
                this.m_146870_();
            } else {
                System.out.println("Client-side pickup - no processing needed");
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        Item item = itemstack.m_41720_();
        if (item instanceof DyeItem) {
            DyeColor dyeColor;
            DyeItem dyeItem = (DyeItem)item;
            if (!this.m_9236_().f_46443_ && (dyeColor = dyeItem.m_41089_()).m_41060_() != this.getShellColor()) {
                System.out.println("Dyeing entity from " + DyeColor.m_41053_((int)this.getShellColor()).m_41065_() + " to " + dyeColor.m_41065_());
                this.setShellColor(dyeColor.m_41060_());
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BodyColor", this.getBodyColor());
        compound.m_128405_("ShellColor", this.getShellColor());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BodyColor")) {
            this.setBodyColor(compound.m_128451_("BodyColor"));
        }
        if (compound.m_128441_("ShellColor")) {
            this.setShellColor(compound.m_128451_("ShellColor"));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        if (compound.m_128441_("BodyColor")) {
            if (compound.m_128435_("BodyColor") == 8) {
                String colorStr = compound.m_128461_("BodyColor");
                try {
                    colorStr = colorStr.replace("#", "");
                    int color = Integer.parseInt(colorStr, 16);
                    this.setBodyColor(color);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.setBodyColor(compound.m_128451_("BodyColor"));
            }
        }
        if (compound.m_128441_("ShellColor")) {
            if (compound.m_128435_("ShellColor") == 8) {
                String colorName = compound.m_128461_("ShellColor").toLowerCase();
                for (DyeColor dye : DyeColor.values()) {
                    if (!dye.m_41065_().equals(colorName)) continue;
                    this.setShellColor(dye.m_41060_());
                    break;
                }
            } else {
                this.setShellColor(compound.m_128451_("ShellColor"));
            }
        }
    }
}

