/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;

public class DenDenMushiSpawnConditions {
    public static boolean checkDenDenMushiSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        System.out.println("=== DEN DEN MUSHI SPAWN ATTEMPT at " + pos + " ===");
        if (spawnType != MobSpawnType.STRUCTURE && DenDenMushiSpawnConditions.isInCave(level, pos)) {
            System.out.println("REJECTED: In cave");
            return false;
        }
        System.out.println("\u2713 Not in cave");
        if (!DenDenMushiSpawnConditions.hasValidSpawnSpace(level, pos)) {
            System.out.println("REJECTED: Invalid spawn space");
            return false;
        }
        System.out.println("\u2713 Valid spawn space");
        System.out.println("\u2713\u2713\u2713 SPAWN APPROVED \u2713\u2713\u2713");
        return true;
    }

    private static boolean isOverworld(LevelAccessor level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_46472_() == Level.f_46428_;
        }
        try {
            if (level.m_6106_() != null) {
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to check dimension: " + e.getMessage());
        }
        return false;
    }

    private static boolean isInCave(ServerLevelAccessor level, BlockPos pos) {
        if (level.m_45527_(pos)) {
            return false;
        }
        int surfaceHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
        int depthBelowSurface = surfaceHeight - pos.m_123342_();
        return depthBelowSurface > 10;
    }

    private static boolean hasValidSpawnSpace(ServerLevelAccessor level, BlockPos pos) {
        boolean inWater = level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        if (inWater) {
            BlockPos below = pos.m_7495_();
            return level.m_8055_(below).m_280296_() && level.m_6425_(pos.m_7494_()).m_205070_(FluidTags.f_13131_);
        }
        BlockPos below = pos.m_7495_();
        if (!level.m_8055_(below).m_60643_((BlockGetter)level, below, EntityType.f_20510_)) {
            return false;
        }
        return level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_();
    }
}

