/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.eclipce.transpondersnails.item.DenDenMushiItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DenDenMushiItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation BODY_BASE_TEXTURE = new ResourceLocation("transpondersnails", "textures/item/den_den_mushi/snail/den_den_mushi_snail_body.png");
    private static final ResourceLocation BODY_DETAILS_TEXTURE = new ResourceLocation("transpondersnails", "textures/item/den_den_mushi/snail/den_den_mushi_snail_eyes.png");

    public DenDenMushiItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!(stack.m_41720_() instanceof DenDenMushiItem)) {
            return;
        }
        int shellColor = DenDenMushiItem.getShellColor(stack);
        DyeColor dyeColor = DyeColor.m_41053_((int)shellColor);
        ModelResourceLocation shellModelLocation = new ModelResourceLocation(new ResourceLocation("transpondersnails", "den_den_mushi_shell_" + dyeColor.m_41065_()), "inventory");
        BakedModel shellModel = Minecraft.m_91087_().m_91304_().m_119422_(shellModelLocation);
        if (shellModel != null) {
            Minecraft.m_91087_().m_91291_().m_115143_(stack, displayContext, false, poseStack, buffer, combinedLight, combinedOverlay, shellModel);
        }
        if (DenDenMushiItem.isCaptured(stack)) {
            this.renderTintedBody(stack, displayContext, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderTintedBody(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int bodyColor = DenDenMushiItem.getBodyColor(stack);
        float r = (float)(bodyColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(bodyColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(bodyColor & 0xFF) / 255.0f;
        VertexConsumer bodyConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)BODY_BASE_TEXTURE));
        VertexConsumer detailConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)BODY_DETAILS_TEXTURE));
    }
}

