/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.block.custom.TransponderSnailBlock;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.data.SnailNBTHandler;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.eclipce.transpondersnails.voice.server.CallSession;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class TransponderSnailItem
extends BlockItem {
    private static final String CALL_STATE_TAG = "call_state";
    private static final String ACTIVE_CALL_ID_TAG = "active_call_id";
    private static final String CALL_START_TIME_TAG = "call_start_time";
    private static final String OTHER_SNAIL_NUMBER_TAG = "other_snail_number";

    public TransponderSnailItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            int snailNumber = SnailNBTHandler.getSnailNumber(stack);
            if (snailNumber != -1) {
                int currentHandheld;
                TransponderCallManager callManager = TransponderSnails.getCallManager();
                if (callManager != null && (isSelected || player.m_21206_() == stack) && (currentHandheld = callManager.getPlayerHandheldSnail(player.m_20148_())) != snailNumber) {
                    callManager.registerHandheldSnail(snailNumber, player.m_20148_());
                }
                this.updateCallStateFromManager(stack, player);
                this.updateAudioActivityFlag(stack, snailNumber, callManager);
            }
        }
    }

    private void updateCallStateFromManager(ItemStack stack, ServerPlayer player) {
        String currentState;
        TransponderCallManager callManager = TransponderSnails.getCallManager();
        if (callManager == null) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        int snailNumber = SnailNBTHandler.getSnailNumber(stack);
        if (callManager.isSnailRinging(snailNumber)) {
            if (!nbt.m_128461_(CALL_STATE_TAG).equals("ringing")) {
                int callerNumber = callManager.getCallerSnailNumber(snailNumber);
                nbt.m_128359_(CALL_STATE_TAG, "ringing");
                nbt.m_128405_(OTHER_SNAIL_NUMBER_TAG, callerNumber);
                System.out.println("DEBUG: Updated snail #" + snailNumber + " to RINGING state");
            }
            return;
        }
        if (callManager.isSnailInCall(snailNumber)) {
            UUID callId = callManager.getPlayerCallId(player.m_20148_());
            if (callId != null) {
                CallSession session = null;
                for (CallSession s : callManager.getActiveCalls()) {
                    if (!s.getCallId().equals(callId)) continue;
                    session = s;
                    break;
                }
                if (session != null) {
                    String currentState2;
                    CallSession.CallState state = session.getState();
                    if (state == CallSession.CallState.CONNECTED) {
                        if (!nbt.m_128461_(CALL_STATE_TAG).equals("connected")) {
                            nbt.m_128359_(CALL_STATE_TAG, "connected");
                            nbt.m_128362_(ACTIVE_CALL_ID_TAG, callId);
                            nbt.m_128356_(CALL_START_TIME_TAG, System.currentTimeMillis());
                            System.out.println("DEBUG: Updated snail #" + snailNumber + " to CONNECTED state");
                        }
                    } else if (nbt.m_128441_(CALL_STATE_TAG) && !(currentState2 = nbt.m_128461_(CALL_STATE_TAG)).isEmpty() && !"idle".equals(currentState2)) {
                        System.out.println("DEBUG: Clearing snail #" + snailNumber + " call state (session is " + state + ", not CONNECTED)");
                        this.clearCallState(nbt);
                    }
                } else {
                    System.out.println("DEBUG: Session not found for snail #" + snailNumber + ", clearing state");
                    this.clearCallState(nbt);
                }
            } else {
                this.clearCallState(nbt);
            }
        } else if (nbt.m_128441_(CALL_STATE_TAG) && !(currentState = nbt.m_128461_(CALL_STATE_TAG)).isEmpty() && !"idle".equals(currentState)) {
            System.out.println("DEBUG: Snail #" + snailNumber + " not in call, clearing state");
            this.clearCallState(nbt);
        }
    }

    private void updateAudioActivityFlag(ItemStack stack, int snailNumber, TransponderCallManager callManager) {
        CompoundTag nbt = stack.m_41784_();
        if (callManager.isSnailInCall(snailNumber)) {
            boolean hasAudio = callManager.hasActiveAudio(snailNumber);
            if (hasAudio) {
                nbt.m_128379_("has_active_audio", true);
            } else {
                nbt.m_128473_("has_active_audio");
            }
        } else {
            nbt.m_128473_("has_active_audio");
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack heldStack = context.m_43722_();
        if (heldStack.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState clickedBlock = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (clickedBlock.m_60734_() instanceof TransponderSnailBlock) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int snailNumber = SnailNBTHandler.getSnailNumber(heldStack);
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (snailNumber != -1 && callManager != null && callManager.isSnailInCall(snailNumber)) {
                BlockPos placedPos;
                BlockEntity blockEntity;
                InteractionResult result = super.m_6225_(context);
                if (result == InteractionResult.SUCCESS && (blockEntity = level.m_7702_(placedPos = context.m_8083_().m_121945_(context.m_43719_()))) instanceof TransponderSnailBlockEntity) {
                    TransponderSnailBlockEntity snailBE = (TransponderSnailBlockEntity)blockEntity;
                    callManager.transitionHandheldToBlock(snailNumber, placedPos, snailBE);
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)"Call seamlessly transferred to placed snail").m_130940_(ChatFormatting.GREEN));
                }
                return result;
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        UUID snailUUID;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!this.shouldHandleInteraction(player, hand)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TransponderCallManager callManager = TransponderSnails.getCallManager();
        if (callManager == null) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"Voice chat system not available!").m_130940_(ChatFormatting.RED));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int snailNumber = SnailNBTHandler.getSnailNumber(stack);
        if (snailNumber == -1 && (snailUUID = SnailNBTHandler.getOrCreateSnailUUID(stack, serverPlayer.m_20148_())) != null && (snailNumber = SnailNBTHandler.getSnailNumber(stack)) != -1) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)("Your handheld snail has been assigned number #" + snailNumber)).m_130940_(ChatFormatting.GREEN));
        }
        if (snailNumber != -1) {
            callManager.registerHandheldSnail(snailNumber, serverPlayer.m_20148_());
        }
        boolean isCrouching = player.m_6144_();
        System.out.println("DEBUG: TransponderSnailItem.use() - Snail #" + snailNumber + ", Crouching: " + isCrouching);
        if (callManager.isSnailRinging(snailNumber)) {
            UUID callId = callManager.getRingingCallId(snailNumber);
            int callerNumber = callManager.getCallerSnailNumber(snailNumber);
            System.out.println("DEBUG: Snail is RINGING - CallID: " + (callId != null ? callId.toString().substring(0, 8) : "null") + ", Caller: #" + callerNumber);
            if (isCrouching) {
                System.out.println("DEBUG: Opening GUI while ringing (sneaking)");
                this.openDialingMenu(serverPlayer, stack);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            System.out.println("DEBUG: Attempting to answer call");
            if (callId != null && callManager.acceptCall(serverPlayer, callId)) {
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128359_(CALL_STATE_TAG, "connected");
                nbt.m_128356_(CALL_START_TIME_TAG, System.currentTimeMillis());
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"Call answered!").m_130940_(ChatFormatting.GREEN));
                System.out.println("DEBUG: Call answered successfully");
            } else {
                System.out.println("DEBUG: Failed to answer call");
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"Failed to answer call!").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (callManager.isSnailInCall(snailNumber)) {
            System.out.println("DEBUG: Snail is in ACTIVE CALL");
            if (isCrouching) {
                System.out.println("DEBUG: Opening GUI during call (sneaking)");
                this.openDialingMenu(serverPlayer, stack);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            System.out.println("DEBUG: Hanging up call");
            callManager.endCall(serverPlayer);
            this.clearCallState(stack.m_41784_());
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"Call ended.").m_130940_(ChatFormatting.YELLOW));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        System.out.println("DEBUG: Snail is IDLE - opening GUI");
        this.openDialingMenu(serverPlayer, stack);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void clearCallState(CompoundTag nbt) {
        nbt.m_128473_(CALL_STATE_TAG);
        nbt.m_128473_(ACTIVE_CALL_ID_TAG);
        nbt.m_128473_(OTHER_SNAIL_NUMBER_TAG);
        nbt.m_128473_(CALL_START_TIME_TAG);
    }

    private boolean shouldHandleInteraction(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return true;
        }
        ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
        return mainHandStack.m_41619_();
    }

    private void openDialingMenu(ServerPlayer player, ItemStack stack) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new TransponderSnailMenuProvider(stack), buf -> {
            buf.writeBoolean(true);
            buf.m_130055_(stack);
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String callState;
        super.m_7373_(stack, level, tooltip, flag);
        SnailNBTHandler.addSnailTooltip(stack, level, tooltip, flag);
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !(callState = nbt.m_128461_(CALL_STATE_TAG)).isEmpty() && !"idle".equals(callState)) {
            MutableComponent stateTooltip = null;
            switch (callState) {
                case "ringing": {
                    int callerNumber = nbt.m_128451_(OTHER_SNAIL_NUMBER_TAG);
                    stateTooltip = Component.m_237113_((String)("Incoming call from #" + callerNumber)).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC});
                    break;
                }
                case "connected": {
                    long duration = (System.currentTimeMillis() - nbt.m_128454_(CALL_START_TIME_TAG)) / 1000L;
                    stateTooltip = Component.m_237113_((String)("In call (" + this.formatDuration(duration) + ")")).m_130940_(ChatFormatting.GREEN);
                    break;
                }
                case "busy": {
                    stateTooltip = Component.m_237113_((String)"Line busy").m_130940_(ChatFormatting.RED);
                }
            }
            if (stateTooltip != null) {
                tooltip.add((Component)stateTooltip);
            }
        }
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)"Right-click: Open dialer").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.m_237113_((String)"Sneak + Right-click: GUI in call").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private String formatDuration(long seconds) {
        long minutes = seconds / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d", minutes, secs);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int snailNumber = SnailNBTHandler.getSnailNumber(item);
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (snailNumber != -1 && callManager != null) {
                callManager.unregisterHandheldSnail(snailNumber);
                if (callManager.isSnailInCall(snailNumber)) {
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)"Dropped snail - call continues").m_130940_(ChatFormatting.YELLOW));
                }
            }
        }
        return super.onDroppedByPlayer(item, player);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_(CALL_STATE_TAG)) {
            nbt.m_128359_(CALL_STATE_TAG, "idle");
        }
    }

    public static float getCallStateProperty(ItemStack stack) {
        String state;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return 0.0f;
        }
        switch (state = nbt.m_128461_(CALL_STATE_TAG)) {
            case "ringing": {
                return 1.0f;
            }
            case "connected": {
                return 2.0f;
            }
            case "busy": {
                return 3.0f;
            }
        }
        return 0.0f;
    }

    private static class TransponderSnailMenuProvider
    implements MenuProvider {
        private final ItemStack snailStack;

        public TransponderSnailMenuProvider(ItemStack snailStack) {
            this.snailStack = snailStack.m_41777_();
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"gui.transpondersnails.dialing");
        }

        public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
            return new DialingMenu(containerId, playerInventory, this.snailStack);
        }
    }
}

