/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class CallInitiationPacket {
    private final int targetSnailNumber;
    private final int callerSnailNumber;

    public CallInitiationPacket(int targetSnailNumber, int callerSnailNumber) {
        this.targetSnailNumber = targetSnailNumber;
        this.callerSnailNumber = callerSnailNumber;
    }

    public CallInitiationPacket(FriendlyByteBuf buf) {
        this.targetSnailNumber = buf.readInt();
        this.callerSnailNumber = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.targetSnailNumber);
        buf.writeInt(this.callerSnailNumber);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DialingMenu dialingMenu;
            int actualCallerNumber;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            System.out.println("CallInitiationPacket: Player " + player.m_7755_().getString() + " (snail #" + this.callerSnailNumber + ") attempting to call snail #" + this.targetSnailNumber);
            AbstractContainerMenu patt1706$temp = player.f_36096_;
            if (patt1706$temp instanceof DialingMenu && (actualCallerNumber = (dialingMenu = (DialingMenu)patt1706$temp).getOwnSnailNumber()) != this.callerSnailNumber) {
                player.m_213846_((Component)Component.m_237113_((String)"Snail number mismatch! Please reopen the menu.").m_130940_(ChatFormatting.RED));
                return;
            }
            if (this.targetSnailNumber == this.callerSnailNumber) {
                player.m_213846_((Component)Component.m_237113_((String)"You cannot call your own snail!").m_130940_(ChatFormatting.YELLOW));
                return;
            }
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (callManager == null) {
                player.m_213846_((Component)Component.m_237113_((String)"Voice chat system not available!").m_130940_(ChatFormatting.RED));
                return;
            }
            boolean success = callManager.initiateCallBySnailNumber(player, this.callerSnailNumber, this.targetSnailNumber);
            if (success) {
                AbstractContainerMenu patt3186$temp = player.f_36096_;
                if (patt3186$temp instanceof DialingMenu) {
                    DialingMenu dialingMenu2 = (DialingMenu)patt3186$temp;
                    if (dialingMenu2.getBlockEntity() != null) {
                        dialingMenu2.getBlockEntity().clearDialedNumber();
                    } else {
                        dialingMenu2.clearDialedNumber();
                    }
                }
                player.m_213846_((Component)Component.m_237113_((String)("Calling snail #" + this.targetSnailNumber + "...")).m_130940_(ChatFormatting.GREEN));
            }
        });
        context.setPacketHandled(true);
    }

    public int getTargetSnailNumber() {
        return this.targetSnailNumber;
    }

    public int getCallerSnailNumber() {
        return this.callerSnailNumber;
    }
}

