/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CallStateSyncPacket {
    private final CallState callState;
    private final UUID callId;
    private final int otherSnailNumber;
    private final String statusMessage;

    public CallStateSyncPacket(CallState callState, @Nullable UUID callId, int otherSnailNumber, String statusMessage) {
        this.callState = callState;
        this.callId = callId;
        this.otherSnailNumber = otherSnailNumber;
        this.statusMessage = statusMessage != null ? statusMessage : "";
    }

    public CallStateSyncPacket(FriendlyByteBuf buf) {
        this.callState = (CallState)buf.m_130066_(CallState.class);
        boolean hasCallId = buf.readBoolean();
        this.callId = hasCallId ? buf.m_130259_() : null;
        this.otherSnailNumber = buf.readInt();
        this.statusMessage = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.callState);
        buf.writeBoolean(this.callId != null);
        if (this.callId != null) {
            buf.m_130077_(this.callId);
        }
        buf.writeInt(this.otherSnailNumber);
        buf.m_130070_(this.statusMessage);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(true);
            return;
        }
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                AbstractContainerMenu patt2625$temp;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && (patt2625$temp = mc.f_91074_.f_36096_) instanceof DialingMenu) {
                    DialingMenu menu = (DialingMenu)patt2625$temp;
                    menu.updateCallState(this.callState, this.callId, this.otherSnailNumber, this.statusMessage);
                    System.out.println("[CALL-STATE-SYNC] Updated call state to: " + this.callState);
                }
            }
            catch (Exception e) {
                System.err.println("[CALL-STATE-SYNC] ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }));
        context.setPacketHandled(true);
    }

    public CallState getCallState() {
        return this.callState;
    }

    @Nullable
    public UUID getCallId() {
        return this.callId;
    }

    public int getOtherSnailNumber() {
        return this.otherSnailNumber;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public static enum CallState {
        IDLE,
        DIALING,
        RINGING_OUT,
        RINGING_IN,
        CONNECTED,
        BUSY,
        DISCONNECTED;

    }
}

