/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class DialedNumberSyncPacket {
    private final String dialedNumber;

    public DialedNumberSyncPacket(String dialedNumber) {
        this.dialedNumber = dialedNumber != null ? dialedNumber : "";
    }

    public DialedNumberSyncPacket(FriendlyByteBuf buf) {
        this.dialedNumber = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dialedNumber);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            context.setPacketHandled(true);
            return;
        }
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                AbstractContainerMenu patt1509$temp;
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && (patt1509$temp = mc.f_91074_.f_36096_) instanceof DialingMenu) {
                    DialingMenu menu = (DialingMenu)patt1509$temp;
                    menu.setClientDialedNumber(this.dialedNumber);
                    System.out.println("[DIALED-NUMBER-SYNC] Synced dialed number: '" + this.dialedNumber + "'");
                }
            }
            catch (Exception e) {
                System.err.println("[DIALED-NUMBER-SYNC] ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }));
        context.setPacketHandled(true);
    }

    public String getDialedNumber() {
        return this.dialedNumber;
    }
}

