/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.network.packets;

import java.util.function.Supplier;
import net.eclipce.transpondersnails.screen.DialingMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SnailNumberSyncPacket {
    private final int snailNumber;

    public SnailNumberSyncPacket(int snailNumber) {
        this.snailNumber = snailNumber;
        System.out.println("[SNAIL-SYNC] Packet created with number: " + snailNumber);
    }

    public SnailNumberSyncPacket(FriendlyByteBuf buf) {
        this.snailNumber = buf.readInt();
        System.out.println("[SNAIL-SYNC] Packet decoded with number: " + this.snailNumber);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.snailNumber);
        System.out.println("[SNAIL-SYNC] Packet encoded with number: " + this.snailNumber);
    }

    public int getSnailNumber() {
        return this.snailNumber;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (!context.getDirection().getReceptionSide().isClient()) {
            System.err.println("[SNAIL-SYNC] ERROR: Packet received on wrong side!");
            context.setPacketHandled(true);
            return;
        }
        context.enqueueWork(() -> {
            System.out.println("[SNAIL-SYNC] Handling packet on client side for number: " + this.snailNumber);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                try {
                    AbstractContainerMenu patt2194$temp;
                    System.out.println("[SNAIL-SYNC] Executing client-side handler...");
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc.f_91074_ != null && (patt2194$temp = mc.f_91074_.f_36096_) instanceof DialingMenu) {
                        DialingMenu menu = (DialingMenu)patt2194$temp;
                        System.out.println("[SNAIL-SYNC] Setting snail number to: " + this.snailNumber);
                        menu.setOwnSnailNumber(this.snailNumber);
                        System.out.println("[SNAIL-SYNC] Successfully synced snail number!");
                    } else {
                        System.err.println("[SNAIL-SYNC] WARNING: Player doesn't have DialingMenu open");
                    }
                }
                catch (Exception e) {
                    System.err.println("[SNAIL-SYNC] ERROR handling packet: " + e.getMessage());
                    e.printStackTrace();
                }
            });
        });
        context.setPacketHandled(true);
    }
}

