/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.screen;

import java.util.UUID;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.data.SnailNBTHandler;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.eclipce.transpondersnails.network.ModPackets;
import net.eclipce.transpondersnails.network.packets.CallInitiationPacket;
import net.eclipce.transpondersnails.network.packets.CallResponsePacket;
import net.eclipce.transpondersnails.network.packets.CallStateSyncPacket;
import net.eclipce.transpondersnails.network.packets.SnailNumberRequestPacket;
import net.eclipce.transpondersnails.network.packets.SnailNumberSyncPacket;
import net.eclipce.transpondersnails.screen.ModMenuTypes;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DialingMenu
extends AbstractContainerMenu {
    private final TransponderSnailBlockEntity blockEntity;
    private final ItemStack snailStack;
    private final Player player;
    private String clientDialedNumber = "";
    private int ownSnailNumber = -1;
    private boolean numberAssigned = false;
    private boolean syncRequested = false;
    private CallStateSyncPacket.CallState currentCallState = CallStateSyncPacket.CallState.IDLE;
    private UUID activeCallId = null;
    private int otherSnailNumber = -1;
    private String callStatusMessage = "";

    public DialingMenu(int containerId, Inventory playerInventory, TransponderSnailBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.DIALING_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.snailStack = ItemStack.f_41583_;
        this.player = playerInventory.f_35978_;
        if (!this.player.m_9236_().f_46443_) {
            this.initializeSnailNumber();
            this.checkExistingCallState();
        } else {
            this.requestSnailNumberSync();
        }
    }

    public DialingMenu(int containerId, Inventory playerInventory, ItemStack snailStack) {
        super((MenuType)ModMenuTypes.DIALING_MENU.get(), containerId);
        this.blockEntity = null;
        this.snailStack = snailStack.m_41777_();
        this.player = playerInventory.f_35978_;
        if (!this.player.m_9236_().f_46443_) {
            this.initializeSnailNumber();
            this.checkExistingCallState();
        } else {
            this.requestSnailNumberSync();
        }
    }

    public DialingMenu(int containerId, Inventory playerInventory) {
        super((MenuType)ModMenuTypes.DIALING_MENU.get(), containerId);
        this.blockEntity = null;
        this.snailStack = ItemStack.f_41583_;
        this.player = playerInventory.f_35978_;
        if (this.player.m_9236_().f_46443_) {
            this.requestSnailNumberSync();
        }
    }

    public static DialingMenu createFromNetwork(int containerId, Inventory playerInventory, FriendlyByteBuf buf) {
        if (buf == null) {
            return new DialingMenu(containerId, playerInventory);
        }
        boolean isHandheld = buf.readBoolean();
        ItemStack snailStack = buf.m_130267_();
        if (isHandheld) {
            return new DialingMenu(containerId, playerInventory, snailStack);
        }
        return new DialingMenu(containerId, playerInventory);
    }

    private void checkExistingCallState() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        TransponderCallManager callManager = TransponderSnails.getCallManager();
        if (callManager == null) {
            return;
        }
        if (callManager.isInCall(this.player.m_20148_())) {
            UUID callId = callManager.getPlayerCallId(this.player.m_20148_());
            if (callId != null) {
                this.updateCallStateAndSync(CallStateSyncPacket.CallState.CONNECTED, callId, -1, "In call");
            }
        } else if (this.blockEntity != null && this.blockEntity.isRinging()) {
            UUID callId = this.blockEntity.getActiveCallId();
            this.updateCallStateAndSync(CallStateSyncPacket.CallState.RINGING_IN, callId, -1, "Incoming call");
        }
    }

    private void requestSnailNumberSync() {
        if (!this.player.m_9236_().f_46443_ || this.syncRequested) {
            return;
        }
        this.syncRequested = true;
        ModPackets.sendToServer(new SnailNumberRequestPacket());
    }

    private void initializeSnailNumber() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        ItemStack targetStack = this.getTargetSnailStack();
        if (targetStack.m_41619_() && this.blockEntity == null) {
            System.err.println("DialingMenu: No valid snail stack or block entity found for initialization");
            return;
        }
        if (this.blockEntity != null) {
            if (!this.blockEntity.hasAssignedNumber()) {
                this.blockEntity.ensureSnailNumberAssigned(this.player);
            }
            this.ownSnailNumber = this.blockEntity.getSnailNumber();
            this.numberAssigned = this.ownSnailNumber != -1;
        } else if (!targetStack.m_41619_()) {
            int existingNumber = SnailNBTHandler.getSnailNumber(targetStack);
            if (existingNumber != -1) {
                this.ownSnailNumber = existingNumber;
                this.numberAssigned = true;
                System.out.println("DialingMenu: Handheld snail already has number #" + existingNumber);
            } else {
                UUID snailUUID = SnailNBTHandler.getOrCreateSnailUUID(targetStack, this.player.m_20148_());
                if (snailUUID != null) {
                    this.ownSnailNumber = SnailNBTHandler.getSnailNumber(targetStack);
                    this.numberAssigned = true;
                    System.out.println("DialingMenu: Assigned new number #" + this.ownSnailNumber + " to handheld snail");
                    Player player = this.player;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        MutableComponent message = Component.m_237113_((String)("Your Transponder Snail has been assigned number #" + this.ownSnailNumber)).m_130940_(ChatFormatting.GREEN);
                        serverPlayer.m_213846_((Component)message);
                    }
                } else {
                    System.err.println("DialingMenu: Failed to assign snail number to handheld snail");
                    this.ownSnailNumber = -1;
                    this.numberAssigned = false;
                }
            }
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.ownSnailNumber != -1) {
                System.out.println("DialingMenu: Sending sync packet to client - number #" + this.ownSnailNumber);
                ModPackets.sendToPlayer(new SnailNumberSyncPacket(this.ownSnailNumber), serverPlayer);
            }
        }
    }

    public void m_38946_() {
        Player player;
        super.m_38946_();
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.validateAndSyncSnailNumber(serverPlayer);
            this.updateCallStateFromManager(serverPlayer);
        }
    }

    private void updateCallStateFromManager(ServerPlayer serverPlayer) {
        TransponderCallManager callManager = TransponderSnails.getCallManager();
        if (callManager == null) {
            return;
        }
        boolean playerInCall = callManager.isInCall(serverPlayer.m_20148_());
        UUID callId = callManager.getPlayerCallId(serverPlayer.m_20148_());
        CallStateSyncPacket.CallState newState = CallStateSyncPacket.CallState.IDLE;
        int otherNumber = -1;
        String statusMsg = "";
        if (playerInCall && callId != null) {
            newState = CallStateSyncPacket.CallState.CONNECTED;
            statusMsg = "Connected";
        } else if (this.blockEntity != null && this.blockEntity.isRinging()) {
            newState = CallStateSyncPacket.CallState.RINGING_IN;
            callId = this.blockEntity.getActiveCallId();
            statusMsg = "Incoming call";
        }
        if (newState != this.currentCallState || callId != null && !callId.equals(this.activeCallId) || otherNumber != this.otherSnailNumber) {
            this.updateCallStateAndSync(newState, callId, otherNumber, statusMsg);
        }
    }

    private void updateCallStateAndSync(CallStateSyncPacket.CallState newState, UUID callId, int otherNumber, String statusMsg) {
        Player player;
        this.currentCallState = newState;
        this.activeCallId = callId;
        this.otherSnailNumber = otherNumber;
        this.callStatusMessage = statusMsg;
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModPackets.sendToPlayer(new CallStateSyncPacket(newState, callId, otherNumber, statusMsg), serverPlayer);
        }
    }

    public void updateCallState(CallStateSyncPacket.CallState callState, UUID callId, int otherSnailNumber, String statusMessage) {
        this.currentCallState = callState;
        this.activeCallId = callId;
        this.otherSnailNumber = otherSnailNumber;
        this.callStatusMessage = statusMessage;
    }

    private void validateAndSyncSnailNumber(ServerPlayer serverPlayer) {
        UUID snailUUID;
        SnailNumberRegistry registry;
        if (this.blockEntity != null) {
            this.blockEntity.ensureSnailNumberAssigned((Player)serverPlayer);
            int blockEntityNumber = this.blockEntity.getSnailNumber();
            if (blockEntityNumber != this.ownSnailNumber) {
                this.ownSnailNumber = blockEntityNumber;
                boolean bl = this.numberAssigned = blockEntityNumber != -1;
                if (blockEntityNumber != -1) {
                    ModPackets.sendToPlayer(new SnailNumberSyncPacket(blockEntityNumber), serverPlayer);
                }
            }
        } else if (!this.snailStack.m_41619_() && this.ownSnailNumber != -1 && (registry = SnailNumberRegistry.getInstance()) != null && (snailUUID = SnailNBTHandler.getSnailUUID(this.snailStack)) != null) {
            UUID registryUUID = registry.getSnailByNumber(this.ownSnailNumber);
            if (registryUUID == null || !registryUUID.equals(snailUUID)) {
                System.out.println("DialingMenu: Handheld snail number #" + this.ownSnailNumber + " no longer valid, reassigning");
                this.initializeSnailNumber();
            } else {
                ModPackets.sendToPlayer(new SnailNumberSyncPacket(this.ownSnailNumber), serverPlayer);
            }
        }
    }

    private ItemStack getTargetSnailStack() {
        if (this.blockEntity != null) {
            return this.blockEntity.getSnailItemStack();
        }
        if (!this.snailStack.m_41619_()) {
            return this.snailStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity == null && this.snailStack.m_41619_()) {
            return true;
        }
        if (this.blockEntity != null) {
            return player.m_20275_((double)this.blockEntity.m_58899_().m_123341_() + 0.5, (double)this.blockEntity.m_58899_().m_123342_() + 0.5, (double)this.blockEntity.m_58899_().m_123343_() + 0.5) <= 64.0;
        }
        return true;
    }

    public void initiateCall() {
        int dialedNumber;
        String targetNumber = this.getDialedNumber();
        if (targetNumber == null || targetNumber.isEmpty()) {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"Please dial a number first!").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        try {
            dialedNumber = Integer.parseInt(targetNumber);
        }
        catch (NumberFormatException e) {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"Invalid number format!").m_130940_(ChatFormatting.RED));
            }
            return;
        }
        if (dialedNumber == this.ownSnailNumber) {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)"You cannot call your own snail!").m_130940_(ChatFormatting.YELLOW));
            }
            return;
        }
        if (!this.player.m_9236_().f_46443_) {
            this.initiateCallServerSide(dialedNumber);
        } else {
            ModPackets.sendToServer(new CallInitiationPacket(dialedNumber, this.ownSnailNumber));
        }
    }

    private void initiateCallServerSide(int targetNumber) {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TransponderCallManager callManager = TransponderSnails.getCallManager();
        if (callManager == null) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"Voice chat system not available!").m_130940_(ChatFormatting.RED));
            return;
        }
        this.updateCallStateAndSync(CallStateSyncPacket.CallState.DIALING, null, targetNumber, "Dialing...");
        boolean success = callManager.initiateCallBySnailNumber(serverPlayer, this.ownSnailNumber, targetNumber);
        if (success) {
            this.clearDialedNumber();
            serverPlayer.m_213846_((Component)Component.m_237113_((String)("Calling snail #" + targetNumber + "...")).m_130940_(ChatFormatting.GREEN));
        } else {
            this.updateCallStateAndSync(CallStateSyncPacket.CallState.IDLE, null, -1, "");
        }
    }

    public void acceptCall() {
        if (this.currentCallState != CallStateSyncPacket.CallState.RINGING_IN || this.activeCallId == null) {
            return;
        }
        if (!this.player.m_9236_().f_46443_) {
            Player player;
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (callManager != null && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                callManager.acceptCall(serverPlayer, this.activeCallId);
            }
        } else {
            ModPackets.sendToServer(new CallResponsePacket(CallResponsePacket.Response.ACCEPT, this.activeCallId));
        }
    }

    public void rejectCall() {
        if (this.currentCallState != CallStateSyncPacket.CallState.RINGING_IN || this.activeCallId == null) {
            return;
        }
        if (!this.player.m_9236_().f_46443_) {
            Player player;
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (callManager != null && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                callManager.rejectCall(serverPlayer, this.activeCallId);
            }
        } else {
            ModPackets.sendToServer(new CallResponsePacket(CallResponsePacket.Response.REJECT, this.activeCallId));
        }
    }

    public void hangUpCall() {
        if (this.currentCallState != CallStateSyncPacket.CallState.CONNECTED || this.activeCallId == null) {
            return;
        }
        if (!this.player.m_9236_().f_46443_) {
            Player player;
            TransponderCallManager callManager = TransponderSnails.getCallManager();
            if (callManager != null && (player = this.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                callManager.endCall(serverPlayer);
            }
        } else {
            ModPackets.sendToServer(new CallResponsePacket(CallResponsePacket.Response.HANG_UP, this.activeCallId));
        }
    }

    public void onCallInitiated() {
        System.out.println("DialingMenu: Call initiated");
    }

    public void onCallEnded() {
        this.updateCallStateAndSync(CallStateSyncPacket.CallState.IDLE, null, -1, "");
        if (this.blockEntity != null) {
            this.blockEntity.clearDialedNumber();
        } else {
            this.clearDialedNumber();
        }
        System.out.println("DialingMenu: Call ended");
    }

    public void onNumberCleared() {
        System.out.println("DialingMenu: Number cleared");
    }

    public CallStateSyncPacket.CallState getCurrentCallState() {
        return this.currentCallState;
    }

    public UUID getActiveCallId() {
        return this.activeCallId;
    }

    public int getOtherSnailNumber() {
        return this.otherSnailNumber;
    }

    public String getCallStatusMessage() {
        return this.callStatusMessage;
    }

    public boolean canInitiateCall() {
        return this.currentCallState == CallStateSyncPacket.CallState.IDLE && this.ownSnailNumber != -1 && !this.getDialedNumber().isEmpty();
    }

    public boolean canAcceptCall() {
        return this.currentCallState == CallStateSyncPacket.CallState.RINGING_IN;
    }

    public boolean canHangUp() {
        return this.currentCallState == CallStateSyncPacket.CallState.CONNECTED;
    }

    public String getDialedNumber() {
        if (this.blockEntity != null) {
            return this.blockEntity.getDialedNumber();
        }
        return this.clientDialedNumber;
    }

    public void dialDigit(int digit) {
        if (this.blockEntity != null) {
            this.blockEntity.dialDigit(digit);
        } else if (this.player.m_9236_().f_46443_) {
            if (this.clientDialedNumber.length() < 4) {
                this.clientDialedNumber = this.clientDialedNumber + digit;
            }
        } else if (this.clientDialedNumber.length() < 4) {
            this.clientDialedNumber = this.clientDialedNumber + digit;
        }
    }

    public void clearDialedNumber() {
        if (this.blockEntity != null) {
            this.blockEntity.clearDialedNumber();
        } else {
            this.clientDialedNumber = "";
        }
    }

    public void clearNumber() {
        this.clearDialedNumber();
    }

    public boolean isDialedNumberValid() {
        String dialed = this.getDialedNumber();
        if (dialed.length() != 4) {
            return false;
        }
        try {
            int number = Integer.parseInt(dialed);
            return number >= 1000 && number <= 9999;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public TransponderSnailBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ItemStack getSnailStack() {
        return this.snailStack;
    }

    public int getOwnSnailNumber() {
        return this.ownSnailNumber;
    }

    public boolean isNumberAssigned() {
        return this.numberAssigned;
    }

    public void setOwnSnailNumber(int number) {
        System.out.println("DialingMenu: setOwnSnailNumber called with number #" + number);
        this.ownSnailNumber = number;
        this.numberAssigned = number != -1;
    }

    public void setClientDialedNumber(String number) {
        if (this.player.m_9236_().f_46443_) {
            this.clientDialedNumber = number != null ? number : "";
            System.out.println("DialingMenu: setClientDialedNumber called with: '" + this.clientDialedNumber + "'");
        }
    }

    private ServerPlayer findNearbyPlayer() {
        Level level;
        if (this.blockEntity == null || !((level = this.blockEntity.m_58904_()) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = this.blockEntity.m_58899_();
        return serverLevel.m_6907_().stream().filter(player -> player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 9.0).findFirst().orElse(null);
    }
}

