/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.voice;

import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.eclipce.transpondersnails.TransponderSnails;
import net.eclipce.transpondersnails.voice.server.SnailAudioRelay;
import net.eclipce.transpondersnails.voice.server.TransponderCallManager;

@ForgeVoicechatPlugin
public class TransponderSnailsPlugin
implements VoicechatPlugin {
    private SnailAudioRelay audioRelay;
    private ScheduledExecutorService scheduler;

    public String getPluginId() {
        return "transpondersnails";
    }

    public void initialize(VoicechatApi api) {
        super.initialize(api);
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        VoicechatServerApi api = event.getVoicechat();
        VolumeCategory snailVolume = api.volumeCategoryBuilder().setId("snail_volume").setName("Snails").setDescription("Volume of all Snails").setIcon(this.getIcon()).build();
        api.registerVolumeCategory(snailVolume);
        TransponderCallManager callManager = new TransponderCallManager(api);
        this.audioRelay = new SnailAudioRelay(api, callManager);
        callManager.setAudioRelay(this.audioRelay);
        TransponderSnails.setCallManager(callManager);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> {}, 5L, 5L, TimeUnit.SECONDS);
        TransponderSnails.LOGGER.info("Transponder Snails voice chat integration initialized with audio relay!");
    }

    private void onMicrophonePacket(MicrophonePacketEvent event) {
        if (this.audioRelay != null) {
            try {
                this.audioRelay.onMicrophonePacket(event);
            }
            catch (Exception e) {
                System.err.println("TransponderSnailsPlugin: Error in microphone packet handler: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Nullable
    private int[][] getIcon() {
        try {
            InputStream iconStream = this.getClass().getResourceAsStream("/assets/transpondersnails/textures/icons/snail_volume_icon.png");
            if (iconStream == null) {
                System.err.println("Could not find snail_call_icon.png at /assets/transpondersnails/textures/icons/");
                return null;
            }
            BufferedImage bufferedImage = ImageIO.read(iconStream);
            iconStream.close();
            if (bufferedImage.getWidth() != 16 || bufferedImage.getHeight() != 16) {
                System.err.println("Icon must be 16x16 pixels! Found: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                return null;
            }
            int[][] image = new int[16][16];
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    image[x][y] = bufferedImage.getRGB(x, y);
                }
            }
            System.out.println("Successfully loaded Snail Volume icon");
            return image;
        }
        catch (IOException e) {
            System.err.println("Error loading Snail Volume icon: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void cleanup() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        System.out.println("TransponderSnailsPlugin: Cleanup completed");
    }
}

