/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.voice.server;

import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public class CallSession {
    private final UUID callId;
    private final long creationTime;
    private CallState state;
    private final Map<UUID, Integer> participantSnailNumbers = new ConcurrentHashMap<UUID, Integer>();
    private final Map<Integer, CallParticipant> snailParticipants = new ConcurrentHashMap<Integer, CallParticipant>();
    private AudioChannel primaryChannel;
    private final Map<BlockPos, AudioChannel> proximityChannels = new ConcurrentHashMap<BlockPos, AudioChannel>();
    private final Map<UUID, AudioChannel> handheldChannels = new ConcurrentHashMap<UUID, AudioChannel>();
    private final Set<UUID> proximityListeners = ConcurrentHashMap.newKeySet();
    private long lastActivityTime;
    private static final long INACTIVITY_TIMEOUT = 600000L;

    public CallSession(UUID callId, int initiatorSnailNumber, CallParticipant initiator) {
        this.callId = callId;
        this.creationTime = System.currentTimeMillis();
        this.state = CallState.INITIATING;
        this.lastActivityTime = this.creationTime;
        this.addParticipant(initiatorSnailNumber, initiator);
    }

    public void addParticipant(int snailNumber, CallParticipant participant) {
        this.snailParticipants.put(snailNumber, participant);
        if (participant.hasActivePlayer()) {
            this.participantSnailNumbers.put(participant.getPlayerId(), snailNumber);
        }
        this.updateActivity();
    }

    public void removeParticipant(int snailNumber) {
        CallParticipant participant = this.snailParticipants.remove(snailNumber);
        if (participant != null && participant.hasActivePlayer()) {
            this.participantSnailNumbers.remove(participant.getPlayerId());
        }
        this.updateActivity();
    }

    public void removeParticipantByPlayer(UUID playerId) {
        Integer snailNumber = this.participantSnailNumbers.remove(playerId);
        if (snailNumber != null) {
            this.snailParticipants.remove(snailNumber);
        }
        this.updateActivity();
    }

    @Nullable
    public CallParticipant getParticipant(int snailNumber) {
        return this.snailParticipants.get(snailNumber);
    }

    @Nullable
    public CallParticipant getParticipantByPlayer(UUID playerId) {
        Integer snailNumber = this.participantSnailNumbers.get(playerId);
        return snailNumber != null ? this.snailParticipants.get(snailNumber) : null;
    }

    public boolean isParticipant(UUID playerId) {
        return this.participantSnailNumbers.containsKey(playerId);
    }

    public boolean isParticipant(int snailNumber) {
        return this.snailParticipants.containsKey(snailNumber);
    }

    public Set<Integer> getParticipantSnailNumbers() {
        return new HashSet<Integer>(this.snailParticipants.keySet());
    }

    public Set<UUID> getActivePlayerParticipants() {
        return new HashSet<UUID>(this.participantSnailNumbers.keySet());
    }

    public Collection<CallParticipant> getAllParticipants() {
        return new ArrayList<CallParticipant>(this.snailParticipants.values());
    }

    public int getParticipantCount() {
        return this.snailParticipants.size();
    }

    public void addProximityListener(UUID playerId) {
        if (this.proximityListeners.add(playerId)) {
            this.updateActivity();
        }
    }

    public void removeProximityListener(UUID playerId) {
        this.proximityListeners.remove(playerId);
    }

    public boolean isProximityListener(UUID playerId) {
        return this.proximityListeners.contains(playerId);
    }

    public Set<UUID> getProximityListeners() {
        return new HashSet<UUID>(this.proximityListeners);
    }

    public Set<UUID> getAllAudioParticipants() {
        HashSet<UUID> allParticipants = new HashSet<UUID>(this.participantSnailNumbers.keySet());
        allParticipants.addAll(this.proximityListeners);
        return allParticipants;
    }

    public void setPrimaryChannel(AudioChannel channel) {
        this.primaryChannel = channel;
    }

    @Nullable
    public AudioChannel getPrimaryChannel() {
        return this.primaryChannel;
    }

    public void addProximityChannel(BlockPos position, AudioChannel channel) {
        this.proximityChannels.put(position, channel);
    }

    public void removeProximityChannel(BlockPos position) {
        this.proximityChannels.remove(position);
    }

    @Nullable
    public AudioChannel getProximityChannel(BlockPos position) {
        return this.proximityChannels.get(position);
    }

    public Map<BlockPos, AudioChannel> getProximityChannels() {
        return new HashMap<BlockPos, AudioChannel>(this.proximityChannels);
    }

    public void addHandheldChannel(UUID playerId, AudioChannel channel) {
        this.handheldChannels.put(playerId, channel);
        System.out.println("CallSession: Added handheld channel for player " + playerId.toString().substring(0, 8));
    }

    public void removeHandheldChannel(UUID playerId) {
        this.handheldChannels.remove(playerId);
        System.out.println("CallSession: Removed handheld channel for player " + playerId.toString().substring(0, 8));
    }

    @Nullable
    public AudioChannel getHandheldChannel(UUID playerId) {
        return this.handheldChannels.get(playerId);
    }

    public Map<UUID, AudioChannel> getHandheldChannels() {
        return new HashMap<UUID, AudioChannel>(this.handheldChannels);
    }

    public boolean hasHandheldChannel(UUID playerId) {
        return this.handheldChannels.containsKey(playerId);
    }

    public Collection<AudioChannel> getAllAudioChannels() {
        ArrayList<AudioChannel> allChannels = new ArrayList<AudioChannel>();
        allChannels.addAll(this.proximityChannels.values());
        allChannels.addAll(this.handheldChannels.values());
        if (this.primaryChannel != null) {
            allChannels.add(this.primaryChannel);
        }
        return allChannels;
    }

    public void setState(CallState newState) {
        this.state = newState;
        this.updateActivity();
    }

    public CallState getState() {
        return this.state;
    }

    public void updateActivity() {
        this.lastActivityTime = System.currentTimeMillis();
    }

    public boolean hasTimedOut() {
        return System.currentTimeMillis() - this.lastActivityTime > 600000L;
    }

    public long getTimeSinceLastActivity() {
        return System.currentTimeMillis() - this.lastActivityTime;
    }

    public boolean shouldAutoEnd() {
        return this.hasTimedOut() || this.getParticipantCount() == 0;
    }

    public Set<BlockPos> getInvolvedBlockPositions() {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (CallParticipant participant : this.snailParticipants.values()) {
            if (!participant.isBlock() || participant.getBlockPosition() == null) continue;
            positions.add(participant.getBlockPosition());
        }
        return positions;
    }

    public Set<UUID> getHandheldParticipantIds() {
        HashSet<UUID> handheldPlayers = new HashSet<UUID>();
        for (CallParticipant participant : this.snailParticipants.values()) {
            if (!participant.isHandheld() || !participant.hasActivePlayer()) continue;
            handheldPlayers.add(participant.getPlayerId());
        }
        return handheldPlayers;
    }

    public boolean involvesBlockPosition(BlockPos position) {
        return this.snailParticipants.values().stream().anyMatch(p -> p.isBlock() && position.equals((Object)p.getBlockPosition()));
    }

    public long getCallDuration() {
        return System.currentTimeMillis() - this.creationTime;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CallSession{id=%s, state=%s, duration=%ds, participants=%d, proximity=%d}", new Object[]{this.callId.toString().substring(0, 8), this.state, this.getCallDuration() / 1000L, this.getParticipantCount(), this.proximityListeners.size()}));
        sb.append("\n  Participants:");
        for (CallParticipant participant : this.snailParticipants.values()) {
            sb.append("\n    ").append(participant.toString());
        }
        if (!this.proximityListeners.isEmpty()) {
            sb.append("\n  Proximity Listeners: ").append(this.proximityListeners.size());
        }
        if (!this.handheldChannels.isEmpty()) {
            sb.append("\n  Handheld Channels: ").append(this.handheldChannels.size());
        }
        return sb.toString();
    }

    public UUID getCallId() {
        return this.callId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public String toString() {
        return String.format("CallSession{id=%s, state=%s, participants=%d, handheld=%d}", new Object[]{this.callId.toString().substring(0, 8), this.state, this.getParticipantCount(), this.handheldChannels.size()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallSession that = (CallSession)o;
        return Objects.equals(this.callId, that.callId);
    }

    public int hashCode() {
        return Objects.hash(this.callId);
    }

    public static enum CallState {
        INITIATING,
        RINGING,
        CONNECTED,
        ENDING,
        ENDED;

    }

    public static class CallParticipant {
        private final UUID playerId;
        private final int snailNumber;
        private final ParticipantType type;
        private final BlockPos blockPosition;

        public CallParticipant(@Nullable UUID playerId, int snailNumber, ParticipantType type, @Nullable BlockPos blockPosition) {
            this.playerId = playerId;
            this.snailNumber = snailNumber;
            this.type = type;
            this.blockPosition = blockPosition;
        }

        public static CallParticipant handheld(UUID playerId, int snailNumber) {
            return new CallParticipant(playerId, snailNumber, ParticipantType.HANDHELD, null);
        }

        public static CallParticipant block(int snailNumber, BlockPos position) {
            return new CallParticipant(null, snailNumber, ParticipantType.BLOCK, position);
        }

        public static CallParticipant blockWithPlayer(UUID playerId, int snailNumber, BlockPos position) {
            return new CallParticipant(playerId, snailNumber, ParticipantType.BLOCK, position);
        }

        @Nullable
        public UUID getPlayerId() {
            return this.playerId;
        }

        public int getSnailNumber() {
            return this.snailNumber;
        }

        public ParticipantType getType() {
            return this.type;
        }

        @Nullable
        public BlockPos getBlockPosition() {
            return this.blockPosition;
        }

        public boolean isHandheld() {
            return this.type == ParticipantType.HANDHELD;
        }

        public boolean isBlock() {
            return this.type == ParticipantType.BLOCK;
        }

        public boolean hasActivePlayer() {
            return this.playerId != null;
        }

        public String toString() {
            return String.format("CallParticipant{snail=#%d, type=%s, player=%s, pos=%s}", new Object[]{this.snailNumber, this.type, this.playerId != null ? this.playerId.toString().substring(0, 8) : "none", this.blockPosition});
        }

        public static enum ParticipantType {
            HANDHELD,
            BLOCK;

        }
    }
}

