/*
 * Decompiled with CFR 0.152.
 */
package net.eclipce.transpondersnails.voice.server;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.eclipce.transpondersnails.block.custom.TransponderSnailBlock;
import net.eclipce.transpondersnails.block.entity.TransponderSnailBlockEntity;
import net.eclipce.transpondersnails.data.SnailNBTHandler;
import net.eclipce.transpondersnails.data.SnailNumberRegistry;
import net.eclipce.transpondersnails.item.TransponderSnailItem;
import net.eclipce.transpondersnails.voice.VoiceChatConstants;
import net.eclipce.transpondersnails.voice.server.CallSession;
import net.eclipce.transpondersnails.voice.server.CallSoundManager;
import net.eclipce.transpondersnails.voice.server.SnailAudioRelay;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TransponderCallManager {
    private final VoicechatServerApi voiceChatApi;
    private final CallSoundManager soundManager;
    private final ScheduledExecutorService scheduler;
    private final Map<UUID, CallSession> activeCalls = new ConcurrentHashMap<UUID, CallSession>();
    private final Map<UUID, UUID> playerToCallId = new ConcurrentHashMap<UUID, UUID>();
    private final Map<Integer, UUID> snailToCallId = new ConcurrentHashMap<Integer, UUID>();
    private final Map<Integer, TransponderSnailBlockEntity> registeredSnailBlocks = new ConcurrentHashMap<Integer, TransponderSnailBlockEntity>();
    private final Map<Integer, UUID> handheldSnailOwners = new ConcurrentHashMap<Integer, UUID>();
    private final Map<UUID, Integer> playerHandheldSnails = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, LocationalAudioChannel> playerMovingChannels = new ConcurrentHashMap<UUID, LocationalAudioChannel>();
    private final Set<UUID> playersInCall = ConcurrentHashMap.newKeySet();
    private final Map<Integer, UUID> ringingSnails = new ConcurrentHashMap<Integer, UUID>();
    private final Map<Integer, Long> lastAudioActivityTime = new ConcurrentHashMap<Integer, Long>();
    private static final long AUDIO_ACTIVITY_WINDOW_MS = 500L;
    private SnailAudioRelay audioRelay;

    public TransponderCallManager(VoicechatServerApi voiceChatApi) {
        this.voiceChatApi = voiceChatApi;
        this.soundManager = new CallSoundManager();
        this.scheduler = Executors.newScheduledThreadPool(2);
        this.scheduler.scheduleAtFixedRate(this::cleanupInactiveCalls, 30L, 30L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(this::updateHandheldAudioPositions, 250L, 250L, TimeUnit.MILLISECONDS);
        System.out.println("TransponderCallManager: Initialized with handheld snail support");
    }

    public boolean isSnailRinging(int snailNumber) {
        return this.ringingSnails.containsKey(snailNumber);
    }

    @Nullable
    public UUID getRingingCallId(int snailNumber) {
        return this.ringingSnails.get(snailNumber);
    }

    public int getCallerSnailNumber(int snailNumber) {
        UUID callId = this.ringingSnails.get(snailNumber);
        if (callId == null) {
            return -1;
        }
        CallSession session = this.activeCalls.get(callId);
        if (session == null) {
            return -1;
        }
        for (CallSession.CallParticipant participant : session.getAllParticipants()) {
            if (!participant.hasActivePlayer()) continue;
            return participant.getSnailNumber();
        }
        return -1;
    }

    public void registerSnailBlock(int snailNumber, TransponderSnailBlockEntity blockEntity) {
        this.registeredSnailBlocks.put(snailNumber, blockEntity);
        System.out.println("TransponderCallManager: Registered snail block #" + snailNumber);
    }

    public void unregisterSnailBlock(int snailNumber) {
        this.registeredSnailBlocks.remove(snailNumber);
        this.stopRingingAtSnail(snailNumber);
        if (!this.isInTransition(snailNumber)) {
            this.endCallBySnailNumber(snailNumber);
        }
        System.out.println("TransponderCallManager: Unregistered snail block #" + snailNumber);
    }

    private boolean isInTransition(int snailNumber) {
        return false;
    }

    @Nullable
    public TransponderSnailBlockEntity getRegisteredSnailBlock(int snailNumber) {
        return this.registeredSnailBlocks.get(snailNumber);
    }

    public boolean isSnailBlockRegistered(int snailNumber) {
        return this.registeredSnailBlocks.containsKey(snailNumber);
    }

    public void registerHandheldSnail(int snailNumber, UUID playerId) {
        UUID previousOwner = this.handheldSnailOwners.get(snailNumber);
        if (previousOwner != null && !previousOwner.equals(playerId)) {
            this.playerHandheldSnails.remove(previousOwner);
            System.out.println("TransponderCallManager: Handheld snail #" + snailNumber + " transferred from " + previousOwner.toString().substring(0, 8) + " to " + playerId.toString().substring(0, 8));
        }
        this.handheldSnailOwners.put(snailNumber, playerId);
        this.playerHandheldSnails.put(playerId, snailNumber);
        System.out.println("TransponderCallManager: Registered handheld snail #" + snailNumber + " for player " + playerId.toString().substring(0, 8));
    }

    public void unregisterHandheldSnail(int snailNumber) {
        UUID owner = this.handheldSnailOwners.remove(snailNumber);
        if (owner != null) {
            this.playerHandheldSnails.remove(owner);
            System.out.println("TransponderCallManager: Unregistered handheld snail #" + snailNumber);
        }
    }

    @Nullable
    public UUID getHandheldSnailOwner(int snailNumber) {
        return this.handheldSnailOwners.get(snailNumber);
    }

    public boolean isHandheldSnail(int snailNumber) {
        return this.handheldSnailOwners.containsKey(snailNumber);
    }

    public int getPlayerHandheldSnail(UUID playerId) {
        return this.playerHandheldSnails.getOrDefault(playerId, -1);
    }

    @Nullable
    private UUID findHandheldSnailOwner(int snailNumber) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || SnailNBTHandler.getSnailNumber(stack) != snailNumber) continue;
                System.out.println("TransponderCallManager: Found handheld snail #" + snailNumber + " in " + player.m_7755_().getString() + "'s inventory");
                return player.m_20148_();
            }
            ItemStack mainHand = player.m_21205_();
            if (!mainHand.m_41619_() && SnailNBTHandler.getSnailNumber(mainHand) == snailNumber) {
                System.out.println("TransponderCallManager: Found handheld snail #" + snailNumber + " in " + player.m_7755_().getString() + "'s main hand");
                return player.m_20148_();
            }
            ItemStack offHand = player.m_21206_();
            if (offHand.m_41619_() || SnailNBTHandler.getSnailNumber(offHand) != snailNumber) continue;
            System.out.println("TransponderCallManager: Found handheld snail #" + snailNumber + " in " + player.m_7755_().getString() + "'s offhand");
            return player.m_20148_();
        }
        return null;
    }

    public boolean initiateCallBySnailNumber(ServerPlayer caller, int callerSnailNumber, int targetSnailNumber) {
        try {
            CallSession.CallParticipant targetParticipant;
            System.out.println("DEBUG initiateCall: Caller=#" + callerSnailNumber + " \u2192 Target=#" + targetSnailNumber);
            if (callerSnailNumber == targetSnailNumber) {
                caller.m_213846_((Component)Component.m_237113_((String)"Cannot call your own snail!"));
                return false;
            }
            if (this.isInCall(caller.m_20148_())) {
                caller.m_213846_((Component)Component.m_237113_((String)"You are already in a call!"));
                return false;
            }
            if (!this.snailExists(targetSnailNumber)) {
                caller.m_213846_((Component)Component.m_237113_((String)("Snail #" + targetSnailNumber + " does not exist!")));
                return false;
            }
            if (this.isSnailInCall(targetSnailNumber)) {
                this.handleTargetBusy(caller, callerSnailNumber, targetSnailNumber);
                return false;
            }
            UUID callId = UUID.randomUUID();
            CallSession.CallParticipant callerParticipant = this.createParticipantForSnail(callerSnailNumber, caller);
            System.out.println("DEBUG initiateCall: Caller participant type: " + callerParticipant.getType());
            CallSession callSession = new CallSession(callId, callerSnailNumber, callerParticipant);
            callSession.setState(CallSession.CallState.INITIATING);
            this.updateBlockEntitiesForCall(callSession);
            try {
                targetParticipant = this.createParticipantForSnail(targetSnailNumber, null);
                System.out.println("DEBUG initiateCall: Target participant type: " + targetParticipant.getType());
            }
            catch (IllegalStateException e) {
                System.err.println("DEBUG initiateCall: Could not find target snail #" + targetSnailNumber);
                caller.m_213846_((Component)Component.m_237113_((String)("Snail #" + targetSnailNumber + " is not available!")).m_130940_(ChatFormatting.RED));
                return false;
            }
            callSession.addParticipant(targetSnailNumber, targetParticipant);
            this.activeCalls.put(callId, callSession);
            this.playerToCallId.put(caller.m_20148_(), callId);
            System.out.println("DEBUG initiateCall: \u2705 Added caller to playerToCallId");
            this.snailToCallId.put(callerSnailNumber, callId);
            this.snailToCallId.put(targetSnailNumber, callId);
            callSession.setState(CallSession.CallState.RINGING);
            this.updateBlockEntitiesForCall(callSession);
            boolean ringingStarted = this.startRinging(callSession, callerSnailNumber, targetSnailNumber);
            if (!ringingStarted) {
                System.err.println("DEBUG initiateCall: Failed to start ringing");
                this.activeCalls.remove(callId);
                this.playerToCallId.remove(caller.m_20148_());
                this.snailToCallId.remove(callerSnailNumber);
                this.snailToCallId.remove(targetSnailNumber);
                caller.m_213846_((Component)Component.m_237113_((String)("Could not reach snail #" + targetSnailNumber + "!")).m_130940_(ChatFormatting.RED));
                return false;
            }
            System.out.println("DEBUG initiateCall: \u2705 Call initiated successfully");
            return true;
        }
        catch (Exception e) {
            System.err.println("DEBUG initiateCall: \u274c Exception: " + e.getMessage());
            e.printStackTrace();
            caller.m_213846_((Component)Component.m_237113_((String)"Failed to initiate call!"));
            return false;
        }
    }

    private boolean startRinging(CallSession callSession, int callerSnailNumber, int targetSnailNumber) {
        this.ringingSnails.put(targetSnailNumber, callSession.getCallId());
        System.out.println("TransponderCallManager: Marked snail #" + targetSnailNumber + " as ringing (caller: #" + callerSnailNumber + ")");
        TransponderSnailBlockEntity targetBlock = this.getRegisteredSnailBlock(targetSnailNumber);
        if (targetBlock != null) {
            targetBlock.onIncomingCall(callSession.getCallId(), callerSnailNumber, callSession);
            BlockPos targetPos = targetBlock.m_58899_();
            ServerLevel level = (ServerLevel)targetBlock.m_58904_();
            this.soundManager.playLocationalRingToneAtPosition((Level)level, targetPos);
            System.out.println("TransponderCallManager: Started ringtone at BLOCK snail #" + targetSnailNumber);
            this.scheduler.schedule(() -> {
                if (callSession.getState() == CallSession.CallState.RINGING) {
                    this.handleCallTimeout(callSession);
                }
            }, VoiceChatConstants.getRingTimeoutMs(), TimeUnit.MILLISECONDS);
            return true;
        }
        UUID handheldOwner = this.handheldSnailOwners.get(targetSnailNumber);
        System.out.println("=== DEBUG startRinging HANDHELD ===");
        System.out.println("Target snail #" + targetSnailNumber);
        System.out.println("Caller snail #" + callerSnailNumber);
        System.out.println("Registered owner: " + (handheldOwner != null ? handheldOwner.toString().substring(0, 8) : "null"));
        if (handheldOwner == null) {
            handheldOwner = this.findHandheldSnailOwner(targetSnailNumber);
            System.out.println("After lazy search: " + (handheldOwner != null ? handheldOwner.toString().substring(0, 8) : "null"));
            if (handheldOwner != null) {
                this.registerHandheldSnail(targetSnailNumber, handheldOwner);
                System.out.println("Lazy-registered handheld snail #" + targetSnailNumber);
            }
        }
        if (handheldOwner != null) {
            ServerPlayer owner = this.getPlayerById(handheldOwner);
            System.out.println("Owner player: " + (owner != null ? owner.m_7755_().getString() : "null"));
            if (owner != null) {
                System.out.println("ABOUT TO CALL updateAllSnailItemInstances:");
                System.out.println("  - owner: " + owner.m_7755_().getString());
                System.out.println("  - targetSnailNumber: " + targetSnailNumber);
                System.out.println("  - callId: " + callSession.getCallId().toString().substring(0, 8));
                System.out.println("  - callerSnailNumber: " + callerSnailNumber + " (should NOT be -1)");
                this.updateAllSnailItemInstances(owner, targetSnailNumber, callSession.getCallId(), callerSnailNumber);
                owner.m_213846_((Component)Component.m_237113_((String)("Incoming call on snail #" + targetSnailNumber + " from #" + callerSnailNumber)).m_130940_(ChatFormatting.YELLOW));
                this.soundManager.playRingToneForPlayer(owner);
                System.out.println("TransponderCallManager: Started ringtone for HANDHELD snail #" + targetSnailNumber);
                this.scheduler.schedule(() -> {
                    if (callSession.getState() == CallSession.CallState.RINGING) {
                        this.handleCallTimeout(callSession);
                    }
                }, VoiceChatConstants.getRingTimeoutMs(), TimeUnit.MILLISECONDS);
                return true;
            }
            System.err.println("ERROR: Could not find owner player for handheld snail #" + targetSnailNumber);
            this.ringingSnails.remove(targetSnailNumber);
            return false;
        }
        System.err.println("ERROR: Could not find handheld snail #" + targetSnailNumber);
        this.ringingSnails.remove(targetSnailNumber);
        return false;
    }

    private void updateAllSnailItemInstances(ServerPlayer player, int snailNumber, UUID callId, int callerSnailNumber) {
        int offHandSnailNum;
        ItemStack offHand;
        int mainHandSnailNum;
        CompoundTag verify;
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\u2551 DEBUG updateAllSnailItemInstances");
        System.out.println("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\u2551 Player: " + player.m_7755_().getString());
        System.out.println("\u2551 Target Snail: #" + snailNumber);
        System.out.println("\u2551 CallID: " + (callId != null ? callId.toString().substring(0, 8) : "null"));
        System.out.println("\u2551 Caller Snail: #" + callerSnailNumber);
        System.out.println("\u2551 Is Ringing: " + (callerSnailNumber != -1));
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        int updatedCount = 0;
        int checkedCount = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            int stackSnailNum;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || (stackSnailNum = SnailNBTHandler.getSnailNumber(stack)) == -1) continue;
            ++checkedCount;
            System.out.println("  Slot " + i + ": Snail #" + stackSnailNum);
            if (stackSnailNum != snailNumber) continue;
            System.out.println("    \u2713\u2713\u2713 MATCH FOUND! Updating...");
            if (callerSnailNumber != -1) {
                System.out.println("    \u2192 Setting RINGING state");
                this.updateSnailItemRingingState(stack, callId, callerSnailNumber);
                verify = stack.m_41783_();
                if (verify != null) {
                    System.out.println("    \u2192 Verified: call_state = '" + verify.m_128461_("call_state") + "'");
                }
            } else {
                System.out.println("    \u2192 Setting CONNECTED state");
                this.updateSnailItemConnectedState(stack, callId);
            }
            ++updatedCount;
        }
        ItemStack mainHand = player.m_21205_();
        if (!mainHand.m_41619_() && (mainHandSnailNum = SnailNBTHandler.getSnailNumber(mainHand)) != -1) {
            ++checkedCount;
            System.out.println("  MainHand: Snail #" + mainHandSnailNum);
            if (mainHandSnailNum == snailNumber) {
                System.out.println("    \u2713\u2713\u2713 MATCH FOUND! Updating...");
                if (callerSnailNumber != -1) {
                    System.out.println("    \u2192 Setting RINGING state");
                    this.updateSnailItemRingingState(mainHand, callId, callerSnailNumber);
                    CompoundTag verify2 = mainHand.m_41783_();
                    if (verify2 != null) {
                        System.out.println("    \u2192 Verified: call_state = '" + verify2.m_128461_("call_state") + "'");
                    }
                } else {
                    System.out.println("    \u2192 Setting CONNECTED state");
                    this.updateSnailItemConnectedState(mainHand, callId);
                }
                ++updatedCount;
            }
        }
        if (!(offHand = player.m_21206_()).m_41619_() && (offHandSnailNum = SnailNBTHandler.getSnailNumber(offHand)) != -1) {
            ++checkedCount;
            System.out.println("  OffHand: Snail #" + offHandSnailNum);
            if (offHandSnailNum == snailNumber) {
                System.out.println("    \u2713\u2713\u2713 MATCH FOUND! Updating...");
                if (callerSnailNumber != -1) {
                    System.out.println("    \u2192 Setting RINGING state");
                    this.updateSnailItemRingingState(offHand, callId, callerSnailNumber);
                    verify = offHand.m_41783_();
                    if (verify != null) {
                        System.out.println("    \u2192 Verified: call_state = '" + verify.m_128461_("call_state") + "'");
                    }
                } else {
                    System.out.println("    \u2192 Setting CONNECTED state");
                    this.updateSnailItemConnectedState(offHand, callId);
                }
                ++updatedCount;
            }
        }
        System.out.println("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        System.out.println("\u2551 RESULT: Checked " + checkedCount + " snails, Updated " + updatedCount + " items");
        System.out.println("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private void updateSnailItemRingingState(ItemStack stack, UUID callId, int callerSnailNumber) {
        System.out.println("      [updateSnailItemRingingState] Writing NBT...");
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("call_state", "ringing");
        nbt.m_128362_("active_call_id", callId);
        nbt.m_128405_("other_snail_number", callerSnailNumber);
        nbt.m_128356_("call_start_time", System.currentTimeMillis());
        System.out.println("      [updateSnailItemRingingState] NBT written: call_state='ringing', caller=#" + callerSnailNumber);
    }

    private void updateSnailItemConnectedState(ItemStack stack, UUID callId) {
        System.out.println("      [updateSnailItemConnectedState] Writing NBT...");
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("call_state", "connected");
        nbt.m_128362_("active_call_id", callId);
        nbt.m_128356_("call_start_time", System.currentTimeMillis());
        nbt.m_128473_("other_snail_number");
        System.out.println("      [updateSnailItemConnectedState] NBT written: call_state='connected'");
    }

    private CallSession.CallParticipant createParticipantForSnail(int snailNumber, @Nullable ServerPlayer player) {
        UUID handheldOwner;
        System.out.println("DEBUG createParticipantForSnail: Snail #" + snailNumber + ", Player: " + (player != null ? player.m_7755_().getString() : "null"));
        if (player != null && (handheldOwner = this.getHandheldSnailOwner(snailNumber)) != null && handheldOwner.equals(player.m_20148_())) {
            System.out.println("DEBUG: Creating HANDHELD participant for player's snail #" + snailNumber);
            return CallSession.CallParticipant.handheld(player.m_20148_(), snailNumber);
        }
        TransponderSnailBlockEntity blockEntity = this.getRegisteredSnailBlock(snailNumber);
        if (blockEntity != null) {
            System.out.println("DEBUG: Creating BLOCK participant for snail #" + snailNumber);
            if (player != null) {
                return CallSession.CallParticipant.blockWithPlayer(player.m_20148_(), snailNumber, blockEntity.m_58899_());
            }
            return CallSession.CallParticipant.block(snailNumber, blockEntity.m_58899_());
        }
        UUID handheldOwner2 = this.getHandheldSnailOwner(snailNumber);
        if (handheldOwner2 == null && (handheldOwner2 = this.findHandheldSnailOwner(snailNumber)) != null) {
            this.registerHandheldSnail(snailNumber, handheldOwner2);
            System.out.println("DEBUG: Lazy-registered handheld snail #" + snailNumber);
        }
        if (handheldOwner2 != null) {
            System.out.println("DEBUG: Creating HANDHELD participant (no player provided) for snail #" + snailNumber);
            return CallSession.CallParticipant.handheld(handheldOwner2, snailNumber);
        }
        throw new IllegalStateException("Snail #" + snailNumber + " not found as block or handheld");
    }

    private void updateBlockEntitiesForCall(CallSession callSession) {
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            TransponderSnailBlockEntity blockEntity = this.getRegisteredSnailBlock(snailNumber);
            if (blockEntity == null) continue;
            blockEntity.setCallSession(callSession);
        }
    }

    private void clearCallSessionFromBlockEntities(CallSession callSession) {
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            TransponderSnailBlockEntity blockEntity = this.getRegisteredSnailBlock(snailNumber);
            if (blockEntity == null) continue;
            blockEntity.clearCallSession();
        }
    }

    public boolean acceptCall(ServerPlayer player, UUID callId) {
        CallSession callSession = this.activeCalls.get(callId);
        if (callSession == null || callSession.getState() != CallSession.CallState.RINGING) {
            System.out.println("DEBUG acceptCall: Invalid call state");
            return false;
        }
        try {
            System.out.println("DEBUG acceptCall: Player " + player.m_7755_().getString() + " accepting call " + callId.toString().substring(0, 8));
            this.stopRingingForCall(callSession);
            System.out.println("DEBUG acceptCall: Ringing stopped");
            int answeringSnailNumber = -1;
            CallSession.CallParticipant answeringParticipant = null;
            Iterator<Integer> iterator = callSession.getParticipantSnailNumbers().iterator();
            while (iterator.hasNext()) {
                ServerPlayer nearbyPlayer;
                Integer snailNumber;
                CallSession.CallParticipant participant = callSession.getParticipant(snailNumber = iterator.next());
                System.out.println("DEBUG acceptCall: Checking snail #" + snailNumber + " (type: " + (Serializable)(participant != null ? participant.getType() : "null") + ")");
                if (this.isHandheldSnail(snailNumber)) {
                    UUID owner = this.getHandheldSnailOwner(snailNumber);
                    System.out.println("DEBUG acceptCall: Snail #" + snailNumber + " is HANDHELD, owner: " + (owner != null ? owner.toString().substring(0, 8) : "null"));
                    if (owner == null || !owner.equals(player.m_20148_())) continue;
                    answeringSnailNumber = snailNumber;
                    answeringParticipant = participant;
                    System.out.println("DEBUG acceptCall: \u2705 Found answering HANDHELD snail #" + snailNumber);
                    break;
                }
                if (!this.isSnailBlockRegistered(snailNumber)) continue;
                TransponderSnailBlockEntity block = this.getRegisteredSnailBlock(snailNumber);
                System.out.println("DEBUG acceptCall: Snail #" + snailNumber + " is BLOCK");
                if (block == null || (nearbyPlayer = block.findNearbyPlayer()) != player) continue;
                answeringSnailNumber = snailNumber;
                answeringParticipant = participant;
                System.out.println("DEBUG acceptCall: \u2705 Found answering BLOCK snail #" + snailNumber);
                break;
            }
            if (answeringSnailNumber == -1) {
                System.err.println("DEBUG acceptCall: \u274c Could not find answering snail for player " + player.m_7755_().getString());
            }
            if (answeringSnailNumber != -1) {
                if (this.isHandheldSnail(answeringSnailNumber)) {
                    this.soundManager.playPickUpSoundForPlayer(player);
                    System.out.println("DEBUG acceptCall: \u2705 Played HANDHELD pick up sound for snail #" + answeringSnailNumber);
                } else {
                    TransponderSnailBlockEntity block = this.getRegisteredSnailBlock(answeringSnailNumber);
                    if (block != null) {
                        this.soundManager.playPickUpSoundAtSnail(player, block.m_58899_());
                        System.out.println("DEBUG acceptCall: \u2705 Played BLOCK pick up sound for snail #" + answeringSnailNumber);
                    }
                }
            }
            this.connectCall(callSession, player);
            System.out.println("DEBUG acceptCall: Call connected");
            if (answeringSnailNumber != -1 && this.isHandheldSnail(answeringSnailNumber)) {
                this.updateAllSnailItemInstances(player, answeringSnailNumber, callSession.getCallId(), -1);
                System.out.println("DEBUG acceptCall: Updated handheld snail #" + answeringSnailNumber + " NBT to connected state");
            }
            player.m_213846_((Component)Component.m_237113_((String)"Call connected!").m_130940_(ChatFormatting.GREEN));
            return true;
        }
        catch (Exception e) {
            System.err.println("DEBUG acceptCall: Error accepting call: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean rejectCall(ServerPlayer player, UUID callId) {
        CallSession callSession = this.activeCalls.get(callId);
        if (callSession == null) {
            return false;
        }
        this.stopRingingForCall(callSession);
        this.notifyCallRejected(callSession);
        this.endCall(callId);
        return true;
    }

    private void connectCall(CallSession callSession, ServerPlayer acceptingPlayer) {
        System.out.println("DEBUG connectCall: Connecting call for player " + acceptingPlayer.m_7755_().getString());
        this.updateBlockEntitiesForCall(callSession);
        callSession.setState(CallSession.CallState.CONNECTED);
        boolean playerWasParticipant = callSession.isParticipant(acceptingPlayer.m_20148_());
        if (!playerWasParticipant) {
            System.out.println("DEBUG connectCall: Player not yet participant, updating participant");
            for (CallSession.CallParticipant participant : callSession.getAllParticipants()) {
                CallSession.CallParticipant updatedParticipant;
                if (participant.hasActivePlayer()) continue;
                System.out.println("DEBUG connectCall: Found participant without player - Snail #" + participant.getSnailNumber() + ", Type: " + participant.getType());
                if (participant.isHandheld()) {
                    updatedParticipant = CallSession.CallParticipant.handheld(acceptingPlayer.m_20148_(), participant.getSnailNumber());
                    System.out.println("DEBUG connectCall: \u2705 Updated as HANDHELD participant");
                } else {
                    updatedParticipant = CallSession.CallParticipant.blockWithPlayer(acceptingPlayer.m_20148_(), participant.getSnailNumber(), participant.getBlockPosition());
                    System.out.println("DEBUG connectCall: \u2705 Updated as BLOCK participant");
                }
                callSession.removeParticipant(participant.getSnailNumber());
                callSession.addParticipant(participant.getSnailNumber(), updatedParticipant);
                break;
            }
        } else {
            System.out.println("DEBUG connectCall: Player already participant (handheld owner)");
        }
        if (!this.playerToCallId.containsKey(acceptingPlayer.m_20148_())) {
            this.playerToCallId.put(acceptingPlayer.m_20148_(), callSession.getCallId());
            System.out.println("DEBUG connectCall: \u2705 Added player to playerToCallId");
        } else {
            System.out.println("DEBUG connectCall: Player already in playerToCallId");
        }
        this.createAudioChannels(callSession);
        this.playConnectionSounds(callSession);
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            TransponderSnailBlockEntity block = this.getRegisteredSnailBlock(snailNumber);
            if (block == null) continue;
            block.onCallConnected(callSession.getCallId(), callSession);
        }
        System.out.println("DEBUG connectCall: \u2705 Call connected - Participants: " + callSession.getParticipantCount() + ", PlayerToCallId entries: " + this.playerToCallId.size());
        for (CallSession.CallParticipant p : callSession.getAllParticipants()) {
            System.out.println("  - Snail #" + p.getSnailNumber() + " (" + p.getType() + "), Player: " + (p.hasActivePlayer() ? p.getPlayerId().toString().substring(0, 8) : "none"));
        }
    }

    private void createAudioChannels(CallSession callSession) {
        System.out.println("DEBUG createAudioChannels: Creating channels for " + callSession.getParticipantCount() + " participants");
        int blockChannels = 0;
        int handheldChannels = 0;
        for (BlockPos pos : callSession.getInvolvedBlockPositions()) {
            this.createBlockAudioChannelAtPosition(callSession, pos);
            ++blockChannels;
        }
        for (CallSession.CallParticipant participant : callSession.getAllParticipants()) {
            if (!participant.isHandheld() || !participant.hasActivePlayer()) continue;
            this.createHandheldAudioChannel(callSession, participant.getSnailNumber(), participant.getPlayerId());
            ++handheldChannels;
            System.out.println("DEBUG createAudioChannels: Created handheld channel for snail #" + participant.getSnailNumber() + " (player " + participant.getPlayerId().toString().substring(0, 8) + ")");
        }
        System.out.println("DEBUG createAudioChannels: Created " + blockChannels + " block channels and " + handheldChannels + " handheld channels");
        System.out.println("DEBUG createAudioChannels: Total channels in session: " + callSession.getAllAudioChannels().size());
    }

    private void createBlockAudioChannelAtPosition(CallSession session, BlockPos pos) {
        try {
            LocationalAudioChannel channel;
            TransponderSnailBlockEntity block = null;
            for (Integer snailNumber : session.getParticipantSnailNumbers()) {
                TransponderSnailBlockEntity testBlock = this.getRegisteredSnailBlock(snailNumber);
                if (testBlock == null || !testBlock.m_58899_().equals((Object)pos)) continue;
                block = testBlock;
                break;
            }
            if (block != null && (channel = this.voiceChatApi.createLocationalAudioChannel(UUID.randomUUID(), this.voiceChatApi.fromServerLevel((Object)((ServerLevel)block.m_58904_())), this.voiceChatApi.createPosition((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5))) != null) {
                channel.setCategory("snail_volume");
                channel.setDistance((float)VoiceChatConstants.getLocationalSnailRange());
                session.addProximityChannel(pos, (AudioChannel)channel);
                System.out.println("TransponderCallManager: Created block audio channel at " + pos);
            }
        }
        catch (Exception e) {
            System.err.println("TransponderCallManager: Failed to create block audio channel: " + e.getMessage());
        }
    }

    private void createHandheldAudioChannel(CallSession session, int snailNumber, UUID playerId) {
        try {
            ServerPlayer player = this.getPlayerById(playerId);
            if (player == null) {
                System.err.println("DEBUG createHandheldAudioChannel: Player not found for " + playerId.toString().substring(0, 8));
                return;
            }
            LocationalAudioChannel channel = this.voiceChatApi.createLocationalAudioChannel(UUID.randomUUID(), this.voiceChatApi.fromServerLevel((Object)player.m_284548_()), this.voiceChatApi.createPosition(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_()));
            if (channel != null) {
                channel.setCategory("snail_volume");
                channel.setDistance((float)VoiceChatConstants.getHandheldSnailRange());
                this.playerMovingChannels.put(playerId, channel);
                session.addHandheldChannel(playerId, (AudioChannel)channel);
                System.out.println("DEBUG createHandheldAudioChannel: \u2705 Created and stored handheld channel for player " + player.m_7755_().getString() + " (snail #" + snailNumber + ")");
                System.out.println("DEBUG createHandheldAudioChannel: Session now has " + session.getHandheldChannels().size() + " handheld channels");
            } else {
                System.err.println("DEBUG createHandheldAudioChannel: \u274c Failed to create channel (API returned null)");
            }
        }
        catch (Exception e) {
            System.err.println("DEBUG createHandheldAudioChannel: \u274c Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean hasActiveAudio(int snailNumber) {
        TransponderSnailBlockEntity block;
        long timeSinceActivity;
        UUID callId = this.snailToCallId.get(snailNumber);
        if (callId == null) {
            return false;
        }
        CallSession session = this.activeCalls.get(callId);
        if (session == null || session.getState() != CallSession.CallState.CONNECTED) {
            return false;
        }
        Long lastActivity = this.lastAudioActivityTime.get(snailNumber);
        if (lastActivity != null && (timeSinceActivity = System.currentTimeMillis() - lastActivity) < 500L) {
            return true;
        }
        return !this.isHandheldSnail(snailNumber) && (block = this.getRegisteredSnailBlock(snailNumber)) != null && block.isAudioReady();
    }

    public void markAudioActivity(int snailNumber) {
        this.lastAudioActivityTime.put(snailNumber, System.currentTimeMillis());
    }

    public void markAudioActivityForCall(UUID callId) {
        CallSession session = this.activeCalls.get(callId);
        if (session != null) {
            for (Integer snailNumber : session.getParticipantSnailNumbers()) {
                this.markAudioActivity(snailNumber);
            }
        }
    }

    public void endCall(UUID callId) {
        CallSession callSession = this.activeCalls.remove(callId);
        if (callSession == null) {
            return;
        }
        try {
            System.out.println("TransponderCallManager: Ending call " + callId.toString().substring(0, 8));
            callSession.setState(CallSession.CallState.ENDING);
            this.updateBlockEntitiesForCall(callSession);
            this.stopRingingForCall(callSession);
            if (this.audioRelay != null) {
                this.audioRelay.onCallEnded(callId);
            }
            this.cleanupCall(callSession);
            this.notifyCallEnded(callSession);
            this.scheduler.schedule(() -> {
                callSession.setState(CallSession.CallState.ENDED);
                this.updateBlockEntitiesForCall(callSession);
                this.scheduler.schedule(() -> this.clearCallSessionFromBlockEntities(callSession), 1000L, TimeUnit.MILLISECONDS);
            }, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("TransponderCallManager: Error ending call: " + e.getMessage());
        }
    }

    public void endCall(ServerPlayer player) {
        System.out.println("DEBUG endCall(player): Attempting to end call for " + player.m_7755_().getString());
        System.out.println("DEBUG endCall(player): Player UUID: " + player.m_20148_().toString().substring(0, 8));
        UUID callId = this.playerToCallId.get(player.m_20148_());
        if (callId == null) {
            System.err.println("DEBUG endCall(player): \u274c Player not found in playerToCallId map!");
            System.err.println("DEBUG endCall(player): Current playerToCallId size: " + this.playerToCallId.size());
            for (CallSession session : this.activeCalls.values()) {
                if (!session.isParticipant(player.m_20148_())) continue;
                System.err.println("DEBUG endCall(player): \u26a0\ufe0f Found player in call session " + session.getCallId().toString().substring(0, 8) + " but not in playerToCallId - attempting recovery");
                callId = session.getCallId();
                break;
            }
            if (callId == null) {
                System.err.println("DEBUG endCall(player): \u274c Cannot find any call for this player");
                player.m_213846_((Component)Component.m_237113_((String)"Error: You are not in a call").m_130940_(ChatFormatting.RED));
                return;
            }
        }
        System.out.println("DEBUG endCall(player): Found callId: " + callId.toString().substring(0, 8));
        UUID finalCallId = callId;
        CallSession callSession = this.activeCalls.get(callId);
        if (callSession != null) {
            for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
                ItemStack snailItem;
                UUID owner;
                ServerPlayer ownerPlayer;
                if (!this.isHandheldSnail(snailNumber) || (ownerPlayer = this.getPlayerById(owner = this.getHandheldSnailOwner(snailNumber))) == null || (snailItem = this.findSnailItemInInventory(ownerPlayer, snailNumber)).m_41619_()) continue;
                CompoundTag nbt = snailItem.m_41784_();
                nbt.m_128473_("call_state");
                nbt.m_128473_("active_call_id");
                nbt.m_128473_("other_snail_number");
                nbt.m_128473_("call_start_time");
            }
            this.playHangUpSoundForPlayer(player, callSession);
            this.scheduler.schedule(() -> this.endCall(finalCallId), 800L, TimeUnit.MILLISECONDS);
            System.out.println("DEBUG endCall(player): \u2705 Scheduled call termination");
        } else {
            System.err.println("DEBUG endCall(player): \u26a0\ufe0f CallSession not found, calling endCall(callId) directly");
            this.endCall(callId);
        }
    }

    public void endCallBySnailNumber(int snailNumber) {
        UUID callId = this.snailToCallId.get(snailNumber);
        if (callId != null) {
            this.endCall(callId);
        }
    }

    private void cleanupCall(CallSession callSession) {
        for (UUID playerId : callSession.getActivePlayerParticipants()) {
            this.playerToCallId.remove(playerId);
        }
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            this.snailToCallId.remove(snailNumber);
            this.ringingSnails.remove(snailNumber);
            this.lastAudioActivityTime.remove(snailNumber);
        }
        callSession.getProximityChannels().clear();
        for (UUID playerId : callSession.getHandheldChannels().keySet()) {
            this.playerMovingChannels.remove(playerId);
        }
        callSession.getHandheldChannels().clear();
        System.out.println("TransponderCallManager: Cleaned up call " + callSession.getCallId().toString().substring(0, 8));
    }

    private void stopRingingForCall(CallSession callSession) {
        System.out.println("DEBUG stopRingingForCall: Stopping ringing for " + callSession.getParticipantSnailNumbers().size() + " snails");
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            UUID owner;
            ServerPlayer ownerPlayer;
            if (!this.ringingSnails.containsKey(snailNumber)) continue;
            System.out.println("DEBUG stopRingingForCall: Stopping snail #" + snailNumber);
            this.ringingSnails.remove(snailNumber);
            TransponderSnailBlockEntity targetBlock = this.getRegisteredSnailBlock(snailNumber);
            if (targetBlock != null) {
                BlockPos targetPos = targetBlock.m_58899_();
                this.soundManager.stopSnailPositionSounds(targetPos, CallSoundManager.SoundType.RING_TONE);
                System.out.println("DEBUG stopRingingForCall: Stopped BLOCK ringing at " + targetPos);
            }
            if (!this.isHandheldSnail(snailNumber) || (ownerPlayer = this.getPlayerById(owner = this.getHandheldSnailOwner(snailNumber))) == null) continue;
            this.soundManager.stopRingTone(ownerPlayer);
            this.updateAllSnailItemIdleState(ownerPlayer, snailNumber);
            System.out.println("DEBUG stopRingingForCall: Stopped HANDHELD ringing for snail #" + snailNumber + " (player " + ownerPlayer.m_7755_().getString() + ")");
        }
        System.out.println("DEBUG stopRingingForCall: Ringing stopped, remaining ringing snails: " + this.ringingSnails.size());
    }

    private void updateAllSnailItemIdleState(ServerPlayer player, int snailNumber) {
        ItemStack offHand;
        CompoundTag nbt;
        CompoundTag nbt2;
        System.out.println("DEBUG updateAllSnailItemIdleState: Clearing state for snail #" + snailNumber);
        int clearedCount = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || SnailNBTHandler.getSnailNumber(stack) != snailNumber || !(nbt2 = stack.m_41784_()).m_128441_("call_state")) continue;
            nbt2.m_128473_("call_state");
            nbt2.m_128473_("active_call_id");
            nbt2.m_128473_("other_snail_number");
            nbt2.m_128473_("call_start_time");
            ++clearedCount;
        }
        ItemStack mainHand = player.m_21205_();
        if (SnailNBTHandler.getSnailNumber(mainHand) == snailNumber && (nbt = mainHand.m_41784_()).m_128441_("call_state")) {
            nbt.m_128473_("call_state");
            nbt.m_128473_("active_call_id");
            nbt.m_128473_("other_snail_number");
            nbt.m_128473_("call_start_time");
            ++clearedCount;
        }
        if (SnailNBTHandler.getSnailNumber(offHand = player.m_21206_()) == snailNumber && (nbt2 = offHand.m_41784_()).m_128441_("call_state")) {
            nbt2.m_128473_("call_state");
            nbt2.m_128473_("active_call_id");
            nbt2.m_128473_("other_snail_number");
            nbt2.m_128473_("call_start_time");
            ++clearedCount;
        }
        System.out.println("DEBUG updateAllSnailItemIdleState: Cleared " + clearedCount + " item instances");
    }

    private void stopRingingAtSnail(int snailNumber) {
        TransponderSnailBlockEntity snailBlock;
        UUID callId = this.ringingSnails.remove(snailNumber);
        if (callId != null && (snailBlock = this.getRegisteredSnailBlock(snailNumber)) != null) {
            this.soundManager.stopSnailPositionSounds(snailBlock.m_58899_(), CallSoundManager.SoundType.RING_TONE);
        }
    }

    public void transitionBlockToHandheld(int snailNumber, UUID playerId) {
        UUID callId = this.snailToCallId.get(snailNumber);
        if (callId == null) {
            return;
        }
        CallSession session = this.activeCalls.get(callId);
        if (session == null) {
            return;
        }
        this.unregisterSnailBlock(snailNumber);
        this.registerHandheldSnail(snailNumber, playerId);
        CallSession.CallParticipant oldParticipant = session.getParticipant(snailNumber);
        if (oldParticipant != null) {
            session.removeParticipant(snailNumber);
            CallSession.CallParticipant newParticipant = CallSession.CallParticipant.handheld(playerId, snailNumber);
            session.addParticipant(snailNumber, newParticipant);
            this.recreateAudioChannelsForTransition(session, snailNumber, playerId, true);
        }
    }

    public void transitionHandheldToBlock(int snailNumber, BlockPos blockPos, TransponderSnailBlockEntity blockEntity) {
        UUID callId = this.snailToCallId.get(snailNumber);
        if (callId == null) {
            return;
        }
        CallSession session = this.activeCalls.get(callId);
        if (session == null) {
            return;
        }
        UUID playerId = this.handheldSnailOwners.get(snailNumber);
        this.unregisterHandheldSnail(snailNumber);
        this.registerSnailBlock(snailNumber, blockEntity);
        CallSession.CallParticipant oldParticipant = session.getParticipant(snailNumber);
        if (oldParticipant != null) {
            session.removeParticipant(snailNumber);
            CallSession.CallParticipant newParticipant = CallSession.CallParticipant.blockWithPlayer(playerId, snailNumber, blockPos);
            session.addParticipant(snailNumber, newParticipant);
            this.recreateAudioChannelsForTransition(session, snailNumber, playerId, false);
        }
    }

    private void recreateAudioChannelsForTransition(CallSession session, int snailNumber, UUID playerId, boolean toHandheld) {
        if (toHandheld) {
            for (BlockPos pos : session.getInvolvedBlockPositions()) {
                session.removeProximityChannel(pos);
            }
            this.createHandheldAudioChannel(session, snailNumber, playerId);
            System.out.println("TransponderCallManager: Transitioned snail #" + snailNumber + " to handheld");
        } else {
            session.removeHandheldChannel(playerId);
            this.playerMovingChannels.remove(playerId);
            TransponderSnailBlockEntity blockEntity = this.registeredSnailBlocks.get(snailNumber);
            if (blockEntity != null) {
                this.createBlockAudioChannelAtPosition(session, blockEntity.m_58899_());
                System.out.println("TransponderCallManager: Transitioned snail #" + snailNumber + " to block");
            }
        }
    }

    private void updateHandheldAudioPositions() {
        try {
            for (CallSession session : this.activeCalls.values()) {
                if (session.getState() != CallSession.CallState.CONNECTED) continue;
                for (Map.Entry<UUID, AudioChannel> entry : session.getHandheldChannels().entrySet()) {
                    UUID playerId = entry.getKey();
                    AudioChannel channel = entry.getValue();
                    if (!(channel instanceof LocationalAudioChannel)) continue;
                    LocationalAudioChannel locationalChannel = (LocationalAudioChannel)channel;
                    ServerPlayer player = this.getPlayerById(playerId);
                    if (player == null) continue;
                    Position newPosition = this.voiceChatApi.createPosition(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
                    locationalChannel.updateLocation(newPosition);
                }
            }
        }
        catch (Exception e) {
            System.err.println("TransponderCallManager: Error updating handheld positions: " + e.getMessage());
        }
    }

    private void playConnectionSounds(CallSession callSession) {
        System.out.println("DEBUG playConnectionSounds: Playing for " + callSession.getParticipantCount() + " participants");
        for (BlockPos pos : callSession.getInvolvedBlockPositions()) {
            List<ServerPlayer> nearbyPlayers = this.getPlayersNearSnail(this.getWorldForPosition(pos), pos, VoiceChatConstants.getSnailInteractionRange());
            if (nearbyPlayers.isEmpty()) continue;
            this.soundManager.playCallConnectedSoundAtSnail(nearbyPlayers.get(0), pos);
            System.out.println("DEBUG: Played connection sound at BLOCK " + pos);
        }
        for (CallSession.CallParticipant participant : callSession.getAllParticipants()) {
            ServerPlayer player;
            if (!participant.isHandheld() || !participant.hasActivePlayer() || (player = this.getPlayerById(participant.getPlayerId())) == null) continue;
            this.soundManager.playConnectedSoundForPlayer(player);
            System.out.println("DEBUG: Played connection sound for HANDHELD snail #" + participant.getSnailNumber() + " (player " + player.m_7755_().getString() + ")");
        }
    }

    private void playHangUpSoundForPlayer(ServerPlayer player, CallSession callSession) {
        Integer handheldSnailNumber = this.playerHandheldSnails.get(player.m_20148_());
        if (handheldSnailNumber != null) {
            this.soundManager.playHangUpSoundForPlayer(player);
            System.out.println("TransponderCallManager: Playing handheld hang up sound for player " + player.m_7755_().getString());
            return;
        }
        BlockPos playerPos = player.m_20183_();
        BlockPos closestSnailPos = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos pos : callSession.getInvolvedBlockPositions()) {
            double distance = playerPos.m_123331_((Vec3i)pos);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestSnailPos = pos;
        }
        if (closestSnailPos != null) {
            this.soundManager.playHangUpSoundAtSnail(player, closestSnailPos);
            System.out.println("TransponderCallManager: Playing block hang up sound at " + closestSnailPos);
        } else {
            this.soundManager.playHangUpSoundForPlayer(player);
            System.out.println("TransponderCallManager: No nearby snails - playing handheld hang up sound as fallback");
        }
    }

    private void handleTargetBusy(ServerPlayer caller, int callerSnailNumber, int targetSnailNumber) {
        System.out.println("DEBUG handleTargetBusy: Caller snail #" + callerSnailNumber);
        if (this.isHandheldSnail(callerSnailNumber)) {
            this.soundManager.playBusySoundForPlayer(caller);
            System.out.println("DEBUG: Played busy sound for HANDHELD caller #" + callerSnailNumber);
        } else {
            TransponderSnailBlockEntity callerBlock = this.getRegisteredSnailBlock(callerSnailNumber);
            if (callerBlock != null) {
                this.soundManager.playBusySoundAtSnail(caller, callerBlock.m_58899_());
                System.out.println("DEBUG: Played busy sound at BLOCK caller #" + callerSnailNumber);
            }
        }
        caller.m_213846_((Component)Component.m_237113_((String)("Snail #" + targetSnailNumber + " is busy!")).m_130940_(ChatFormatting.RED));
    }

    private void handleCallTimeout(CallSession callSession) {
        this.stopRingingForCall(callSession);
        for (UUID playerId : callSession.getActivePlayerParticipants()) {
            ServerPlayer player = this.getPlayerById(playerId);
            if (player == null) continue;
            player.m_213846_((Component)Component.m_237113_((String)"Call timed out - no answer"));
        }
        this.endCall(callSession.getCallId());
    }

    private void notifyCallRejected(CallSession callSession) {
        for (UUID playerId : callSession.getActivePlayerParticipants()) {
            ServerPlayer player = this.getPlayerById(playerId);
            if (player == null) continue;
            player.m_213846_((Component)Component.m_237113_((String)"Call was rejected"));
        }
    }

    private void notifyCallEnded(CallSession callSession) {
        ServerPlayer player;
        System.out.println("DEBUG notifyCallEnded: Notifying " + callSession.getParticipantCount() + " participants");
        for (BlockPos pos : callSession.getInvolvedBlockPositions()) {
            List<ServerPlayer> nearbyPlayers = this.getPlayersNearSnail(this.getWorldForPosition(pos), pos, VoiceChatConstants.getSnailInteractionRange());
            if (nearbyPlayers.isEmpty()) continue;
            this.soundManager.playCallDisconnectedSoundAtSnail(nearbyPlayers.get(0), pos);
            System.out.println("DEBUG: Played disconnect sound at BLOCK " + pos);
        }
        for (CallSession.CallParticipant participant : callSession.getAllParticipants()) {
            if (!participant.isHandheld() || !participant.hasActivePlayer() || (player = this.getPlayerById(participant.getPlayerId())) == null) continue;
            this.soundManager.playDisconnectedSoundForPlayer(player);
            System.out.println("DEBUG: Played disconnect sound for HANDHELD snail #" + participant.getSnailNumber() + " (player " + player.m_7755_().getString() + ")");
        }
        for (UUID playerId : callSession.getActivePlayerParticipants()) {
            player = this.getPlayerById(playerId);
            if (player == null) continue;
            player.m_213846_((Component)Component.m_237113_((String)"Call ended"));
        }
        for (Integer snailNumber : callSession.getParticipantSnailNumbers()) {
            TransponderSnailBlockEntity block = this.getRegisteredSnailBlock(snailNumber);
            if (block == null) continue;
            block.onCallEnded(callSession.getCallId());
        }
    }

    private boolean snailExists(int snailNumber) {
        SnailNumberRegistry registry = SnailNumberRegistry.getInstance();
        return registry != null && registry.isNumberAssigned(snailNumber);
    }

    private ItemStack findSnailItemInInventory(ServerPlayer player, int snailNumber) {
        ItemStack mainHand = player.m_21205_();
        if (this.isSnailItem(mainHand) && SnailNBTHandler.getSnailNumber(mainHand) == snailNumber) {
            return mainHand;
        }
        ItemStack offHand = player.m_21206_();
        if (this.isSnailItem(offHand) && SnailNBTHandler.getSnailNumber(offHand) == snailNumber) {
            return offHand;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!this.isSnailItem(stack) || SnailNBTHandler.getSnailNumber(stack) != snailNumber) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private boolean isSnailItem(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof TransponderSnailItem || stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof TransponderSnailBlock);
    }

    @Nullable
    private ServerPlayer getPlayerById(UUID playerId) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
    }

    public List<ServerPlayer> getPlayersNearSnail(ServerLevel level, BlockPos snailPos, double range) {
        ArrayList<ServerPlayer> nearbyPlayers = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : level.m_6907_()) {
            double distance = player.m_20275_((double)snailPos.m_123341_() + 0.5, (double)snailPos.m_123342_() + 0.5, (double)snailPos.m_123343_() + 0.5);
            if (!(distance <= range * range)) continue;
            nearbyPlayers.add(player);
        }
        return nearbyPlayers;
    }

    @Nullable
    private ServerLevel getWorldForPosition(BlockPos pos) {
        for (TransponderSnailBlockEntity block : this.registeredSnailBlocks.values()) {
            if (!block.m_58899_().equals((Object)pos)) continue;
            return (ServerLevel)block.m_58904_();
        }
        return null;
    }

    private void cleanupInactiveCalls() {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (CallSession session : this.activeCalls.values()) {
            if (!session.shouldAutoEnd()) continue;
            toRemove.add(session.getCallId());
        }
        for (UUID callId : toRemove) {
            this.endCall(callId);
        }
    }

    public void onPlayerDisconnect(UUID playerId) {
        ServerPlayer player;
        this.playersInCall.remove(playerId);
        if (this.isInCall(playerId) && (player = this.getPlayerById(playerId)) != null) {
            this.endCall(player);
        }
    }

    public boolean isInCall(UUID playerId) {
        return this.playerToCallId.containsKey(playerId);
    }

    public boolean isSnailInCall(int snailNumber) {
        return this.snailToCallId.containsKey(snailNumber);
    }

    @Nullable
    public UUID getPlayerCallId(UUID playerId) {
        return this.playerToCallId.get(playerId);
    }

    public Collection<CallSession> getActiveCalls() {
        return new ArrayList<CallSession>(this.activeCalls.values());
    }

    public CallSoundManager getSoundManager() {
        return this.soundManager;
    }

    public void setAudioRelay(SnailAudioRelay audioRelay) {
        this.audioRelay = audioRelay;
    }

    public SnailAudioRelay getAudioRelay() {
        return this.audioRelay;
    }

    public Map<Integer, TransponderSnailBlockEntity> getRegisteredSnailBlocks() {
        return new HashMap<Integer, TransponderSnailBlockEntity>(this.registeredSnailBlocks);
    }

    public void debugPrintCallState() {
        System.out.println("=== TransponderCallManager Debug ===");
        System.out.println("Active calls: " + this.activeCalls.size());
        System.out.println("PlayerToCallId entries: " + this.playerToCallId.size());
        for (Map.Entry<UUID, UUID> entry : this.playerToCallId.entrySet()) {
            ServerPlayer player = this.getPlayerById(entry.getKey());
            String playerName = player != null ? player.m_7755_().getString() : "Unknown";
            System.out.println("  Player " + playerName + " (" + entry.getKey().toString().substring(0, 8) + ") \u2192 Call " + entry.getValue().toString().substring(0, 8));
        }
        System.out.println("SnailToCallId entries: " + this.snailToCallId.size());
        for (Map.Entry<Comparable<UUID>, UUID> entry : this.snailToCallId.entrySet()) {
            System.out.println("  Snail #" + entry.getKey() + " \u2192 Call " + entry.getValue().toString().substring(0, 8));
        }
        System.out.println("Call Sessions:");
        for (CallSession callSession : this.activeCalls.values()) {
            System.out.println("  " + callSession.toString());
            for (CallSession.CallParticipant p : callSession.getAllParticipants()) {
                System.out.println("    - " + p.toString());
            }
            System.out.println("    Audio channels: Block=" + callSession.getProximityChannels().size() + ", Handheld=" + callSession.getHandheldChannels().size());
        }
        System.out.println("====================================");
    }

    public void cleanup() {
        for (UUID callId : new HashSet<UUID>(this.activeCalls.keySet())) {
            try {
                this.endCall(callId);
            }
            catch (Exception e) {
                System.err.println("Error ending call during cleanup: " + e.getMessage());
            }
        }
        this.activeCalls.clear();
        this.registeredSnailBlocks.clear();
        this.playerToCallId.clear();
        this.snailToCallId.clear();
        this.playersInCall.clear();
        this.ringingSnails.clear();
        if (this.soundManager != null) {
            this.soundManager.cleanup();
        }
    }

    public void shutdown() {
        this.cleanup();
        this.scheduler.shutdown();
    }
}

