package fun.wich.mixin;

import fun.wich.DrownedVillagerEntity;
import fun.wich.OfferGossipExposing;
import fun.wich.ZombieVillagerVariants;
import net.minecraft.class_10179;
import net.minecraft.class_1299;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3850;
import net.minecraft.class_4136;
import net.minecraft.class_6088;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1641.class)
public abstract class ZombieVillagerEntityMixin extends class_1642 implements OfferGossipExposing {
	@Shadow private @Nullable class_4136 gossip;
	@Shadow private @Nullable class_1916 offerData;
	@Shadow public abstract class_3850 getVillagerData();
	@Shadow public abstract int getExperience();

	public ZombieVillagerEntityMixin(class_1299<? extends class_1642> entityType, class_1937 world) { super(entityType, world); }

	public class_4136 GetGossip() { return this.gossip; }
	public class_1916 GetOfferData() { return this.offerData; }

	@Inject(method="canConvertInWater", at=@At("HEAD"), cancellable=true)
	private void AllowConversionInWater(CallbackInfoReturnable<Boolean> cir) { cir.setReturnValue(true); }

	@Override
	protected void method_7218() {
		this.ConvertToDrownedVillagerEntity();
		if (!this.method_5701()) {
			this.method_73183().method_8444(null, class_6088.field_31128, this.method_24515(), 0);
		}
	}


	@Unique
	protected void ConvertToDrownedVillagerEntity() {
		this.method_29243((class_1299<? extends DrownedVillagerEntity>) ZombieVillagerVariants.DROWNED_VILLAGER, class_10179.method_63607(this, true, true), zombieVillager -> {
			class_1937 world = method_73183();
			if (world instanceof class_3218 serverWorld) zombieVillager.method_5943(serverWorld, method_73183().method_8404(zombieVillager.method_24515()), class_3730.field_16468, new class_1644(false, true));
			zombieVillager.method_7195(this.getVillagerData());
			zombieVillager.method_66653(class_9334.field_56145, method_58694(class_9334.field_56145));
			if (this.gossip != null) zombieVillager.setGossip(this.gossip.method_67658());
			if (this.offerData != null) zombieVillager.setOfferData(this.offerData.method_53882());
			zombieVillager.setExperience(this.getExperience());
			if (!this.method_5701()) {
				world.method_8444(null, class_6088.field_31114, this.method_24515(), 0);
			}
		});
	}
}
