package fun.wich;

import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9169;
import net.minecraft.entity.*;
import java.util.function.Function;

public class ZombieVillagerVariants implements ModInitializer {
	public static final String MOD_ID = "wich";
	//Drowned Villager
	public static final class_3414 ENTITY_DROWNED_VILLAGER_AMBIENT = register("entity.drowned_villager.ambient");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_AMBIENT_WATER = register("entity.drowned_villager.ambient_water");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_CURE = register("entity.drowned_villager.cure");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_DEATH = register("entity.drowned_villager.death");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_DEATH_WATER = register("entity.drowned_villager.death_water");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_HURT = register("entity.drowned_villager.hurt");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_HURT_WATER = register("entity.drowned_villager.hurt_water");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_SHOOT = register("entity.drowned_villager.shoot");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_STEP = register("entity.drowned_villager.step");
	public static final class_3414 ENTITY_DROWNED_VILLAGER_SWIM = register("entity.drowned_villager.swim");
	//Villager Husk
	public static final class_3414 ENTITY_VILLAGER_HUSK_AMBIENT = register("entity.villager_husk.ambient");
	public static final class_3414 ENTITY_VILLAGER_HUSK_CURE = register("entity.villager_husk.cure");
	public static final class_3414 ENTITY_VILLAGER_HUSK_DEATH = register("entity.villager_husk.death");
	public static final class_3414 ENTITY_VILLAGER_HUSK_HURT = register("entity.villager_husk.hurt");
	public static final class_3414 ENTITY_VILLAGER_HUSK_STEP = register("entity.villager_husk.step");
	//Parrot Imitations
	public static final class_3414 ENTITY_PARROT_IMITATE_DROWNED_VILLAGER = register("entity.parrot.imitate.drowned_villager");
	public static final class_3414 ENTITY_PARROT_IMITATE_VILLAGER_HUSK = register("entity.parrot.imitate.villager_husk");

	private static class_3414 register(String path) {
		class_2960 id = class_2960.method_60655(MOD_ID, path);
		return class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
	}

	public static final class_1299<DrownedVillagerEntity> DROWNED_VILLAGER = register(
			"drowned_villager",
			class_1299.class_1300.method_5903(DrownedVillagerEntity::new, class_1311.field_6302)
					.method_17687(0.6F, 1.95F)
					.method_55689(2.125F)
					.method_55691(-0.7F)
					.method_55687(1.74F)
					.method_27299(8)
					.method_72391()
	);
	public static final class_1299<VillagerHuskEntity> VILLAGER_HUSK = register(
			"villager_husk",
			class_1299.class_1300.method_5903(VillagerHuskEntity::new, class_1311.field_6302)
					.method_17687(0.6F, 1.95F)
					.method_55689(2.125F)
					.method_55691(-0.7F)
					.method_55687(1.74F)
					.method_27299(8)
					.method_72391()
	);
	private static <T extends class_1297> class_1299<T> register(String name, class_1299.class_1300<T> type) {
		class_5321<class_1299<?>> key = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID, name));
		class_1299<T> entityType = type.method_5905(key);
		class_2378.method_39197(class_7923.field_41177, key, entityType);
		return entityType;
	}


	public static final class_1792 DROWNED_VILLAGER_SPAWN_EGG = register("drowned_villager_spawn_egg", class_1826::new, new class_1792.class_1793().method_72499(DROWNED_VILLAGER));
	public static final class_1792 VILLAGER_HUSK_SPAWN_EGG = register("villager_husk_spawn_egg", class_1826::new, new class_1792.class_1793().method_72499(VILLAGER_HUSK));
	public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
		class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(MOD_ID, name));
		class_1792 item = itemFactory.apply(settings.method_63686(key));
		class_2378.method_39197(class_7923.field_41178, key, item);
		return item;
	}

	@Override
	public void onInitialize() {
		//##########################################
		//#                                        #
		//#            Drowned Villager            #
		//#                                        #
		//##########################################
		//Attributes
		FabricDefaultAttributeRegistry.register(DROWNED_VILLAGER, DrownedVillagerEntity.method_55746());
		//Spawning
		class_1317.method_20637(DROWNED_VILLAGER, class_9169.field_48743, class_2902.class_2903.field_13203, DrownedVillagerEntity::canDrownedVillagerSpawn);
		BiomeModifications.addSpawn(BiomeSelectors.includeByKey(class_1972.field_28107),
				class_1311.field_6302, DROWNED_VILLAGER, 5, 1, 1);
		BiomeModifications.addSpawn(BiomeSelectors.includeByKey(class_1972.field_9467, class_1972.field_9470,
						class_1972.field_9423, class_1972.field_9446, class_1972.field_9441, class_1972.field_9439,
						class_1972.field_9408),
				class_1311.field_6302, DROWNED_VILLAGER, 1, 1, 1);
		//Items
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(itemGroup -> itemGroup.method_45421(DROWNED_VILLAGER_SPAWN_EGG));

		//#########################################
		//#                                       #
		//#             Villager Husk             #
		//#                                       #
		//#########################################
		//Attributes
		FabricDefaultAttributeRegistry.register(VILLAGER_HUSK, VillagerHuskEntity.method_26940());
		//Spawning
		class_1317.method_20637(VILLAGER_HUSK, class_9169.field_48745, class_2902.class_2903.field_13203, VillagerHuskEntity::canSpawn);
		BiomeModifications.addSpawn(BiomeSelectors.includeByKey(class_1972.field_9424),
				class_1311.field_6302, VILLAGER_HUSK, 4, 1, 1);
		//Items
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register(itemGroup -> itemGroup.method_45421(VILLAGER_HUSK_SPAWN_EGG));
	}
}