/*
 * Decompiled with CFR 0.152.
 */
package fun.wich;

import fun.wich.ZombieVillagerVariants;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10179;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1551;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3854;
import net.minecraft.class_4094;
import net.minecraft.class_4136;
import net.minecraft.class_4151;
import net.minecraft.class_4844;
import net.minecraft.class_5425;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public class DrownedVillagerEntity
extends class_1551
implements class_3851 {
    private static final class_2940<Boolean> CONVERTING = class_2945.method_12791(DrownedVillagerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_3850> VILLAGER_DATA = class_2945.method_12791(DrownedVillagerEntity.class, (class_2941)class_2943.field_17207);
    private static final int BASE_CONVERSION_DELAY = 3600;
    private static final int DEFAULT_CONVERSION_TIME = -1;
    private static final int DEFAULT_EXPERIENCE = 0;
    private int conversionTimer;
    @Nullable
    private UUID converter;
    @Nullable
    private class_4136 gossip;
    @Nullable
    private class_1916 offerData;
    private int experience = 0;

    public DrownedVillagerEntity(class_1299<? extends class_1551> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static boolean canDrownedVillagerSpawn(class_1299<DrownedVillagerEntity> ignoredType, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean bl;
        if (!world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && !class_3730.method_54986((class_3730)spawnReason)) {
            return false;
        }
        class_6880 registryEntry = world.method_23753(pos);
        boolean bl2 = bl = !(world.method_8407() == class_1267.field_5801 || !class_3730.method_54987((class_3730)spawnReason) && !DrownedVillagerEntity.method_20679((class_5425)world, (class_2338)pos, (class_5819)random) || !class_3730.method_54986((class_3730)spawnReason) && !world.method_8316(pos).method_15767(class_3486.field_15517));
        if (!bl || !class_3730.method_54986((class_3730)spawnReason) && spawnReason != class_3730.field_16463) {
            if (registryEntry.method_40220(class_6908.field_37390)) {
                return random.method_43048(15) == 0 && bl;
            }
            return random.method_43048(40) == 0 && DrownedVillagerEntity.isValidSpawnDepth((class_1936)world, pos) && bl;
        }
        return true;
    }

    public static boolean isValidSpawnDepth(class_1936 world, class_2338 pos) {
        return pos.method_10264() < world.method_8615() - 5;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CONVERTING, (Object)false);
        builder.method_56912(VILLAGER_DATA, (Object)this.createVillagerData());
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71468("VillagerData", class_3850.field_24669, (Object)this.method_7231());
        view.method_71477("Offers", class_1916.field_48850, (Object)this.offerData);
        view.method_71477("Gossips", class_4136.field_56649, (Object)this.gossip);
        view.method_71465("ConversionTime", this.isConverting() ? this.conversionTimer : -1);
        view.method_71477("ConversionPlayer", class_4844.field_25122, (Object)this.converter);
        view.method_71465("Xp", this.experience);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.field_6011.method_12778(VILLAGER_DATA, (Object)view.method_71426("VillagerData", class_3850.field_24669).orElseGet(this::createVillagerData));
        this.offerData = view.method_71426("Offers", class_1916.field_48850).orElse(null);
        this.gossip = view.method_71426("Gossips", class_4136.field_56649).orElse(null);
        int i = view.method_71424("ConversionTime", -1);
        if (i != -1) {
            UUID uUID = view.method_71426("ConversionPlayer", class_4844.field_25122).orElse(null);
            this.setConverting(uUID, i);
        } else {
            this.method_5841().method_12778(CONVERTING, (Object)false);
            this.conversionTimer = -1;
        }
        this.experience = view.method_71424("Xp", 0);
    }

    private class_3850 createVillagerData() {
        class_1937 world = this.method_73183();
        Optional optional = class_7923.field_41195.method_10240(this.field_5974);
        class_3850 villagerData = class_1646.method_67359().method_66687((class_7871.class_7872)world.method_30349(), class_3854.method_16930((class_6880)world.method_23753(this.method_24515())));
        if (optional.isPresent()) {
            villagerData = villagerData.method_16921((class_6880)optional.get());
        }
        return villagerData;
    }

    public void method_5773() {
        if (!this.method_73183().method_8608() && this.method_5805() && this.isConverting()) {
            int i = this.getConversionRate();
            this.conversionTimer -= i;
            if (this.conversionTimer <= 0) {
                this.finishConversion((class_3218)this.method_73183());
            }
        }
        super.method_5773();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8463)) {
            if (this.method_6059(class_1294.field_5911)) {
                itemStack.method_57008(1, (class_1309)player);
                if (!this.method_73183().method_8608()) {
                    this.setConverting(player.method_5667(), this.field_5974.method_43048(2401) + 3600);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    protected boolean method_7209() {
        return false;
    }

    public boolean method_5974(double distanceSquared) {
        return !this.isConverting() && this.experience == 0;
    }

    public boolean isConverting() {
        return (Boolean)this.method_5841().method_12789(CONVERTING);
    }

    private void setConverting(@Nullable UUID uuid, int delay) {
        this.converter = uuid;
        this.conversionTimer = delay;
        this.method_5841().method_12778(CONVERTING, (Object)true);
        this.method_6016(class_1294.field_5911);
        this.method_6092(new class_1293(class_1294.field_5910, delay, Math.min(this.method_73183().method_8407().method_5461() - 1, 0)));
        this.method_73183().method_8421((class_1297)this, (byte)16);
    }

    public void method_5711(byte status) {
        if (status == 16) {
            if (!this.method_5701()) {
                this.method_73183().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_CURE, this.method_5634(), 1.0f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.3f, false);
            }
        } else {
            super.method_5711(status);
        }
    }

    private void finishConversion(class_3218 world) {
        this.method_29243(class_1299.field_6077, class_10179.method_63607((class_1308)this, (boolean)false, (boolean)false), villager -> {
            class_1657 playerEntity;
            for (class_1304 equipmentSlot : this.method_60972(world, stack -> !class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51656))) {
                class_5630 stackReference = villager.method_32318(equipmentSlot.method_5927() + 300);
                stackReference.method_32332(this.method_6118(equipmentSlot));
            }
            villager.method_7195(this.method_7231());
            if (this.gossip != null) {
                villager.method_21650(this.gossip);
            }
            if (this.offerData != null) {
                villager.method_16917(this.offerData.method_53882());
            }
            villager.method_19625(this.experience);
            villager.method_5943((class_5425)world, world.method_8404(villager.method_24515()), class_3730.field_16468, null);
            villager.method_19179(world);
            if (this.converter != null && (playerEntity = world.method_18470(this.converter)) instanceof class_3222) {
                class_174.field_1210.method_8831((class_3222)playerEntity, (class_1642)this, villager);
                world.method_19496(class_4151.field_18474, (class_1297)playerEntity, (class_4094)villager);
            }
            villager.method_6092(new class_1293(class_1294.field_5916, 200, 0));
            if (!this.method_5701()) {
                world.method_8444(null, 1027, this.method_24515(), 0);
            }
        });
    }

    private int getConversionRate() {
        int i = 1;
        if (this.field_5974.method_43057() < 0.01f) {
            int j = 0;
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int k = (int)this.method_23317() - 4; k < (int)this.method_23317() + 4 && j < 14; ++k) {
                for (int l = (int)this.method_23318() - 4; l < (int)this.method_23318() + 4 && j < 14; ++l) {
                    for (int m = (int)this.method_23321() - 4; m < (int)this.method_23321() + 4 && j < 14; ++m) {
                        class_2680 blockState = this.method_73183().method_8320((class_2338)mutable.method_10103(k, l, m));
                        if (!blockState.method_27852(class_2246.field_10576) && !(blockState.method_26204() instanceof class_2244)) continue;
                        if (this.field_5974.method_43057() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public float method_6017() {
        return this.method_6109() ? (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 2.0f : (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f;
    }

    public class_3414 method_5994() {
        return this.method_5799() ? ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_AMBIENT_WATER : ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_AMBIENT;
    }

    public class_3414 method_6011(class_1282 source) {
        return this.method_5799() ? ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_HURT_WATER : ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_HURT;
    }

    public class_3414 method_6002() {
        return this.method_5799() ? ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_DEATH_WATER : ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_DEATH;
    }

    public class_3414 method_7207() {
        return ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_STEP;
    }

    public class_3414 method_5737() {
        return ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_SWIM;
    }

    public void setOfferData(@Nullable class_1916 offerData) {
        this.offerData = offerData;
    }

    public void setGossip(@Nullable class_4136 gossip) {
        this.gossip = gossip;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 itemStack = this.method_6047();
        class_1799 itemStack2 = itemStack.method_31574(class_1802.field_8547) ? itemStack : new class_1799((class_1935)class_1802.field_8547);
        class_1685 tridentEntity = new class_1685(this.method_73183(), (class_1309)this, itemStack2);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - tridentEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f);
        class_1937 var15 = this.method_73183();
        if (var15 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var15;
            class_1676.method_61552((class_1676)tridentEntity, (class_3218)serverWorld, (class_1799)itemStack2, (double)d, (double)(e + g * 0.2), (double)f, (float)1.6f, (float)(14 - this.method_73183().method_8407().method_5461() * 4));
        }
        this.method_5783(ZombieVillagerVariants.ENTITY_DROWNED_VILLAGER_SHOOT, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
    }

    public void method_7195(class_3850 villagerData) {
        class_3850 villagerData2 = this.method_7231();
        if (!villagerData2.comp_3521().equals((Object)villagerData.comp_3521())) {
            this.offerData = null;
        }
        this.field_6011.method_12778(VILLAGER_DATA, (Object)villagerData);
    }

    public class_3850 method_7231() {
        return (class_3850)this.field_6011.method_12789(VILLAGER_DATA);
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> type) {
        return (T)(type == class_9334.field_56145 ? DrownedVillagerEntity.method_66651(type, (Object)this.method_7231().comp_3520()) : super.method_58694(type));
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, class_9334.field_56145);
        super.method_66649(from);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (type == class_9334.field_56145) {
            class_6880 registryEntry = (class_6880)DrownedVillagerEntity.method_66651((class_9331)class_9334.field_56145, value);
            this.method_7195(this.method_7231().method_16922(registryEntry));
            return true;
        }
        return super.method_66654(type, value);
    }

    public boolean method_63654(class_3218 world, class_1646 villager) {
        DrownedVillagerEntity zombieVillagerEntity = (DrownedVillagerEntity)villager.method_29243(ZombieVillagerVariants.DROWNED_VILLAGER, class_10179.method_63607((class_1308)villager, (boolean)true, (boolean)true), zombieVillager -> {
            zombieVillager.method_5943((class_5425)world, world.method_8404(zombieVillager.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true));
            zombieVillager.method_7195(villager.method_7231());
            zombieVillager.setGossip(villager.method_21651().method_67658());
            zombieVillager.setOfferData(villager.method_8264().method_53882());
            zombieVillager.setExperience(villager.method_19269());
            if (!this.method_5701()) {
                world.method_8444(null, 1026, this.method_24515(), 0);
            }
        });
        return zombieVillagerEntity != null;
    }
}

