/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.pvptoggle;

import com.lukeonuke.pvptoggle.PVPStatusCommand;
import com.lukeonuke.pvptoggle.PvpCommand;
import com.lukeonuke.pvptoggle.event.OnDamageListener;
import com.lukeonuke.pvptoggle.event.OnPlayerDeathListener;
import com.lukeonuke.pvptoggle.event.OnPlayerJoin;
import com.lukeonuke.pvptoggle.event.OnPlayerQuit;
import com.lukeonuke.pvptoggle.service.ConfigurationService;
import com.lukeonuke.pvptoggle.service.PlaceholderExpansionService;
import com.lukeonuke.pvptoggle.service.PvpService;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PvpToggle
extends JavaPlugin {
    public static Plugin plugin = null;

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.load();
        Objects.requireNonNull(this.getCommand("pvp")).setExecutor((CommandExecutor)new PvpCommand());
        Objects.requireNonNull(this.getCommand("pvpstatus")).setExecutor((CommandExecutor)new PVPStatusCommand());
        Bukkit.getPluginManager().registerEvents((Listener)new OnDamageListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerDeathListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerQuit(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerJoin(), (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderExpansionService().register();
        }
        plugin.getLogger().info("PVPToggle has been registered. o/");
    }

    public void onDisable() {
        PvpService.shutdown();
    }

    public void reload() {
        this.reloadConfig();
        this.load();
        plugin.getLogger().info("PVPToggle has been reloaded.");
    }

    private void load() {
        ConfigurationService cs = ConfigurationService.getInstance();
        cs.load();
    }

    public static Plugin getPlugin() {
        return plugin;
    }
}

