/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.pvptoggle.service;

import com.lukeonuke.pvptoggle.PvpToggle;
import com.lukeonuke.pvptoggle.service.ChatFormatterService;
import com.lukeonuke.pvptoggle.service.ConfigurationService;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class PvpService {
    private static final NamespacedKey isPvpEnabledKey = new NamespacedKey(PvpToggle.getPlugin(), "isPvpEnabled");
    private static final NamespacedKey pvpToggledTimestampKey = new NamespacedKey(PvpToggle.getPlugin(), "pvpToggledTimestamp");
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final ConcurrentHashMap<Player, ScheduledFuture<?>> activeTasks = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> expirationTimes = new ConcurrentHashMap();

    public static boolean isPvpEnabled(@NotNull Player player) {
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        return Boolean.TRUE.equals(dataContainer.get(isPvpEnabledKey, PersistentDataType.BOOLEAN));
    }

    public static void setPvpEnabled(Player player, boolean enabled) {
        ConfigurationService configurationService = ConfigurationService.getInstance();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        dataContainer.set(isPvpEnabledKey, PersistentDataType.BOOLEAN, (Object)enabled);
        dataContainer.set(pvpToggledTimestampKey, PersistentDataType.LONG, (Object)Instant.now().toEpochMilli());
        if (configurationService.getLimitedTime() < 0) {
            return;
        }
        if (enabled) {
            ScheduledFuture<?> existingTask = activeTasks.remove(player);
            if (existingTask != null) {
                existingTask.cancel(false);
            }
        } else {
            ScheduledFuture<?> existingTask = activeTasks.get(player);
            if (existingTask != null) {
                existingTask.cancel(false);
            }
            Runnable task = () -> {
                if (player.isOnline()) {
                    PvpService.setPvpEnabled(player, true);
                    if (!configurationService.getLimitedMessage().isEmpty()) {
                        player.sendMessage(ChatFormatterService.addPrefix(configurationService.getLimitedMessage().replace("%s", ChatFormatterService.booleanHumanReadable(false))));
                    }
                } else {
                    PvpService.resetPvpStatus(player);
                }
            };
            ScheduledFuture<?> scheduledTask = scheduler.schedule(task, (long)configurationService.getLimitedTime().intValue(), TimeUnit.SECONDS);
            activeTasks.put(player, scheduledTask);
        }
    }

    public static void handlePlayerLeave(Player player) {
        ConfigurationService configurationService = ConfigurationService.getInstance();
        ScheduledFuture<?> existingTask = activeTasks.remove(player);
        if (existingTask != null) {
            existingTask.cancel(false);
        }
        expirationTimes.put(player.getUniqueId().toString(), System.currentTimeMillis() + (long)(configurationService.getLimitedTime() * 1000));
    }

    public static void handlePlayerJoin(Player player) {
        ConfigurationService configurationService = ConfigurationService.getInstance();
        String uuid = player.getUniqueId().toString();
        Long expirationTime = expirationTimes.get(uuid);
        if (configurationService.getLimitedTime() < 0) {
            return;
        }
        if (expirationTime != null) {
            if (System.currentTimeMillis() > expirationTime) {
                PvpService.setPvpEnabled(player, true);
                if (!configurationService.getLimitedMessage().isEmpty()) {
                    player.sendMessage(ChatFormatterService.addPrefix(configurationService.getLimitedMessage().replace("%s", ChatFormatterService.booleanHumanReadable(false))));
                }
            } else {
                PvpService.setPvpEnabled(player, false);
            }
        } else {
            PvpService.resetPvpStatus(player);
        }
    }

    private static void resetPvpStatus(Player player) {
        ConfigurationService configurationService = ConfigurationService.getInstance();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        dataContainer.set(isPvpEnabledKey, PersistentDataType.BOOLEAN, (Object)configurationService.getDefaultPvp());
    }

    public static void setPvpCooldownTimestamp(Player player) {
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        dataContainer.set(pvpToggledTimestampKey, PersistentDataType.LONG, (Object)Instant.now().toEpochMilli());
    }

    public static Instant getPvpCooldownTimestamp(Player player) {
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (!dataContainer.has(pvpToggledTimestampKey, PersistentDataType.LONG)) {
            dataContainer.set(pvpToggledTimestampKey, PersistentDataType.LONG, (Object)0L);
        }
        return Instant.ofEpochMilli(Objects.requireNonNull((Long)dataContainer.get(pvpToggledTimestampKey, PersistentDataType.LONG)));
    }

    public static boolean isPvpCooldownDone(Player player) {
        if (player.hasPermission("pvptoggle.nocooldown")) {
            return true;
        }
        ConfigurationService configurationService = ConfigurationService.getInstance();
        return Instant.now().isAfter(Instant.ofEpochMilli(PvpService.getPvpCooldownTimestamp(player).toEpochMilli() + (long)(configurationService.getCooldownDuration() * 1000)));
    }

    public static void shutdown() {
        scheduler.shutdown();
        activeTasks.clear();
        expirationTimes.clear();
    }
}

