/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.pvptoggle.event;

import com.lukeonuke.pvptoggle.service.ChatFormatterService;
import com.lukeonuke.pvptoggle.service.ConfigurationService;
import com.lukeonuke.pvptoggle.service.PvpService;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.jetbrains.annotations.NotNull;

public class OnDamageListener
implements Listener {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        Tameable tamableAttacker;
        Entity actionBarMessage;
        Entity shooter;
        Projectile projectile;
        Entity entity;
        Player player;
        Entity entity2 = event.getEntity();
        Player damager = null;
        Tameable pet = null;
        ConfigurationService cs = ConfigurationService.getInstance();
        if (entity2 instanceof Tameable) {
            pet = (Tameable)entity2;
            if (!(pet.getOwner() instanceof Player)) return;
            player = (Player)pet.getOwner();
        } else {
            if (!(entity2 instanceof Player)) {
                return;
            }
            player = (Player)entity2;
        }
        if (cs.getDisabledWorlds().contains(player.getWorld().getName())) {
            return;
        }
        Entity entity3 = event.getDamager();
        if (entity3 instanceof Player) {
            Player damagerLocal = (Player)entity3;
            damager = damagerLocal;
            if (damager.hasPermission("pvptoggle.bypass")) {
                return;
            }
            if (!PvpService.isPvpEnabled(damager) || !PvpService.isPvpEnabled(player)) {
                event.setCancelled(true);
            }
            if (pet != null && !cs.getFriendlyFire().booleanValue() && damager.equals((Object)player)) {
                event.setCancelled(true);
            }
        }
        if ((entity = event.getDamager()) instanceof Projectile && (entity = (projectile = (Projectile)entity).getShooter()) instanceof Player) {
            shooter = (Player)entity;
            damager = shooter;
            if (pet != null && !cs.getFriendlyFire().booleanValue() && damager.equals((Object)player)) {
                event.setCancelled(true);
            }
            if (!((damager == player || event.getDamageSource().getCausingEntity() == player) && cs.getHitSelf().booleanValue() || PvpService.isPvpEnabled(player) && PvpService.isPvpEnabled(damager))) {
                event.setCancelled(true);
            }
        }
        if ((shooter = event.getDamageSource().getCausingEntity()) instanceof Player) {
            Player cause = (Player)shooter;
            if (!((damager == player || event.getDamageSource().getCausingEntity() == player) && cs.getHitSelf().booleanValue() || PvpService.isPvpEnabled(player) && PvpService.isPvpEnabled(cause))) {
                event.setCancelled(true);
                if (cs.getSpawnParticles().booleanValue()) {
                    cause.spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, ((LivingEntity)Objects.requireNonNullElse(pet, player)).getLocation(), 10);
                }
                if (cs.getSendFeedback().booleanValue()) {
                    actionBarMessage = OnDamageListener.getActionBarMessage(pet, player, cause);
                    cause.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)actionBarMessage);
                }
                if (event.isCancelled() || !cs.getAntiAbuse().booleanValue()) return;
                PvpService.setPvpCooldownTimestamp(player);
                return;
            }
            if (!(pet == null || cs.getFriendlyFire().booleanValue() || damager != player && event.getDamageSource().getCausingEntity() != player)) {
                event.setCancelled(true);
                if (cs.getSpawnParticles().booleanValue()) {
                    cause.spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, pet.getLocation(), 10);
                }
                if (cs.getSendFeedback().booleanValue()) {
                    actionBarMessage = OnDamageListener.getActionBarMessage(pet, player, cause);
                    cause.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)actionBarMessage);
                }
                if (event.isCancelled() || !cs.getAntiAbuse().booleanValue()) return;
                PvpService.setPvpCooldownTimestamp(player);
                return;
            }
        }
        if ((actionBarMessage = event.getDamager()) instanceof Tameable && (entity = (tamableAttacker = (Tameable)actionBarMessage).getOwner()) instanceof Player) {
            Player attackerOwner = (Player)entity;
            if (!PvpService.isPvpEnabled(player) || !PvpService.isPvpEnabled(attackerOwner)) {
                event.setCancelled(true);
                if (tamableAttacker instanceof Wolf) {
                    Wolf wolf = (Wolf)tamableAttacker;
                    wolf.setAngry(false);
                }
            }
        }
        if (event.isCancelled() && damager != null) {
            if (cs.getSpawnParticles().booleanValue()) {
                damager.spawnParticle(Particle.CAMPFIRE_COSY_SMOKE, ((LivingEntity)Objects.requireNonNullElse(pet, player)).getLocation(), 10);
            }
            if (cs.getSendFeedback().booleanValue()) {
                TextComponent actionBarMessage2 = OnDamageListener.getActionBarMessage(pet, player, damager);
                damager.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)actionBarMessage2);
            }
        }
        if (event.isCancelled() || !cs.getAntiAbuse().booleanValue()) return;
        PvpService.setPvpCooldownTimestamp(player);
    }

    @NotNull
    private static TextComponent getActionBarMessage(Tameable pet, Player player, Player damager) {
        ConfigurationService cs = ConfigurationService.getInstance();
        String message = pet != null ? (damager.equals((Object)player) ? ChatFormatterService.addPrefix(cs.getFfMessage()) : ChatFormatterService.addPrefix(cs.getPetPvpMessage().replace("%s", player.getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%r", pet.getName()))) : ChatFormatterService.addPrefix(cs.getFeedbackMessage().replace("%s", player.getDisplayName() + String.valueOf(ChatColor.RESET)));
        return new TextComponent(message);
    }
}

