/*
 * Decompiled with CFR 0.152.
 */
package com.lukeonuke.pvptoggle.service;

import com.lukeonuke.pvptoggle.PvpToggle;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigurationService {
    private static ConfigurationService instance = null;
    private Boolean defaultPvp;
    private Integer limitedTime;
    private String limitedMessage;
    private Integer cooldownDuration;
    private String cooldownMessage;
    private String toggleMessage;
    private String consoleMessage;
    private String reloadMessage;
    private String permissionMessage;
    private String notFoundMessage;
    private String remoteToggleMessage;
    private String feedbackMessage;
    private Boolean antiAbuse;
    private Boolean sendFeedback;
    private Boolean hitSelf;
    private Boolean spawnParticles;
    private Boolean protectPets;
    private Boolean friendlyFire;
    private String petPvpMessage;
    private String ffMessage;
    private Boolean deathStatusReset;
    private Boolean deathStatus;
    private Integer deathCooldown;
    private String deathMessage;
    private String prefix;
    private String enabled;
    private String disabled;
    private List<String> disabledWorlds;
    private String pvpStatusMessage;

    private ConfigurationService() {
    }

    public static ConfigurationService getInstance() {
        if (instance == null) {
            instance = new ConfigurationService();
        }
        return instance;
    }

    public void load() {
        Plugin plugin = PvpToggle.getPlugin();
        FileConfiguration config = plugin.getConfig();
        this.antiAbuse = config.getBoolean("anti-abuse", true);
        this.consoleMessage = config.getString("console-message", "\u00a7cYou can't use this command from the console.");
        this.cooldownDuration = config.getInt("cooldown", 120);
        this.cooldownMessage = config.getString("cooldown-message", "%s of cooldown remaining.");
        this.deathCooldown = config.getInt("death-cooldown", -1);
        this.deathMessage = config.getString("death-message", "You are now %s");
        this.deathStatus = config.getBoolean("death-status", false);
        this.deathStatusReset = config.getBoolean("death-status-reset", true);
        this.defaultPvp = config.getBoolean("default-pvp", false);
        this.disabled = config.getString("disabled", "\u00a7aProtected");
        this.enabled = config.getString("enabled", "\u00a7cVulnerable");
        this.feedbackMessage = plugin.getConfig().getString("pvp-off-message", "You can't fight %s!");
        this.ffMessage = config.getString("ff-message", "Friendly fire!");
        this.friendlyFire = config.getBoolean("friendly-fire", false);
        this.hitSelf = config.getBoolean("hit-self", true);
        this.limitedMessage = config.getString("limited-message", "You are now %s");
        this.limitedTime = config.getInt("limited-time", -1);
        this.notFoundMessage = config.getString("not-found-message", "%s isn't online.");
        this.permissionMessage = config.getString("permission-message", "You don't have permission to use this command.");
        this.petPvpMessage = config.getString("pet-pvp-message", "You can't fight %s's %r!");
        this.prefix = config.getString("prefix", "\u00a74PVP \u00bb");
        this.protectPets = config.getBoolean("protect-pets", true);
        this.reloadMessage = config.getString("reload-message", "Reloaded!");
        this.remoteToggleMessage = config.getString("remote-toggle-message", "%s is now %r");
        this.sendFeedback = config.getBoolean("feedback", false);
        this.spawnParticles = config.getBoolean("particles", false);
        this.toggleMessage = config.getString("toggle-message", "You are now %s");
        this.disabledWorlds = config.getStringList("disabled-worlds");
        this.pvpStatusMessage = config.getString("pvp-status-message", "Status of %s is now %s");
    }

    public Boolean getDefaultPvp() {
        return this.defaultPvp;
    }

    public Integer getLimitedTime() {
        return this.limitedTime;
    }

    public String getLimitedMessage() {
        return this.limitedMessage;
    }

    public Integer getCooldownDuration() {
        return this.cooldownDuration;
    }

    public String getCooldownMessage() {
        return this.cooldownMessage;
    }

    public String getToggleMessage() {
        return this.toggleMessage;
    }

    public String getConsoleMessage() {
        return this.consoleMessage;
    }

    public String getReloadMessage() {
        return this.reloadMessage;
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public String getNotFoundMessage() {
        return this.notFoundMessage;
    }

    public String getRemoteToggleMessage() {
        return this.remoteToggleMessage;
    }

    public String getFeedbackMessage() {
        return this.feedbackMessage;
    }

    public Boolean getAntiAbuse() {
        return this.antiAbuse;
    }

    public Boolean getSendFeedback() {
        return this.sendFeedback;
    }

    public Boolean getHitSelf() {
        return this.hitSelf;
    }

    public Boolean getSpawnParticles() {
        return this.spawnParticles;
    }

    public Boolean getProtectPets() {
        return this.protectPets;
    }

    public Boolean getFriendlyFire() {
        return this.friendlyFire;
    }

    public String getPetPvpMessage() {
        return this.petPvpMessage;
    }

    public String getFfMessage() {
        return this.ffMessage;
    }

    public Boolean getDeathStatusReset() {
        return this.deathStatusReset;
    }

    public Boolean getDeathStatus() {
        return this.deathStatus;
    }

    public Integer getDeathCooldown() {
        return this.deathCooldown;
    }

    public String getDeathMessage() {
        return this.deathMessage;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public String getPvpStatusMessage() {
        return this.pvpStatusMessage;
    }
}

