/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.immersive.Immersive;
import com.hammy275.immersivemc.api.client.immersive.ImmersiveInfo;
import com.hammy275.immersivemc.client.subscribe.ClientVRSubscriber;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class SwapTracker {
    public static final SwapTracker c0 = new SwapTracker(class_1268.field_5808);
    public static final SwapTracker c1 = new SwapTracker(class_1268.field_5810);
    protected final class_1268 hand;
    protected SwapState state = SwapState.NONE;
    protected int mostRecentHitbox = -1;
    protected int ticksInMostRecent = 0;
    protected LastImmersive<?> lastImmersive = null;
    protected final Set<Integer> queuedPlacements = new LinkedHashSet<Integer>();
    protected boolean leftClickWasDown = false;
    protected boolean lastTickWasIdle = false;
    protected int rightClickCooldown = 0;

    public static boolean slotHovered(ImmersiveInfo info, int slot) {
        return c0.hasSlotHovered(info, slot) || c1.hasSlotHovered(info, slot);
    }

    public SwapTracker(class_1268 hand) {
        this.hand = hand;
    }

    public void maybeIdleTick() {
        if (this.lastTickWasIdle) {
            this.tick(null, null, -1, false);
        }
        this.lastTickWasIdle = true;
    }

    public <I extends ImmersiveInfo> void tick(@Nullable Immersive<I, ?> immersive, @Nullable I info, int inputHitbox, boolean inDragHitbox) {
        this.lastTickWasIdle = false;
        this.ticksInMostRecent = this.mostRecentHitbox < 0 ? 0 : ++this.ticksInMostRecent;
        if (this.rightClickCooldown > 0) {
            --this.rightClickCooldown;
        }
        if (this.state == SwapState.NONE && inputHitbox >= 0) {
            if (class_310.method_1551().field_1690.field_1886.method_1434()) {
                this.setState(SwapState.DRAG, inputHitbox);
            } else {
                this.setState(SwapState.PLACE, inputHitbox);
            }
        } else if (!inDragHitbox) {
            this.setState(SwapState.NONE, -1);
        } else if (this.state != SwapState.DRAG && class_310.method_1551().field_1690.field_1886.method_1434()) {
            this.setState(SwapState.DRAG, inputHitbox);
        } else if (this.state == SwapState.PLACE && inDragHitbox && inputHitbox != this.mostRecentHitbox) {
            this.setState(SwapState.DRAG, inputHitbox);
        } else if (this.state == SwapState.DRAG && this.ticksInMostRecent >= 8 && this.mostRecentHitbox == inputHitbox) {
            this.setState(SwapState.PLACE, inputHitbox);
        } else if (this.state == SwapState.DRAG && !class_310.method_1551().field_1690.field_1886.method_1434() && this.leftClickWasDown) {
            this.setState(SwapState.PLACE, inputHitbox);
        }
        if (immersive != null && info != null) {
            LastImmersive<I> newLI = new LastImmersive<I>(immersive, info);
            if (!newLI.equals(this.lastImmersive)) {
                this.maybeDoDragPlace();
            }
            this.lastImmersive = newLI;
        }
        if (this.state == SwapState.PLACE) {
            this.rightClickCooldown = this.lastImmersive.doHitboxInteract(List.of(Integer.valueOf(inputHitbox)), this.hand, this.getCooldownToPass(), class_310.method_1551().field_1690.field_1886.method_1434());
        } else if (this.state == SwapState.DRAG && inputHitbox >= 0) {
            this.queuedPlacements.add(inputHitbox);
        }
        if (this.state == SwapState.DRAG) {
            this.rightClickCooldown = Math.max(1, this.rightClickCooldown);
        }
    }

    public void setCooldown(int newCooldown) {
        newCooldown = newCooldown == 0 ? 1 : newCooldown;
        this.rightClickCooldown = Math.max(newCooldown, this.rightClickCooldown);
    }

    public int getCooldown() {
        return this.rightClickCooldown;
    }

    protected boolean hasSlotHovered(ImmersiveInfo info, int slot) {
        return this.lastImmersive != null && this.lastImmersive.info == info && this.queuedPlacements.contains(slot);
    }

    protected void setState(SwapState newState, int newHitbox) {
        if (newHitbox != this.mostRecentHitbox) {
            this.ticksInMostRecent = 0;
        }
        if (newState != SwapState.DRAG) {
            this.maybeDoDragPlace();
            this.leftClickWasDown = false;
        } else {
            boolean bl = this.leftClickWasDown = this.leftClickWasDown || class_310.method_1551().field_1690.field_1886.method_1434();
        }
        if (newState == SwapState.NONE) {
            this.lastImmersive = null;
        }
        this.state = newState;
        this.mostRecentHitbox = newHitbox;
    }

    protected void maybeDoDragPlace() {
        if (this.state == SwapState.DRAG && !this.queuedPlacements.isEmpty()) {
            this.rightClickCooldown = this.lastImmersive.doHitboxInteract(this.queuedPlacements.stream().toList(), this.hand, 0, this.leftClickWasDown);
            this.ticksInMostRecent = 0;
            this.queuedPlacements.clear();
        }
    }

    protected int getCooldownToPass() {
        return VRPluginVerify.clientInVR() && !ActiveConfig.active().rightClickImmersiveInteractionsInVR ? ClientVRSubscriber.getCooldown() : this.rightClickCooldown;
    }

    protected static enum SwapState {
        NONE,
        PLACE,
        DRAG;

    }

    protected record LastImmersive<I extends ImmersiveInfo>(Immersive<I, ?> immersive, I info) {
        public int doHitboxInteract(List<Integer> slots, class_1268 hand, int currentCooldown, boolean leftClickDown) {
            if (currentCooldown <= 0) {
                int cooldown = this.immersive.handleHitboxInteract(this.info, class_310.method_1551().field_1724, slots, hand, leftClickDown);
                ImmersiveClientLogicHelpers.instance().setCooldown(cooldown);
                return cooldown;
            }
            return currentCooldown;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof LastImmersive) {
                LastImmersive other = (LastImmersive)obj;
                return this.immersive == other.immersive && this.info == other.info;
            }
            return false;
        }
    }
}

