/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive_item;

import com.hammy275.immersivemc.Platform;
import com.hammy275.immersivemc.client.immersive_item.info.AbstractHandImmersiveInfo;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import java.util.ArrayList;
import java.util.List;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public abstract class AbstractHandImmersive<I extends AbstractHandImmersiveInfo> {
    protected List<I> infos = new ArrayList<I>();

    protected abstract void render(I var1, class_4587 var2, IVRData var3);

    protected abstract void tick(I var1, IVRData var2, IVRData var3);

    public abstract boolean activeForHand(class_1268 var1);

    protected abstract I createInfo(class_1268 var1);

    public abstract boolean isEnabled();

    public abstract boolean onLeftClick(I var1, IVRData var2, IVRData var3);

    protected boolean handSwapCandidate(class_1268 newHand) {
        return false;
    }

    public boolean attemptLeftClickAll() {
        IVRPlayer player = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724);
        for (AbstractHandImmersiveInfo info : this.infos) {
            boolean handledClick = this.onLeftClick(info, player.getController(info.hand.ordinal()), player.getController(info.hand == class_1268.field_5808 ? 1 : 0));
            if (!handledClick) continue;
            return true;
        }
        return false;
    }

    public void registerAndTickAll() {
        if (!this.isEnabled()) {
            this.infos.clear();
            return;
        }
        ArrayList<AbstractHandImmersiveInfo> toRemove = new ArrayList<AbstractHandImmersiveInfo>();
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (!this.activeForHand(info.hand)) {
                class_1268 otherHand = Util.otherHand(info.hand);
                if (this.handSwapCandidate(otherHand)) {
                    info.hand = otherHand;
                } else {
                    info.shouldRemove = true;
                }
            }
            if (!info.shouldRemove) continue;
            toRemove.add(info);
        }
        this.infos.removeAll(toRemove);
        this.maybeRegister(class_1268.field_5808);
        this.maybeRegister(class_1268.field_5810);
        IVRPlayer player = VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724);
        for (AbstractHandImmersiveInfo info : this.infos) {
            this.tick(info, player.getController(info.hand.ordinal()), player.getController(info.hand == class_1268.field_5808 ? 1 : 0));
        }
    }

    public void renderAll(class_4587 poseStack) {
        IVRPlayer player = Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724) : VRPlugin.API.getRenderVRPlayer();
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (info.shouldRemove || !this.isEnabled()) continue;
            this.render(info, poseStack, player.getController(info.hand.ordinal()));
        }
    }

    private void maybeRegister(class_1268 hand) {
        for (AbstractHandImmersiveInfo info : this.infos) {
            if (info.hand != hand) continue;
            return;
        }
        if (this.activeForHand(hand)) {
            this.infos.add(this.createInfo(hand));
        }
    }
}

