/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.api_impl.hitbox;

import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.common.obb.OBBRotList;
import com.hammy275.immersivemc.common.obb.RotType;
import java.util.Optional;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class OBBImpl
implements BoundingBox,
OBB {
    private static final double HALFSQRT2 = Math.sqrt(2.0) / 2.0;
    final class_238 aabb;
    final class_243 center;
    final class_1160 centerF;
    final class_1158 rotation;

    public OBBImpl(class_238 aabb) {
        this(aabb, class_1158.field_21493);
    }

    public OBBImpl(class_238 aabb, double pitch, double yaw, double roll) {
        this(aabb, OBBRotList.create().addRot(yaw, RotType.YAW).addRot(pitch, RotType.PITCH).addRot(roll, RotType.ROLL).asQuaternion());
    }

    public OBBImpl(class_238 aabb, class_1158 rotation) {
        this.aabb = aabb;
        this.center = aabb.method_1005();
        this.centerF = this.toVector3f(this.center);
        this.rotation = rotation;
    }

    @Override
    public boolean contains(class_243 point) {
        class_1160 pt = this.toVector3f(point);
        pt.method_4944(this.centerF);
        pt.method_19262(this.rotation);
        pt.method_23846(this.centerF);
        return this.aabb.method_1006(this.toVec3(pt));
    }

    @Override
    public Optional<class_243> rayHit(class_243 rayStart, class_243 rayEnd) {
        class_243 dir = rayEnd.method_1020(rayStart).method_1029();
        double dist = rayStart.method_1022(rayEnd);
        class_1160 dirF = this.toVector3f(dir);
        dirF.method_19262(this.rotation);
        class_1160 rayStartF = this.toVector3f(rayStart);
        rayStartF.method_4944(this.centerF);
        rayStartF.method_19262(this.rotation);
        rayStartF.method_23846(this.centerF);
        class_243 start = this.toVec3(rayStartF);
        dirF.method_4942((float)dist);
        rayStartF.method_23846(dirF);
        Optional intersect = this.aabb.method_992(start, this.toVec3(rayStartF));
        if (intersect.isPresent()) {
            class_1160 intersectF = this.toVector3f((class_243)intersect.get());
            intersectF.method_4944(this.centerF);
            intersectF.method_19262(this.rotation);
            intersectF.method_23846(this.centerF);
            return Optional.of(this.toVec3(intersectF));
        }
        return Optional.empty();
    }

    @Override
    public class_238 getUnderlyingAABB() {
        return this.aabb;
    }

    @Override
    public class_243 getCenter() {
        return this.center;
    }

    @Override
    public class_1158 getRotation() {
        return new class_1158(this.rotation);
    }

    @Override
    public class_238 getEnclosingAABB() {
        double maxSize = Math.max(Math.max(this.aabb.method_17939(), this.aabb.method_17940()), this.aabb.method_17941());
        return this.aabb.method_1014(maxSize * HALFSQRT2);
    }

    @Override
    public OBB move(class_243 movement) {
        return new OBBImpl(this.aabb.method_997(movement), this.rotation);
    }

    @Override
    public OBBImpl asOBB() {
        return this;
    }

    @Override
    public class_238 asAABB() {
        throw new RuntimeException("Cannot get AABB as OBB!");
    }

    private class_243 toVec3(class_1160 vec3f) {
        return new class_243((double)vec3f.method_4943(), (double)vec3f.method_4945(), (double)vec3f.method_4947());
    }

    private class_1160 toVector3f(class_243 vec3) {
        return new class_1160((float)vec3.field_1352, (float)vec3.field_1351, (float)vec3.field_1350);
    }
}

