/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive;

import com.hammy275.immersivemc.api.common.hitbox.OBB;
import com.hammy275.immersivemc.api.common.hitbox.OBBFactory;
import com.hammy275.immersivemc.api.common.immersive.NetworkStorage;
import com.hammy275.immersivemc.common.util.PageChangeState;
import com.hammy275.immersivemc.common.util.PosRot;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;

public class CommonBookData
implements NetworkStorage {
    public static final float scaleSize = 1.0f;
    public static final double singlePageWidth = 0.3;
    public static final double pageHalfHeight = 0.25;
    public static final float textStackScaleSize = -0.0025f;
    public static final double textUpAmount = 0.09375;
    public static final double textInteractDistanceSqr = 0.012656249999999997;
    public static final float pageTilt = 11.0f;
    public static final int linesPerPage = 14;
    public static final int pixelsPerLine = 114;
    public static final double leftPageRot = Math.toRadians(15.0);
    public Consumer<CommonBookData> startVRPageTurnCallback = null;
    public Consumer<Integer> onSetPageCallback = null;
    protected int maxLeftPageIndex = 0;
    protected boolean isDirty = false;
    protected OBB[] pageTurnBoxes = new OBB[3];
    protected class_243[] pageTurnPositions = new class_243[3];
    public class_1657 pageTurner;
    protected int pageTurnerHandIndex = -1;
    public int leftPageIndex = 0;
    public float leftPageTurn = 0.0f;
    public float rightPageTurn = 1.0f;
    public PageChangeState pageChangeState = PageChangeState.NONE;

    public void tick(PosRot bookPosRot, PosRot ... others) {
        if (this.maxLeftPageIndex < 0) {
            return;
        }
        class_243 left = this.getLeftRightVector(bookPosRot, true);
        class_243 right = this.getLeftRightVector(bookPosRot, false);
        class_243 away = this.getAwayVector(bookPosRot);
        this.pageTurnPositions[2] = bookPosRot.position().method_1019(away.method_1021(0.09375));
        this.pageTurnPositions[0] = this.pageTurnPositions[2].method_1019(left.method_1021(0.375));
        this.pageTurnPositions[1] = this.pageTurnPositions[2].method_1019(right.method_1021(0.375));
        class_243 upCenter = this.pageTurnPositions[2].method_1019(away.method_1021(0.15));
        double pitch = Math.toRadians(bookPosRot.getPitch());
        double yaw = Math.toRadians(bookPosRot.getYaw());
        this.pageTurnBoxes[0] = OBBFactory.instance().create(class_238.method_30048((class_243)this.pageTurnPositions[0], (double)0.2, (double)0.2, (double)0.5), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        this.pageTurnBoxes[1] = OBBFactory.instance().create(class_238.method_30048((class_243)this.pageTurnPositions[1], (double)0.2, (double)0.2, (double)0.5), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        this.pageTurnBoxes[2] = OBBFactory.instance().create(class_238.method_30048((class_243)upCenter, (double)1.0999999999999999, (double)0.6, (double)0.5625), pitch, yaw, Math.toRadians(bookPosRot.getRoll()));
        if (this.pageChangeState == PageChangeState.LEFT_TO_RIGHT_ANIM) {
            this.leftPageTurn = Math.min(this.leftPageTurn + 0.05f, 1.0f);
            if (this.leftPageTurn == 1.0f) {
                this.resetTurnState();
                return;
            }
        } else if (this.pageChangeState == PageChangeState.RIGHT_TO_LEFT_ANIM) {
            this.rightPageTurn = Math.max(this.rightPageTurn - 0.05f, 0.0f);
            if (this.rightPageTurn == 0.0f) {
                this.resetTurnState();
                return;
            }
        }
        boolean someHandPageTurning = false;
        int start = this.pageTurnerHandIndex == -1 ? 0 : this.pageTurnerHandIndex;
        int end = this.pageTurnerHandIndex == -1 ? others.length : this.pageTurnerHandIndex + 1;
        for (int i = start; i < end; ++i) {
            PosRot other = others[i];
            if (this.pageChangeState == PageChangeState.NONE) {
                if (this.pageTurnBoxes[0].contains(other.position()) && !this.onFirstPage()) {
                    someHandPageTurning = true;
                    this.startVRPageTurn(PageChangeState.LEFT_TO_RIGHT, i);
                } else if (this.pageTurnBoxes[1].contains(other.position()) && !this.onLastPage()) {
                    someHandPageTurning = true;
                    this.startVRPageTurn(PageChangeState.RIGHT_TO_LEFT, i);
                }
            } else if (!this.pageChangeState.isAnim && this.pageTurnBoxes[2].contains(other.position())) {
                boolean doingLToR = this.pageChangeState == PageChangeState.LEFT_TO_RIGHT;
                double distToLeft = other.position().method_1022(this.pageTurnPositions[0]);
                double distToRight = other.position().method_1022(this.pageTurnPositions[1]);
                if (doingLToR && distToRight < distToLeft) {
                    this.pageChangeState = PageChangeState.LEFT_TO_RIGHT_ANIM;
                    this.lastPage();
                } else if (!doingLToR && distToLeft < distToRight) {
                    this.pageChangeState = PageChangeState.RIGHT_TO_LEFT_ANIM;
                    this.nextPage();
                } else if (doingLToR) {
                    this.leftPageTurn = (float)(distToLeft / (distToLeft + distToRight));
                    someHandPageTurning = true;
                    this.setDirty();
                } else {
                    this.rightPageTurn = 1.0f - (float)(distToRight / (distToLeft + distToRight));
                    someHandPageTurning = true;
                    this.setDirty();
                }
            }
            if (someHandPageTurning || this.pageChangeState.isAnim || this.pageChangeState == PageChangeState.NONE) continue;
            this.resetTurnState();
        }
    }

    public void nextPage() {
        this.setPage(this.leftPageIndex + 2);
    }

    public void lastPage() {
        this.setPage(this.leftPageIndex - 2);
    }

    public void setPage(int newPageIndex) {
        this.setPage(newPageIndex, true);
    }

    public void setPage(int newPageIndex, boolean runCallback) {
        if (newPageIndex % 2 != 0) {
            --newPageIndex;
        }
        if (newPageIndex > this.maxLeftPageIndex) {
            newPageIndex = this.maxLeftPageIndex;
        } else if (newPageIndex < 0) {
            newPageIndex = 0;
        }
        this.leftPageIndex = newPageIndex;
        this.setDirty();
        if (runCallback && this.onSetPageCallback != null) {
            this.onSetPageCallback.accept(this.leftPageIndex);
        }
    }

    public int getLeftPageIndex() {
        return this.leftPageIndex;
    }

    public void setMaxLeftPageIndex(int max) {
        if (max % 2 != 0) {
            --max;
        }
        this.maxLeftPageIndex = Math.max(max, 0);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void setNoLongerDirty() {
        this.isDirty = false;
    }

    public boolean onFirstPage() {
        return this.leftPageIndex == 0;
    }

    public boolean onLastPage() {
        return this.leftPageIndex == this.maxLeftPageIndex;
    }

    public void startNonVRPageTurnAnim(class_1657 pageTurner, boolean isNextPage) {
        this.pageTurner = pageTurner;
        this.pageChangeState = isNextPage ? PageChangeState.RIGHT_TO_LEFT_ANIM : PageChangeState.LEFT_TO_RIGHT_ANIM;
        this.pageTurnerHandIndex = -1;
        if (isNextPage) {
            this.nextPage();
        } else {
            this.lastPage();
        }
        this.setDirty();
    }

    public PageChangeState getPageChangeState() {
        return this.pageChangeState;
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeInt(this.leftPageIndex).writeFloat(this.leftPageTurn).writeFloat(this.rightPageTurn);
        buffer.method_10817((Enum)this.pageChangeState);
    }

    @Override
    public void decode(class_2540 buffer) {
        this.leftPageIndex = buffer.readInt();
        this.leftPageTurn = buffer.readFloat();
        this.rightPageTurn = buffer.readFloat();
        this.pageChangeState = (PageChangeState)buffer.method_10818(PageChangeState.class);
    }

    public void resetTurnState() {
        this.pageTurnerHandIndex = -1;
        this.leftPageTurn = 0.0f;
        this.rightPageTurn = 1.0f;
        this.pageChangeState = PageChangeState.NONE;
        this.pageTurner = null;
        this.setDirty();
    }

    protected void startVRPageTurn(PageChangeState state, int handIndex) {
        this.pageTurnerHandIndex = handIndex;
        this.pageChangeState = state;
        this.setDirty();
        if (this.startVRPageTurnCallback != null) {
            this.startVRPageTurnCallback.accept(this);
        }
    }

    public class_243 getLeftRightVector(PosRot bookPosRot, boolean left) {
        class_1160 leftF = new class_1160(0.0f, 0.0f, 1.0f);
        leftF.method_19262(class_1160.field_20704.method_23214(left ? 270.0f : 90.0f));
        leftF.method_19262(class_1160.field_20707.method_23214(bookPosRot.getRoll()));
        leftF.method_19262(class_1160.field_20702.method_23214(bookPosRot.getPitch()));
        leftF.method_19262(class_1160.field_20704.method_23214(bookPosRot.getYaw()));
        return new class_243((double)leftF.method_4943(), (double)leftF.method_4945(), (double)leftF.method_4947());
    }

    public class_243 getAwayVector(PosRot hand) {
        class_1160 awayFromBookF = new class_1160(0.0f, 1.0f, 0.0f);
        awayFromBookF.method_19262(class_1160.field_20707.method_23214(hand.getRoll()));
        awayFromBookF.method_19262(class_1160.field_20702.method_23214(hand.getPitch()));
        awayFromBookF.method_19262(class_1160.field_20704.method_23214(hand.getYaw()));
        return new class_243((double)awayFromBookF.method_4943(), (double)awayFromBookF.method_4945(), (double)awayFromBookF.method_4947());
    }
}

