/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.immersive.handler;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ItemWorldStorageHandler;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.CraftingTableStorage;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.ItemStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.server.storage.server.ItemSwapAmount;
import com.hammy275.immersivemc.server.storage.world.WorldStorage;
import com.hammy275.immersivemc.server.storage.world.WorldStoragesImpl;
import com.hammy275.immersivemc.server.swap.Swap;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2304;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3712;
import net.minecraft.class_3717;

public class CraftingHandler
extends ItemWorldStorageHandler<CraftingTableStorage> {
    @Override
    public CraftingTableStorage makeInventoryContents(class_3222 player, class_2338 pos) {
        return (CraftingTableStorage)WorldStoragesImpl.getOrCreateS(pos, player.method_14220());
    }

    @Override
    public CraftingTableStorage getEmptyNetworkStorage() {
        return new CraftingTableStorage();
    }

    @Override
    public void swap(int slot, class_1268 hand, class_2338 pos, class_3222 player, ItemSwapAmount amount) {
        CraftingTableStorage storage = (CraftingTableStorage)WorldStoragesImpl.getOrCreateS(pos, player.method_14220());
        if (slot < 9) {
            storage.placeItem((class_1657)player, hand, slot, amount);
            storage.setItem(9, Swap.getRecipeOutput(player, storage.getItemsRaw()));
        } else {
            class_1799[] newSlots = Swap.handleDoCraft(player, storage.getItemsRaw(), pos, amount);
            if (newSlots == null) {
                return;
            }
            for (int i = 0; i <= 8; ++i) {
                class_1799 storageItem = storage.getItem(i);
                if (storageItem.method_7960()) continue;
                if (Util.stacksEqualBesidesCount(storageItem, newSlots[i])) {
                    int diff = storageItem.method_7947() - newSlots[i].method_7947();
                    storage.shrinkSlot(i, diff);
                    continue;
                }
                storage.setItem(i, newSlots[i], (class_1657)player);
            }
            storage.setItem(9, newSlots[9]);
        }
        storage.setDirty(player.method_14220());
    }

    @Override
    public boolean isValidBlock(class_2338 pos, class_1937 level) {
        class_2248 block = level.method_8320(pos).method_26204();
        return CraftingHandler.isCraftingTableBlock(block) && level.method_8321(pos) == null;
    }

    @Override
    public boolean enabledInConfig(class_1657 player) {
        return ActiveConfig.getActiveConfigCommon((class_1657)player).useCraftingTableImmersive;
    }

    @Override
    public class_2960 getID() {
        return new class_2960("immersivemc", "crafting_table");
    }

    @Override
    public WorldStorage getEmptyWorldStorage() {
        return new CraftingTableStorage();
    }

    @Override
    public Class<? extends WorldStorage> getWorldStorageClass() {
        return CraftingTableStorage.class;
    }

    @Override
    public void updateStorageOutputAfterItemReturn(class_3222 player, class_2338 pos, ItemStorage storage) {
        class_1799 out = Swap.getRecipeOutput(player, storage.getItemsRaw());
        storage.setItem(9, out);
    }

    public static boolean isCraftingTableBlock(class_2248 block) {
        return block instanceof class_2304 && !(block instanceof class_3717) && !(block instanceof class_3712);
    }
}

