/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.network.packet;

import com.hammy275.immersivemc.common.immersive.CommonBookData;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.network.impl.LecternData;
import com.hammy275.immersivemc.common.network.NetworkUtil;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.storage.server.SharedNetworkStorages;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class PageTurnPacket {
    public final class_2338 pos;
    public final int forcedPageIndex;
    public final boolean clickedRight;

    public PageTurnPacket(class_2338 pos) {
        this(pos, -1);
    }

    public PageTurnPacket(class_2338 pos, int forcedPageIndex) {
        this(pos, forcedPageIndex, false);
    }

    public PageTurnPacket(class_2338 pos, boolean clickedRight) {
        this(pos, -1, clickedRight);
    }

    public PageTurnPacket(class_2338 pos, int forcedPageIndex, boolean clickedRight) {
        this.pos = pos;
        this.forcedPageIndex = forcedPageIndex;
        this.clickedRight = clickedRight;
    }

    public static void encode(PageTurnPacket packet, class_2540 buffer) {
        buffer.method_10807(packet.pos).writeInt(packet.forcedPageIndex).writeBoolean(packet.clickedRight);
    }

    public static PageTurnPacket decode(class_2540 buffer) {
        return new PageTurnPacket(buffer.method_10811(), buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(PageTurnPacket message, class_3222 player) {
        LecternData<CommonBookData> storage;
        if (NetworkUtil.safeToRun(message.pos, player) && (storage = SharedNetworkStorages.instance().get(player.field_6002, message.pos, ImmersiveHandlers.lecternHandler)) != null && !storage.book.method_7960() && ((CommonBookData)storage.bookData).pageTurner == null) {
            if (message.forcedPageIndex == -1) {
                if (!VRPluginVerify.playerInVR((class_1657)player) && (message.clickedRight ? !((CommonBookData)storage.bookData).onLastPage() : !((CommonBookData)storage.bookData).onFirstPage())) {
                    ((CommonBookData)storage.bookData).startNonVRPageTurnAnim((class_1657)player, message.clickedRight);
                } else if (VRPluginVerify.playerInVR((class_1657)player)) {
                    ((CommonBookData)storage.bookData).pageTurner = player;
                }
            } else {
                ((CommonBookData)storage.bookData).setPage(message.forcedPageIndex);
            }
        }
    }
}

