/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.common.util;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;

@JsonAdapter(value=RGBA.class)
public class RGBA
extends TypeAdapter<RGBA> {
    public int r;
    public int g;
    public int b;
    public int a;

    public RGBA(long argb) {
        argb = argb < 0L ? 0L : Math.min(argb, 0xFFFFFFFFL);
        this.a = (int)(argb >> 24);
        this.r = (int)(argb >> 16 & 0xFFL);
        this.g = (int)(argb >> 8 & 0xFFL);
        this.b = (int)(argb & 0xFFL);
    }

    public RGBA(int rgb, int a) {
        this.a = a & 0xFF;
        this.r = rgb >> 16 & 0xFF;
        this.g = rgb >> 8 & 0xFF;
        this.b = rgb & 0xFF;
    }

    public RGBA(int r, int g, int b, int a) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static RGBA random() {
        return new RGBA(ThreadLocalRandom.current().nextLong(0x100000000L));
    }

    public long toLong() {
        return ((long)this.a << 24) + ((long)this.r << 16) + ((long)this.g << 8) + (long)this.b;
    }

    public int getRGB() {
        return (this.r << 16) + (this.g << 8) + this.b;
    }

    public int getAlpha() {
        return this.a;
    }

    public float redF() {
        return (float)this.r / 255.0f;
    }

    public float greenF() {
        return (float)this.g / 255.0f;
    }

    public float blueF() {
        return (float)this.b / 255.0f;
    }

    public float alphaF() {
        return (float)this.a / 255.0f;
    }

    public int getColor(char c) {
        return switch (c) {
            case 'r' -> this.r;
            case 'g' -> this.g;
            case 'b' -> this.b;
            case 'a' -> this.a;
            default -> throw new IllegalArgumentException("Only pass 'r', 'g', 'b', or 'a'!");
        };
    }

    public void setColor(char c, int val) {
        switch (c) {
            case 'r': {
                this.r = val;
                break;
            }
            case 'g': {
                this.g = val;
                break;
            }
            case 'b': {
                this.b = val;
                break;
            }
            case 'a': {
                this.a = val;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only pass 'r', 'g', 'b', or 'a'!");
            }
        }
    }

    public String toString() {
        return "R: %d\tG: %d\tB: %d\ta: %d".formatted(this.r, this.g, this.b, this.a);
    }

    public void write(JsonWriter out, RGBA value) throws IOException {
        out.value(value.toLong());
    }

    public RGBA read(JsonReader in) throws IOException {
        return new RGBA(in.nextLong());
    }
}

