/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.server.tracker.vrhand;

import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.mixin.AbstractCauldronBlockAccessor;
import com.hammy275.immersivemc.mixin.BucketItemAccessor;
import com.hammy275.immersivemc.server.data.LastTickData;
import com.hammy275.immersivemc.server.tracker.vrhand.AbstractVRHandTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1754;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_5620;
import net.minecraft.class_5634;

public class CauldronTracker
extends AbstractVRHandTracker {
    private Map<UUID, Integer> cooldown = new HashMap<UUID, Integer>();

    @Override
    public void preTick(class_1657 player) {
        super.preTick(player);
        int newCooldown = this.cooldown.getOrDefault(player.method_5667(), 0) - 1;
        if (newCooldown <= 0) {
            this.cooldown.remove(player.method_5667());
        } else {
            this.cooldown.put(player.method_5667(), newCooldown);
        }
    }

    @Override
    protected boolean shouldRunForHand(class_1657 player, class_1268 hand, class_1799 stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        if (this.cooldown.getOrDefault(player.method_5667(), 0) > 0) {
            return false;
        }
        IVRData data = currentVRData.getController(hand.ordinal());
        return player.field_6002.method_8320(new class_2338(data.position())).method_26204() instanceof class_2275 || player.field_6002.method_8320(new class_2338(data.position()).method_10074()).method_26204() instanceof class_2275 && player.field_6002.method_8320(new class_2338(data.position())).method_26215();
    }

    @Override
    protected void runForHand(class_1657 player, class_1268 hand, class_1799 stackInHand, IVRPlayer currentVRData, LastTickData lastVRData) {
        class_1755 bucketItem;
        class_1755 bucketItem2;
        IVRData data = currentVRData.getController(hand.ordinal());
        class_2680 handState = player.field_6002.method_8320(new class_2338(data.position()));
        class_2338 cauldronPos = handState.method_26204() instanceof class_2275 ? new class_2338(data.position()) : new class_2338(data.position()).method_10074();
        class_2680 cauldron = player.field_6002.method_8320(cauldronPos);
        class_2275 cauldronBlock = (class_2275)cauldron.method_26204();
        boolean inCauldronBlock = handState.method_26204() instanceof class_2275;
        class_1799 handStack = player.method_5998(hand);
        class_1792 handItem = handStack.method_7909();
        class_1842 heldPotion = class_1844.method_8063((class_1799)handStack);
        class_5620 interaction = ((AbstractCauldronBlockAccessor)cauldronBlock).immersiveMC$getInteractions().get(handItem);
        if (interaction == null) {
            return;
        }
        if (inCauldronBlock && (handItem instanceof class_1754 || handItem instanceof class_1755 && ((BucketItemAccessor)(bucketItem2 = (class_1755)handItem)).immersiveMC$getFluid().method_15780(class_3612.field_15906))) {
            if (Math.abs(data.getRoll()) < 90.0f) {
                this.possiblySetCooldown(player, interaction.interact(cauldron, player.field_6002, cauldronPos, player, hand, handStack));
            }
        } else if (handItem instanceof class_1812 && heldPotion == class_1847.field_8991 || handItem instanceof class_1755 && !((BucketItemAccessor)(bucketItem = (class_1755)handItem)).immersiveMC$getFluid().method_15780(class_3612.field_15906) || handItem instanceof class_5634) {
            if (Math.abs(data.getRoll()) > 160.0f) {
                this.possiblySetCooldown(player, interaction.interact(cauldron, player.field_6002, cauldronPos, player, hand, handStack));
            }
        } else if (inCauldronBlock) {
            this.possiblySetCooldown(player, interaction.interact(cauldron, player.field_6002, cauldronPos, player, hand, handStack));
        }
    }

    @Override
    public boolean isEnabledInConfig(ActiveConfig config) {
        return config.useCauldronImmersive;
    }

    private void possiblySetCooldown(class_1657 player, class_1269 res) {
        if (res.method_23665()) {
            this.cooldown.put(player.method_5667(), 5);
        }
    }
}

