/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.api.client.ImmersiveClientConstants;
import com.hammy275.immersivemc.api.client.ImmersiveClientLogicHelpers;
import com.hammy275.immersivemc.api.client.ImmersiveConfigScreenInfo;
import com.hammy275.immersivemc.api.client.ImmersiveRenderHelpers;
import com.hammy275.immersivemc.api.common.ImmersiveLogicHelpers;
import com.hammy275.immersivemc.api.common.hitbox.BoundingBox;
import com.hammy275.immersivemc.api.common.immersive.ImmersiveHandler;
import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.BeaconInfo;
import com.hammy275.immersivemc.client.immersive.info.HitboxItemPair;
import com.hammy275.immersivemc.client.immersive_item.HandImmersives;
import com.hammy275.immersivemc.client.immersive_item.info.HeldImageImmersiveInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.handler.ImmersiveHandlers;
import com.hammy275.immersivemc.common.immersive.storage.dual.impl.BeaconStorage;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.BeaconConfirmPacket;
import com.hammy275.immersivemc.common.network.packet.BeaconDataPacket;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.common.vr.VRRumble;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import java.time.Instant;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ImmersiveBeacon
extends AbstractImmersive<BeaconInfo, BeaconStorage> {
    private static final double effectHitboxSize = 0.2;
    private static final double displayHitboxSize = 0.2;
    private static final double effectCircleRadius = 0.2;
    private static final class_2960[] effectLocations = new class_2960[]{new class_2960("textures/mob_effect/speed.png"), new class_2960("textures/mob_effect/haste.png"), new class_2960("textures/mob_effect/resistance.png"), new class_2960("textures/mob_effect/jump_boost.png"), new class_2960("textures/mob_effect/strength.png")};
    private static final class_2960 regenerationLocation = new class_2960("textures/mob_effect/regeneration.png");
    private static final class_2960 confirmLocation = new class_2960("immersivemc", "confirm.png");
    private static final class_2960 addLocation = new class_2960("immersivemc", "add.png");

    @Override
    public BeaconInfo buildInfo(class_2338 pos, class_1937 level) {
        BeaconInfo info = new BeaconInfo(pos);
        info.startMillis = Instant.now().toEpochMilli();
        Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int handleHitboxInteract(BeaconInfo info, class_746 player, List<Integer> hitboxIndices, class_1268 hand, boolean modifierPressed) {
        class_2960 id = this.getHandler().getID();
        BiConsumer heldItemTicker = !ImmersiveBeacon.useGrabBeacon() ? null : (imageInfo, handData) -> {
            if (!Immersives.immersiveBeacon.getTrackedObjects().contains(info)) {
                imageInfo.shouldRemove = true;
            }
        };
        int hitboxIndex = hitboxIndices.get(0);
        if (hitboxIndex <= 4) {
            info.effectSelected = hitboxIndex;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, effectLocations[hitboxIndex], id, hitboxIndex, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 5) {
            info.regenSelected = true;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, regenerationLocation, id, 5, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 6) {
            info.regenSelected = false;
            if (!ImmersiveBeacon.useGrabBeacon()) return ImmersiveClientConstants.instance().defaultCooldown();
            HandImmersives.heldImageImmersive.setHeldImage(hand, addLocation, id, -1, 0.33333334f, heldItemTicker);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else if (hitboxIndex == 7) {
            int effectId = -2;
            int secondaryId = -2;
            if (ImmersiveBeacon.useGrabBeacon()) {
                List<HeldImageImmersiveInfo<?>> heldImages = HandImmersives.heldImageImmersive.getHeldImages(id);
                if (!heldImages.isEmpty()) {
                    if (info.lastLevel < 4) {
                        secondaryId = -1;
                    } else {
                        secondaryId = heldImages.stream().filter(imageInfo -> {
                            int held = (Integer)imageInfo.heldData;
                            return (held == 5 || held == -1) && ((HitboxItemPair)info.hitboxes.get((int)7)).box != null && BoundingBox.contains(((HitboxItemPair)info.hitboxes.get((int)7)).box, VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController(imageInfo.hand.ordinal()).position());
                        }).findFirst().map(heldImageImmersiveInfo -> (int)((Integer)heldImageImmersiveInfo.heldData)).orElse(-2);
                        if (secondaryId != -2) {
                            secondaryId = info.regenSelected ? class_7923.field_41174.method_10206((Object)class_1294.field_5924) : -1;
                        }
                    }
                    effectId = heldImages.stream().filter(imageInfo -> {
                        int held = (Integer)imageInfo.heldData;
                        return held >= 0 && held <= 4 && ((HitboxItemPair)info.hitboxes.get((int)7)).box != null && BoundingBox.contains(((HitboxItemPair)info.hitboxes.get((int)7)).box, VRPlugin.API.getVRPlayer((class_1657)class_310.method_1551().field_1724).getController(imageInfo.hand.ordinal()).position());
                    }).findFirst().map(heldImageImmersiveInfo -> (int)((Integer)heldImageImmersiveInfo.heldData)).orElse(-2);
                    if (effectId >= 0) {
                        info.effectSelected = effectId;
                    }
                }
            } else {
                effectId = info.effectSelected;
                int n = secondaryId = info.regenSelected ? class_7923.field_41174.method_10206((Object)class_1294.field_5924) : -1;
            }
            if (effectId < 0 || secondaryId == -2 || ((HitboxItemPair)info.hitboxes.get((int)8)).item.method_7960()) return -1;
            effectId = info.getEffectId();
            Network.INSTANCE.sendToServer(new BeaconConfirmPacket(info.getBlockPosition(), effectId, secondaryId));
            VRRumble.rumbleIfVR((class_1657)class_310.method_1551().field_1724, 0, 0.15f);
            HandImmersives.heldImageImmersive.removeImages(id);
            return ImmersiveClientConstants.instance().defaultCooldown();
        } else {
            ImmersiveClientLogicHelpers.instance().sendSwapPacket(info.getBlockPosition(), List.of(Integer.valueOf(0)), hand, false);
        }
        return ImmersiveClientConstants.instance().defaultCooldown();
    }

    @Override
    public void tick(BeaconInfo info) {
        super.tick(info);
        for (HitboxItemPair pair : info.hitboxes) {
            pair.lastPos = pair.box == null ? null : BoundingBox.getCenter(pair.box);
        }
        this.setHitboxesAndPositions(info);
        info.lastPlayerDir = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition()).method_10153();
    }

    @Nullable
    public class_238 getDragHitbox(BeaconInfo info) {
        return null;
    }

    @Override
    public boolean isInputHitbox(BeaconInfo info, int hitboxIndex) {
        return true;
    }

    @Override
    public boolean shouldRender(BeaconInfo info) {
        return info.lastPlayerDir != null && info.areaAboveIsAir && info.hasHitboxes();
    }

    @Override
    public void render(BeaconInfo info, class_4587 stack, ImmersiveRenderHelpers helpers, float partialTick) {
        helpers.renderItemWithInfo(((HitboxItemPair)info.hitboxes.get((int)8)).item, stack, 0.42f, false, info.light, info, true, 8, null, info.lastPlayerDir.method_10153(), null);
        float transitionMultiplier = helpers.getTransitionMultiplier(info.getTicksExisted());
        float effectSize = 0.2f * transitionMultiplier;
        for (int i = 0; i < info.hitboxes.size() - 1; ++i) {
            HitboxItemPair hitbox = (HitboxItemPair)info.hitboxes.get(i);
            if (hitbox.box == null) continue;
            BoundingBox renderHitbox = hitbox.getRenderHitbox(partialTick);
            helpers.renderHitbox(stack, renderHitbox);
            if (i > 4) continue;
            helpers.renderImage(stack, effectLocations[i], BoundingBox.getCenter(renderHitbox).method_1031(0.0, -0.05, 0.0), info.effectSelected == i && !ImmersiveBeacon.useGrabBeacon() ? effectSize * 1.5f : (info.isSlotHovered(i) ? effectSize * 1.25f : effectSize), info.light, info.lastPlayerDir);
        }
        float displaySize = 0.2f * transitionMultiplier;
        if (info.effectSelected != -1 && !ImmersiveBeacon.useGrabBeacon()) {
            helpers.renderImage(stack, effectLocations[info.effectSelected], info.effectSelectedDisplayPos.method_1031(0.0, -0.05, 0.0), displaySize, info.light, info.lastPlayerDir);
        }
        for (int i = 5; i <= 6; ++i) {
            HitboxItemPair hitbox = (HitboxItemPair)info.hitboxes.get(i);
            if (hitbox.box == null) continue;
            helpers.renderImage(stack, i == 5 ? regenerationLocation : addLocation, BoundingBox.getCenter(hitbox.box).method_1031(0.0, -0.05, 0.0), info.isSlotHovered(i) ? displaySize * 1.25f : displaySize, info.light, info.lastPlayerDir);
        }
        HitboxItemPair hitbox7 = (HitboxItemPair)info.hitboxes.get(7);
        if (hitbox7.box != null && info.isEffectSelected()) {
            if (ImmersiveBeacon.useGrabBeacon()) {
                helpers.renderHitbox(stack, hitbox7.box);
            } else if (info.isReadyForConfirm()) {
                helpers.renderImage(stack, confirmLocation, BoundingBox.getCenter(hitbox7.box).method_1031(0.0, -0.1, 0.0), info.isSlotHovered(7) ? 0.525f : 0.42f, info.light, info.lastPlayerDir);
            }
            class_2350 playerForward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition()).method_10153();
            double xMult = 0.0;
            double zMult = 0.0;
            if (playerForward.method_10163().method_10263() != 0) {
                zMult = 1.0;
            } else {
                xMult = 1.0;
            }
            if (!ImmersiveBeacon.useGrabBeacon()) {
                helpers.renderHitbox(stack, (BoundingBox)class_238.method_30048((class_243)info.effectSelectedDisplayPos, (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                if (info.regenSelected && ((HitboxItemPair)info.hitboxes.get((int)5)).box != null) {
                    helpers.renderHitbox(stack, (BoundingBox)class_238.method_30048((class_243)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)5)).box), (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                } else if (!info.regenSelected && ((HitboxItemPair)info.hitboxes.get((int)6)).box != null) {
                    helpers.renderHitbox(stack, (BoundingBox)class_238.method_30048((class_243)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)6)).box), (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), true, 0.0f, 1.0f, 0.0f);
                }
            }
        }
    }

    @Override
    public ImmersiveHandler<BeaconStorage> getHandler() {
        return ImmersiveHandlers.beaconHandler;
    }

    @Override
    @Nullable
    public ImmersiveConfigScreenInfo configScreenInfo() {
        return ClientUtil.createConfigScreenInfo("beacon", () -> new class_1799((class_1935)class_1802.field_8668), config -> config.useBeaconImmersive, (config, newVal) -> {
            config.useBeaconImmersive = newVal;
        });
    }

    @Override
    public boolean shouldDisableRightClicksWhenVanillaInteractionsDisabled(BeaconInfo info) {
        return false;
    }

    @Override
    public void processStorageFromNetwork(BeaconInfo info, BeaconStorage storage) {
        ((HitboxItemPair)info.hitboxes.get((int)8)).item = storage.getItem(0);
    }

    @Override
    public boolean isVROnly() {
        return false;
    }

    protected void setHitboxesAndPositions(BeaconInfo info) {
        class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(info.getBlockPosition());
        if (class_25862 instanceof class_2580) {
            class_2580 beacon = (class_2580)class_25862;
            for (int x = -1; x <= 1; ++x) {
                for (int y = 1; y <= 2; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (class_310.method_1551().field_1687.method_8320(info.getBlockPosition().method_10069(x, y, z)).method_45474()) continue;
                        info.areaAboveIsAir = false;
                        return;
                    }
                }
            }
            info.areaAboveIsAir = true;
            class_243 center = class_243.method_24953((class_2382)info.getBlockPosition()).method_1031(0.0, 1.0, 0.0);
            class_2350 beaconForward = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition());
            class_243 forwardFromBlockVec = new class_243((double)beaconForward.method_10163().method_10263(), (double)beaconForward.method_10163().method_10264(), (double)beaconForward.method_10163().method_10260());
            class_2350 left = beaconForward.method_10170();
            class_243 leftVec = new class_243((double)left.method_10163().method_10263(), (double)left.method_10163().method_10264(), (double)left.method_10163().method_10260());
            double itemHitboxSize = 0.42f;
            ((HitboxItemPair)info.hitboxes.get((int)8)).box = class_238.method_30048((class_243)class_243.method_24955((class_2382)info.getBlockPosition()).method_1019(forwardFromBlockVec.method_1021(0.25).method_1019(forwardFromBlockVec.method_1021(itemHitboxSize / 2.0)).method_1031(0.0, itemHitboxSize / 2.0 + 0.01, 0.0)), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize);
            ((HitboxItemPair)info.hitboxes.get((int)7)).box = ImmersiveBeacon.useGrabBeacon() ? new class_238(info.getBlockPosition()).method_1014(0.001) : class_238.method_30048((class_243)BoundingBox.getCenter(((HitboxItemPair)info.hitboxes.get((int)8)).box).method_1031(0.0, itemHitboxSize / 2.0 + 0.25, 0.0), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize);
            info.effectSelectedDisplayPos = center.method_1031(0.0, 0.125, 0.0).method_1019(leftVec.method_1021(-0.3333333333333333)).method_1019(forwardFromBlockVec.method_1021(0.45));
            int beaconLevel = ((BeaconBlockEntityMixin)beacon).immersiveMC$getLevels();
            if (info.lastLevel > beaconLevel) {
                if (beaconLevel == 1 && info.effectSelected > 1) {
                    info.effectSelected = -1;
                } else if (beaconLevel == 2 && info.effectSelected == 4) {
                    info.effectSelected = -1;
                }
                Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
            }
            class_2350 centerDir = ImmersiveLogicHelpers.instance().getHorizontalBlockForward((class_1657)class_310.method_1551().field_1724, info.getBlockPosition()).method_10153();
            if (beaconLevel > 0) {
                info.levelWasNonzero = true;
                long timeSinceStartMilli = Instant.now().toEpochMilli() - info.startMillis;
                long millisPerRot = 9000L;
                class_243 forwardPos = center.method_1019(leftVec.method_1021(0.8)).method_1031(0.0, 0.2, 0.0).method_1019(forwardFromBlockVec.method_1021(0.45));
                double rot0 = (double)(timeSinceStartMilli % millisPerRot) / (double)millisPerRot * 2.0 * Math.PI;
                if (beaconLevel == 1) {
                    double rot1 = rot0 + Math.PI;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 2; i < info.hitboxes.size() - 2; ++i) {
                        ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                    }
                } else if (beaconLevel == 2) {
                    rotDiff = 1.5707963267948966;
                    double rot1 = rot0 + rotDiff;
                    rot2 = rot0 + 2.0 * rotDiff;
                    rot3 = rot0 + 3.0 * rotDiff;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)2)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot2, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)3)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot3, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 4; i < info.hitboxes.size() - 2; ++i) {
                        ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                    }
                } else {
                    rotDiff = 1.2566370614359172;
                    double rot1 = rot0 + rotDiff;
                    rot2 = rot0 + 2.0 * rotDiff;
                    rot3 = rot0 + 3.0 * rotDiff;
                    double rot4 = rot0 + 4.0 * rotDiff;
                    ((HitboxItemPair)info.hitboxes.get((int)0)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot0, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)1)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot1, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)2)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot2, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)3)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot3, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    ((HitboxItemPair)info.hitboxes.get((int)4)).box = class_238.method_30048((class_243)this.posToRotatedPos(forwardPos, rot4, centerDir), (double)0.2, (double)0.2, (double)0.2);
                    if (beaconLevel == 4) {
                        if (ImmersiveBeacon.useGrabBeacon()) {
                            class_243 effectGrabPos = info.effectSelectedDisplayPos.method_1019(leftVec.method_1021(-0.25)).method_1031(0.0, -0.1, 0.0);
                            ((HitboxItemPair)info.hitboxes.get((int)5)).box = class_238.method_30048((class_243)effectGrabPos.method_1019(leftVec.method_1021(-0.11)), (double)0.2, (double)0.2, (double)0.2);
                            ((HitboxItemPair)info.hitboxes.get((int)6)).box = class_238.method_30048((class_243)effectGrabPos.method_1019(leftVec.method_1021(0.11)), (double)0.2, (double)0.2, (double)0.2);
                        } else {
                            ((HitboxItemPair)info.hitboxes.get((int)5)).box = class_238.method_30048((class_243)info.effectSelectedDisplayPos.method_1019(leftVec.method_1021(-0.25)), (double)0.2, (double)0.2, (double)0.2);
                            ((HitboxItemPair)info.hitboxes.get((int)6)).box = class_238.method_30048((class_243)info.effectSelectedDisplayPos.method_1031(0.0, -0.25, 0.0), (double)0.2, (double)0.2, (double)0.2);
                        }
                    } else {
                        for (int i = 5; i < info.hitboxes.size() - 2; ++i) {
                            ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                        }
                        info.regenSelected = false;
                    }
                }
            } else if (info.levelWasNonzero) {
                for (int i = 0; i < info.hitboxes.size(); ++i) {
                    ((HitboxItemPair)info.hitboxes.get((int)i)).box = null;
                }
                info.effectSelected = -1;
                info.regenSelected = false;
                Network.INSTANCE.sendToServer(new BeaconDataPacket(info.getBlockPosition()));
            }
            if (centerDir != info.lastPlayerDir) {
                for (HitboxItemPair hitbox : info.hitboxes) {
                    hitbox.lastPos = null;
                }
            }
            info.lastLevel = beaconLevel;
        }
        for (int i = 0; i < info.hitboxes.size(); ++i) {
            ((HitboxItemPair)info.hitboxes.get((int)i)).isTriggerHitbox = !ImmersiveBeacon.useGrabBeacon();
        }
    }

    private class_243 posToRotatedPos(class_243 forwardPos, double rotRad, class_2350 playerForwardDir) {
        double xz;
        class_243 circleCenter = forwardPos.method_1019(class_243.method_24954((class_2382)class_2350.field_11033.method_10163()).method_1021(0.2));
        class_2350.class_2351 axisFacing = playerForwardDir.method_10166();
        double d = xz = axisFacing == class_2350.class_2351.field_11051 ? circleCenter.field_1352 : circleCenter.field_1350;
        if (playerForwardDir == class_2350.field_11043 || playerForwardDir == class_2350.field_11034) {
            rotRad = -rotRad;
        }
        double newXZ = xz + 0.2 * Math.cos(rotRad) - 0.2 * Math.sin(rotRad);
        double newY = circleCenter.field_1351 + 0.2 * Math.sin(rotRad) + 0.2 * Math.cos(rotRad);
        if (axisFacing == class_2350.class_2351.field_11051) {
            return new class_243(newXZ, newY, forwardPos.field_1350);
        }
        return new class_243(forwardPos.field_1352, newY, newXZ);
    }

    public static boolean useGrabBeacon() {
        return VRPluginVerify.clientInVR() && ActiveConfig.active().useGrabBeaconInVR;
    }
}

